/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockservice;

import com.eviware.soapui.impl.wsdl.actions.project.StartLoadUI;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.integration.loadui.IntegrationUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunMockServiceWithLoadUIAction
extends AbstractSoapUIAction<WsdlMockService> {
    private XFormDialog dialog;
    public static final String SOAPUI_ACTION_ID = "RunMockServiceWithLoadUIAction";

    public RunMockServiceWithLoadUIAction() {
        super("Run with loadUI", "Run this MockService with loadUI");
    }

    @Override
    public void perform(WsdlMockService mockService, Object param) {
        if (IntegrationUtils.forceSaveProject(mockService.getProject())) {
            if (!StartLoadUI.testCajoConnection()) {
                if (UISupport.confirm("For this action you have to launch loadUI. Launch it now?", "Launch loadUI")) {
                    StartLoadUI.launchLoadUI();
                }
                return;
            }
            String soapUIMockService = mockService.getName();
            String mockServicePath = mockService.getPath();
            String mockservicePort = Integer.toString(mockService.getPort());
            String soapUIProjectPath = mockService.getProject().getPath();
            if (this.dialog == null) {
                this.dialog = ADialogBuilder.buildDialog(Form.class);
            }
            this.dialog.getFormField("Target Project").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    RunMockServiceWithLoadUIAction.this.dialog.setOptions("Target TestCase", IntegrationUtils.getAvailableTestCases(newValue));
                    if (RunMockServiceWithLoadUIAction.this.dialog.getValue("Target TestCase").equals("<Project Level>")) {
                        RunMockServiceWithLoadUIAction.this.dialog.setOptions("Target MockService Runner", IntegrationUtils.getAvailableRunners(newValue, "<Project Level>"));
                    }
                }
            });
            this.dialog.getFormField("Target TestCase").addFormFieldListener(new XFormFieldListener(){

                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    if (newValue.equals("<Create New>")) {
                        RunMockServiceWithLoadUIAction.this.dialog.setOptions("Target MockService Runner", new String[]{"<Create New>"});
                    } else {
                        RunMockServiceWithLoadUIAction.this.dialog.setOptions("Target MockService Runner", IntegrationUtils.getAvailableMockServiceRunners(RunMockServiceWithLoadUIAction.this.dialog.getValue("Target Project"), newValue));
                    }
                }
            });
            this.dialog.setOptions("Target Project", IntegrationUtils.getAvailableProjects());
            if (!StringUtils.isNullOrEmpty(IntegrationUtils.getOpenedProjectName())) {
                this.dialog.setValue("Target Project", IntegrationUtils.getOpenedProjectName());
            } else {
                this.dialog.setValue("Target Project", "<Create New>");
            }
            this.dialog.setOptions("Target TestCase", IntegrationUtils.getAvailableTestCases(this.dialog.getValue("Target Project")));
            if (!this.dialog.getValue("Target Project").equals(IntegrationUtils.getOpenedProjectName())) {
                this.dialog.setValue("Target TestCase", "<Project Level>");
            }
            this.dialog.setOptions("Target MockService Runner", IntegrationUtils.getAvailableMockServiceRunners(this.dialog.getValue("Target Project"), this.dialog.getValue("Target TestCase")));
            this.dialog.setValue("Target MockService Runner", "<Create New>");
            if (this.dialog.show()) {
                String targetProjectString = this.dialog.getValue("Target Project");
                String targetTestCaseName = !this.dialog.getValue("Target TestCase").equals("<Project Level>") ? this.dialog.getValue("Target TestCase") : null;
                String targetMockRunnerNameName = this.dialog.getValue("Target MockService Runner");
                if (this.dialog.getReturnValue() == 1) {
                    String openedProjectName = IntegrationUtils.getOpenedProjectName();
                    if (!StringUtils.isNullOrEmpty(openedProjectName) && !targetProjectString.equals(openedProjectName) && IntegrationUtils.checkOpenedLoadUIProjectForClose()) {
                        return;
                    }
                    HashMap<String, String> createdRunnerSettings = null;
                    try {
                        createdRunnerSettings = IntegrationUtils.createMockServiceRunner(soapUIProjectPath, soapUIMockService, mockServicePath, mockservicePort, targetProjectString, targetTestCaseName, targetMockRunnerNameName);
                    }
                    catch (IOException e) {
                        UISupport.showInfoMessage("Error while opening selected loadUI project");
                        return;
                    }
                }
            }
        }
    }

    @AForm(description="Specify Items in loadUI for Running TestCase", name="Run With loadUI", helpUrl="http://www.soapui.org/userguide/functional/testcases.html#Clone_TestCase", icon="/runWithLoadui.png")
    protected static interface Form {
        @AField(name="Target Project", description="The target Project in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String PROJECT = "Target Project";
        @AField(name="Target TestCase", description="The name of the target TestCase in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String TESTCASE = "Target TestCase";
        @AField(name="Target MockService Runner", description="The target MockService Runner in loadUI", type=AField.AFieldType.ENUMERATION)
        public static final String MOCKSERVICERUNNER = "Target MockService Runner";
    }
}

