/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface;

import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneInterfaceAction
extends AbstractSoapUIAction<WsdlInterface> {
    public CloneInterfaceAction() {
        super("Clone Interface", "Clones this Interface to another project");
    }

    @Override
    public void perform(WsdlInterface iface, Object param) {
        WsdlInterface targetIface;
        WorkspaceImpl workspace = iface.getProject().getWorkspace();
        String[] names = ModelSupport.getNames(workspace.getOpenProjectList(), new String[]{"<Create New>"});
        ArrayList<String> asList = new ArrayList<String>(Arrays.asList(names));
        asList.remove(iface.getProject().getName());
        String targetProjectName = UISupport.prompt("Select target Project for cloned Interface", "Clone Interface", asList);
        if (targetProjectName == null) {
            return;
        }
        WsdlProject targetProject = (WsdlProject)workspace.getProjectByName(targetProjectName);
        if (targetProject == null) {
            targetProjectName = UISupport.prompt("Enter name for new Project", "Clone TestSuite", "");
            if (targetProjectName == null) {
                return;
            }
            try {
                targetProject = workspace.createProject(targetProjectName, null);
            }
            catch (SoapUIException e) {
                UISupport.showErrorMessage(e);
            }
            if (targetProject == null) {
                return;
            }
        }
        if ((targetIface = (WsdlInterface)targetProject.getInterfaceByTechnicalId(iface.getTechnicalId())) != null) {
            UISupport.showErrorMessage("Target Project already contains Interface for binding");
        } else {
            boolean importEndpoints = UISupport.confirm("Import endpoint defaults also?", this.getName());
            UISupport.select(targetProject.importInterface(iface, importEndpoints, true));
        }
    }
}

