/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.InterfaceConfig;
import com.eviware.soapui.config.MockServiceConfig;
import com.eviware.soapui.config.MockServiceDocumentConfig;
import com.eviware.soapui.config.ProjectConfig;
import com.eviware.soapui.config.SecurityTestConfig;
import com.eviware.soapui.config.SoapuiProjectDocumentConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.config.TestStepSecurityTestConfig;
import com.eviware.soapui.config.TestSuiteConfig;
import com.eviware.soapui.config.TestSuiteDocumentConfig;
import com.eviware.soapui.config.TestSuiteRunTypesConfig;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.WsdlInterfaceFactory;
import com.eviware.soapui.impl.rest.support.RestRequestConverter;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractInterface;
import com.eviware.soapui.impl.support.EndpointSupport;
import com.eviware.soapui.impl.wsdl.AbstractTestPropertyHolderWsdlModelItem;
import com.eviware.soapui.impl.wsdl.InterfaceFactoryRegistry;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.endpoint.DefaultEndpointStrategy;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.support.wsdl.UrlWsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.testcase.WsdlProjectRunner;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.environment.DefaultEnvironment;
import com.eviware.soapui.model.environment.Environment;
import com.eviware.soapui.model.environment.EnvironmentListener;
import com.eviware.soapui.model.environment.Property;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.EndpointStrategy;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.project.ProjectListener;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContainer;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.ProjectRunContext;
import com.eviware.soapui.model.testsuite.ProjectRunListener;
import com.eviware.soapui.model.testsuite.ProjectRunner;
import com.eviware.soapui.model.testsuite.TestRunnable;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.settings.ProjectSettings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.resolver.ResolveDialog;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.apache.commons.ssl.OpenSSL;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlProject
extends AbstractTestPropertyHolderWsdlModelItem<ProjectConfig>
implements Project,
PropertyExpansionContainer,
PropertyChangeListener,
TestRunnable {
    public static final String AFTER_LOAD_SCRIPT_PROPERTY = WsdlProject.class.getName() + "@setupScript";
    public static final String BEFORE_SAVE_SCRIPT_PROPERTY = WsdlProject.class.getName() + "@tearDownScript";
    public static final String RESOURCE_ROOT_PROPERTY = WsdlProject.class.getName() + "@resourceRoot";
    private WorkspaceImpl workspace;
    protected String path;
    protected List<AbstractInterface<?>> interfaces = new ArrayList();
    protected List<WsdlTestSuite> testSuites = new ArrayList<WsdlTestSuite>();
    protected List<WsdlMockService> mockServices = new ArrayList<WsdlMockService>();
    protected Set<ProjectListener> projectListeners = new HashSet<ProjectListener>();
    protected SoapuiProjectDocumentConfig projectDocument;
    private ImageIcon disabledIcon;
    private ImageIcon closedIcon;
    private ImageIcon remoteIcon;
    private ImageIcon openEncyptedIcon;
    protected EndpointStrategy endpointStrategy = new DefaultEndpointStrategy();
    protected long lastModified;
    private boolean remote;
    private boolean open = true;
    private boolean disabled;
    private SoapUIScriptEngine afterLoadScriptEngine;
    private SoapUIScriptEngine beforeSaveScriptEngine;
    private PropertyExpansionContext context = new DefaultPropertyExpansionContext(this);
    protected DefaultWssContainer wssContainer;
    private String projectPassword = null;
    private String hermesConfig;
    private boolean wrongPasswordSupplied;
    protected Set<EnvironmentListener> environmentListeners = new HashSet<EnvironmentListener>();
    protected int encrypted;
    private ImageIcon closedEncyptedIcon;
    private SoapUIScriptEngine afterRunScriptEngine;
    private SoapUIScriptEngine beforeRunScriptEngine;
    private Set<ProjectRunListener> runListeners = new HashSet<ProjectRunListener>();
    private Environment environment;
    protected EndpointSupport endpointSupport;
    protected static final Logger log = Logger.getLogger(WsdlProject.class);
    private static Map<String, String> checkToScanMap = WsdlProject.initCheckToScanMap();

    public WsdlProject() throws XmlException, IOException, SoapUIException {
        this((WorkspaceImpl)null);
    }

    public WsdlProject(String path) throws XmlException, IOException, SoapUIException {
        this(path, (WorkspaceImpl)null);
    }

    public WsdlProject(String projectFile, String projectPassword) {
        this(projectFile, null, true, true, null, projectPassword);
    }

    public WsdlProject(WorkspaceImpl workspace) {
        this(null, workspace, true);
    }

    public WsdlProject(String path, WorkspaceImpl workspace) {
        this(path, workspace, true);
    }

    public WsdlProject(String path, WorkspaceImpl workspace, boolean create) {
        this(path, workspace, create, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WsdlProject(String path, WorkspaceImpl workspace, boolean create, boolean open, String tempName, String projectPassword) {
        super(null, workspace, "/project.gif");
        this.workspace = workspace;
        this.path = path;
        this.projectPassword = projectPassword;
        this.endpointSupport = new EndpointSupport();
        for (ProjectListener projectListener : SoapUI.getListenerRegistry().getListeners(ProjectListener.class)) {
            this.addProjectListener(projectListener);
        }
        for (ProjectRunListener projectRunListener : SoapUI.getListenerRegistry().getListeners(ProjectRunListener.class)) {
            this.addProjectRunListener(projectRunListener);
        }
        try {
            try {
                if (path != null && open) {
                    File file = new File(path.trim());
                    if (file.exists()) {
                        try {
                            this.loadProject(file.toURI().toURL());
                            this.lastModified = file.lastModified();
                        }
                        catch (MalformedURLException malformedURLException) {
                            SoapUI.logError(malformedURLException);
                            this.disabled = true;
                        }
                    } else {
                        try {
                            if (!PathUtils.isHttpPath(path)) {
                                SoapUI.log.info((Object)("File [" + file.getAbsolutePath() + "] does not exist, trying URL instead"));
                            }
                            this.remote = true;
                            this.loadProject(new URL(path));
                        }
                        catch (MalformedURLException malformedURLException) {
                            SoapUI.logError(malformedURLException);
                            this.disabled = true;
                        }
                    }
                }
                Object var10_14 = null;
            }
            catch (SoapUIException e) {
                SoapUI.logError(e);
                this.disabled = true;
                Object var10_15 = null;
                this.closedIcon = UISupport.createImageIcon("/closedProject.gif");
                this.remoteIcon = UISupport.createImageIcon("/remoteProject.gif");
                this.disabledIcon = UISupport.createImageIcon("/disabledProject.gif");
                this.openEncyptedIcon = UISupport.createImageIcon("/openEncryptedProject.gif");
                this.closedEncyptedIcon = UISupport.createImageIcon("/closedEncryptedProject.gif");
                boolean bl = this.open = open && !this.disabled && this.encrypted != -1;
                if (this.projectDocument == null) {
                    this.projectDocument = SoapuiProjectDocumentConfig.Factory.newInstance();
                    this.setConfig(this.projectDocument.addNewSoapuiProject());
                    if (tempName != null || path != null) {
                        ((ProjectConfig)this.getConfig()).setName(StringUtils.isNullOrEmpty(tempName) ? this.getNameFromPath() : tempName);
                    }
                    this.setPropertiesConfig(((ProjectConfig)this.getConfig()).addNewProperties());
                    this.wssContainer = new DefaultWssContainer(this, ((ProjectConfig)this.getConfig()).addNewWssContainer());
                }
                if (this.getConfig() != null) {
                    this.endpointStrategy.init(this);
                }
                if (this.getSettings() != null) {
                    this.setProjectRoot(path);
                }
                if (this.getConfig() != null && this.environment == null) {
                    this.setActiveEnvironment(DefaultEnvironment.getInstance());
                }
                this.addPropertyChangeListener(this);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.closedIcon = UISupport.createImageIcon("/closedProject.gif");
            this.remoteIcon = UISupport.createImageIcon("/remoteProject.gif");
            this.disabledIcon = UISupport.createImageIcon("/disabledProject.gif");
            this.openEncyptedIcon = UISupport.createImageIcon("/openEncryptedProject.gif");
            this.closedEncyptedIcon = UISupport.createImageIcon("/closedEncryptedProject.gif");
            boolean bl = this.open = open && !this.disabled && this.encrypted != -1;
            if (this.projectDocument == null) {
                this.projectDocument = SoapuiProjectDocumentConfig.Factory.newInstance();
                this.setConfig(this.projectDocument.addNewSoapuiProject());
                if (tempName != null || path != null) {
                    ((ProjectConfig)this.getConfig()).setName(StringUtils.isNullOrEmpty(tempName) ? this.getNameFromPath() : tempName);
                }
                this.setPropertiesConfig(((ProjectConfig)this.getConfig()).addNewProperties());
                this.wssContainer = new DefaultWssContainer(this, ((ProjectConfig)this.getConfig()).addNewWssContainer());
            }
            if (this.getConfig() != null) {
                this.endpointStrategy.init(this);
            }
            if (this.getSettings() != null) {
                this.setProjectRoot(path);
            }
            if (this.getConfig() != null && this.environment == null) {
                this.setActiveEnvironment(DefaultEnvironment.getInstance());
            }
            this.addPropertyChangeListener(this);
            throw throwable;
        }
        this.closedIcon = UISupport.createImageIcon("/closedProject.gif");
        this.remoteIcon = UISupport.createImageIcon("/remoteProject.gif");
        this.disabledIcon = UISupport.createImageIcon("/disabledProject.gif");
        this.openEncyptedIcon = UISupport.createImageIcon("/openEncryptedProject.gif");
        this.closedEncyptedIcon = UISupport.createImageIcon("/closedEncryptedProject.gif");
        boolean bl = this.open = open && !this.disabled && this.encrypted != -1;
        if (this.projectDocument == null) {
            this.projectDocument = SoapuiProjectDocumentConfig.Factory.newInstance();
            this.setConfig(this.projectDocument.addNewSoapuiProject());
            if (tempName != null || path != null) {
                ((ProjectConfig)this.getConfig()).setName(StringUtils.isNullOrEmpty(tempName) ? this.getNameFromPath() : tempName);
            }
            this.setPropertiesConfig(((ProjectConfig)this.getConfig()).addNewProperties());
            this.wssContainer = new DefaultWssContainer(this, ((ProjectConfig)this.getConfig()).addNewWssContainer());
        }
        if (this.getConfig() != null) {
            this.endpointStrategy.init(this);
        }
        if (this.getSettings() != null) {
            this.setProjectRoot(path);
        }
        if (this.getConfig() != null && this.environment == null) {
            this.setActiveEnvironment(DefaultEnvironment.getInstance());
        }
        this.addPropertyChangeListener(this);
    }

    public boolean isRemote() {
        return this.remote;
    }

    public EndpointSupport getEndpointSupport() {
        return this.endpointSupport;
    }

    public void loadProject(URL file) throws SoapUIException {
        try {
            try {
                UISupport.setHourglassCursor();
                UrlWsdlLoader loader = new UrlWsdlLoader(file.toString(), this);
                loader.setUseWorker(false);
                this.projectDocument = SoapuiProjectDocumentConfig.Factory.parse((InputStream)loader.load());
                this.encrypted = this.checkForEncodedData(this.projectDocument.getSoapuiProject());
                this.setConfig(this.projectDocument.getSoapuiProject());
                if (!this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS)) {
                    this.removeDefinitionCaches(this.projectDocument);
                }
                log.info((Object)("Loaded project from [" + file.toString() + "]"));
                try {
                    int majorVersion = Integer.parseInt(this.projectDocument.getSoapuiProject().getSoapuiVersion().split("\\.")[0]);
                    if (majorVersion > Integer.parseInt("4.5.1".split("\\.")[0])) {
                        log.warn((Object)("Project '" + this.projectDocument.getSoapuiProject().getName() + "' is from a newer version (" + this.projectDocument.getSoapuiProject().getSoapuiVersion() + ") of soapUI than this (" + "4.5.1" + ") and parts of it may be incompatible or incorrect. " + "Saving this project with this version of soapUI may cause it to function differently."));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!((ProjectConfig)this.getConfig()).isSetProperties()) {
                    ((ProjectConfig)this.getConfig()).addNewProperties();
                }
                this.setPropertiesConfig(((ProjectConfig)this.getConfig()).getProperties());
                List interfaceConfigs = ((ProjectConfig)this.getConfig()).getInterfaceList();
                for (InterfaceConfig config : interfaceConfigs) {
                    AbstractInterface<?> iface = InterfaceFactoryRegistry.build(this, config);
                    this.interfaces.add(iface);
                }
                List testSuiteConfigs = ((ProjectConfig)this.getConfig()).getTestSuiteList();
                for (TestSuiteConfig config : testSuiteConfigs) {
                    this.testSuites.add(this.buildTestSuite(config));
                }
                List mockServiceConfigs = ((ProjectConfig)this.getConfig()).getMockServiceList();
                for (MockServiceConfig config : mockServiceConfigs) {
                    this.mockServices.add(new WsdlMockService(this, config));
                }
                if (!((ProjectConfig)this.getConfig()).isSetWssContainer()) {
                    ((ProjectConfig)this.getConfig()).addNewWssContainer();
                }
                this.wssContainer = new DefaultWssContainer(this, ((ProjectConfig)this.getConfig()).getWssContainer());
                this.endpointStrategy.init(this);
                this.setActiveEnvironment(DefaultEnvironment.getInstance());
                if (!((ProjectConfig)this.getConfig()).isSetAbortOnError()) {
                    ((ProjectConfig)this.getConfig()).setAbortOnError(false);
                }
                if (!((ProjectConfig)this.getConfig()).isSetRunType()) {
                    ((ProjectConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.SEQUENTIAL);
                }
                this.afterLoad();
            }
            catch (Exception e) {
                XmlException xe;
                XmlError error;
                if (e instanceof XmlException && (error = (xe = (XmlException)((Object)e)).getError()) != null) {
                    System.err.println("Error at line " + error.getLine() + ", column " + error.getColumn());
                }
                if (e instanceof RestRequestConverter.RestConversionException) {
                    log.error((Object)"Project file needs to be updated manually, please reload the project.");
                    throw new SoapUIException("Failed to load project from file [" + file.toString() + "]", e);
                }
                e.printStackTrace();
                throw new SoapUIException("Failed to load project from file [" + file.toString() + "]", e);
            }
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            UISupport.resetCursor();
            throw throwable;
        }
        UISupport.resetCursor();
    }

    public Environment getActiveEnvironment() {
        return this.environment;
    }

    public void setActiveEnvironment(Environment environment) {
        if (!environment.equals(this.environment)) {
            this.environment = environment;
            ((ProjectConfig)this.getConfig()).setActiveEnvironment(environment.getName());
            this.fireEnvironmentSwitched(environment);
        }
    }

    public boolean isEnvironmentMode() {
        return false;
    }

    protected WsdlTestSuite buildTestSuite(TestSuiteConfig config) {
        return new WsdlTestSuite(this, config);
    }

    public boolean isWrongPasswordSupplied() {
        return this.wrongPasswordSupplied;
    }

    protected int checkForEncodedData(ProjectConfig soapuiProject) throws IOException, GeneralSecurityException {
        byte[] encryptedContent = soapuiProject.getEncryptedContent();
        char[] password = null;
        if (encryptedContent == null || encryptedContent.length == 0) {
            return 0;
        }
        String projectPassword = null;
        projectPassword = this.workspace != null ? this.workspace.getProjectPassword(soapuiProject.getName()) : this.projectPassword;
        password = projectPassword == null ? UISupport.promptPassword("Enter Password:", soapuiProject.getName()) : projectPassword.toCharArray();
        byte[] data = null;
        if (password == null) {
            return -1;
        }
        try {
            data = OpenSSL.decrypt((String)"des3", (char[])password, (byte[])encryptedContent);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return -1;
        }
        String decryptedData = new String(data, "UTF-8");
        if (decryptedData != null) {
            if (decryptedData.length() > 0) {
                try {
                    this.projectDocument.getSoapuiProject().set(XmlUtils.createXmlObject(decryptedData));
                    this.wrongPasswordSupplied = false;
                }
                catch (XmlException e) {
                    UISupport.showErrorMessage("Wrong password. Project needs to be reloaded.");
                    this.wrongPasswordSupplied = true;
                    this.getWorkspace().clearProjectPassword(soapuiProject.getName());
                    return -1;
                }
            }
        } else {
            UISupport.showErrorMessage("Wrong project password");
            this.wrongPasswordSupplied = true;
            this.getWorkspace().clearProjectPassword(soapuiProject.getName());
            return -1;
        }
        this.projectDocument.getSoapuiProject().setEncryptedContent(null);
        return 1;
    }

    @Override
    public void afterLoad() {
        super.afterLoad();
        try {
            ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
            for (int c = 0; c < a.length; ++c) {
                a[c].afterLoad(this);
            }
            this.runAfterLoadScript();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    protected void setProjectRoot(String path) {
        int ix;
        if (path != null && this.projectDocument != null && (ix = path.lastIndexOf(File.separatorChar)) > 0) {
            this.getSettings().setString(ProjectSettings.PROJECT_ROOT, path.substring(0, ix));
        }
    }

    public void setResourceRoot(String resourceRoot) {
        String old = this.getResourceRoot();
        ((ProjectConfig)this.getConfig()).setResourceRoot(resourceRoot);
        this.notifyPropertyChanged(RESOURCE_ROOT_PROPERTY, old, resourceRoot);
    }

    @Override
    public String getResourceRoot() {
        if (!((ProjectConfig)this.getConfig()).isSetResourceRoot()) {
            ((ProjectConfig)this.getConfig()).setResourceRoot("");
        }
        return ((ProjectConfig)this.getConfig()).getResourceRoot();
    }

    @Override
    public ImageIcon getIcon() {
        if (this.isDisabled()) {
            return this.disabledIcon;
        }
        if (this.getEncrypted() != 0) {
            if (this.isOpen()) {
                return this.openEncyptedIcon;
            }
            return this.closedEncyptedIcon;
        }
        if (!this.isOpen()) {
            return this.closedIcon;
        }
        if (this.isRemote()) {
            return this.remoteIcon;
        }
        return super.getIcon();
    }

    private String getNameFromPath() {
        int ix = this.path.lastIndexOf(this.isRemote() ? 47 : (int)File.separatorChar);
        String name = ix == -1 ? this.path : this.path.substring(ix + 1);
        return name;
    }

    @Override
    public String getDescription() {
        if (this.isOpen()) {
            return super.getDescription();
        }
        String name = this.getName();
        name = this.isDisabled() ? name + " - disabled [" + this.getPath() + "]" : name + " - closed [" + this.getPath() + "]";
        return name;
    }

    @Override
    public WorkspaceImpl getWorkspace() {
        return this.workspace;
    }

    @Override
    public AbstractInterface<?> getInterfaceAt(int index) {
        return this.interfaces.get(index);
    }

    @Override
    public AbstractInterface<?> getInterfaceByName(String interfaceName) {
        return (AbstractInterface)this.getWsdlModelItemByName(this.interfaces, interfaceName);
    }

    public AbstractInterface<?> getInterfaceByTechnicalId(String technicalId) {
        for (int c = 0; c < this.getInterfaceCount(); ++c) {
            if (!this.getInterfaceAt(c).getTechnicalId().equals(technicalId)) continue;
            return this.getInterfaceAt(c);
        }
        return null;
    }

    @Override
    public int getInterfaceCount() {
        return this.interfaces.size();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean save() throws IOException {
        return this.save(null);
    }

    public boolean save(String folder) throws IOException {
        if (!this.isOpen() || this.isDisabled() || this.isRemote()) {
            return true;
        }
        if (this.path == null || this.isRemote()) {
            this.path = StringUtils.createFileName2(this.getName(), '-') + "-soapui-project.xml";
            if (folder != null) {
                this.path = folder + File.separatorChar + this.path;
            }
            File file = null;
            while (file == null || file.exists() && !UISupport.confirm("File [" + file.getName() + "] exists, overwrite?", "Overwrite File?")) {
                file = UISupport.getFileDialogs().saveAs(this, "Save project " + this.getName(), ".xml", "XML Files (*.xml)", new File(this.path));
                if (file != null) continue;
                return false;
            }
            this.path = file.getAbsolutePath();
        }
        File projectFile = new File(this.path);
        while (projectFile.exists() && !projectFile.canWrite()) {
            if (UISupport.confirm("Project file [" + this.path + "] can not be written to, save to new file?", "Save Project")) {
                projectFile = UISupport.getFileDialogs().saveAs(this, "Save project " + this.getName(), ".xml", "XML Files (*.xml)", projectFile);
                if (projectFile == null) {
                    return false;
                }
                this.path = projectFile.getAbsolutePath();
                continue;
            }
            return false;
        }
        if (projectFile.exists() && this.lastModified != 0L && this.lastModified < projectFile.lastModified() && !UISupport.confirm("Project file for [" + this.getName() + "] has been modified externally, overwrite?", "Save Project")) {
            return false;
        }
        if (projectFile.exists() && this.getSettings().getBoolean(UISettings.CREATE_BACKUP)) {
            this.createBackup(projectFile);
        }
        return this.saveIn(projectFile);
    }

    public boolean saveBackup() throws IOException {
        File projectFile = this.path == null || this.isRemote() ? new File(StringUtils.createFileName2(this.getName(), '-') + "-soapui-project.xml") : new File(this.path);
        File backupFile = this.getBackupFile(projectFile);
        return this.saveIn(backupFile);
    }

    public boolean saveIn(File projectFile) throws IOException {
        long size = 0L;
        this.beforeSave();
        SoapuiProjectDocumentConfig projectDocument = (SoapuiProjectDocumentConfig)this.projectDocument.copy();
        if (!this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS)) {
            this.removeDefinitionCaches(projectDocument);
        }
        XmlBeansSettingsImpl tempSettings = new XmlBeansSettingsImpl(this, null, projectDocument.getSoapuiProject().getSettings());
        tempSettings.clearSetting(ProjectSettings.PROJECT_ROOT);
        String passwordForEncryption = this.getSettings().getString(ProjectSettings.SHADOW_PASSWORD, null);
        if (projectDocument.getSoapuiProject().getEncryptedContent() == null && passwordForEncryption != null) {
            if (passwordForEncryption.length() > 1) {
                try {
                    String data = ((ProjectConfig)this.getConfig()).xmlText();
                    byte[] encrypted = OpenSSL.encrypt((String)"des3", (char[])passwordForEncryption.toCharArray(), (byte[])data.getBytes());
                    projectDocument.getSoapuiProject().setEncryptedContent(encrypted);
                    projectDocument.getSoapuiProject().setInterfaceArray(null);
                    projectDocument.getSoapuiProject().setTestSuiteArray(null);
                    projectDocument.getSoapuiProject().setMockServiceArray(null);
                    projectDocument.getSoapuiProject().unsetWssContainer();
                    projectDocument.getSoapuiProject().unsetSettings();
                    projectDocument.getSoapuiProject().unsetProperties();
                }
                catch (GeneralSecurityException e) {
                    UISupport.showErrorMessage("Encryption Error");
                }
            } else {
                projectDocument.getSoapuiProject().setEncryptedContent(null);
            }
        }
        XmlOptions options = new XmlOptions();
        if (SoapUI.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_PROJECT_FILES)) {
            options.setSavePrettyPrint();
        }
        projectDocument.getSoapuiProject().setSoapuiVersion("4.5.1");
        try {
            File tempFile = File.createTempFile("project-temp-", ".xml", projectFile.getParentFile());
            FileOutputStream tempOut = new FileOutputStream(tempFile);
            projectDocument.save((OutputStream)tempOut, options);
            tempOut.close();
            if (this.getSettings().getBoolean(UISettings.LINEBREAK)) {
                WsdlProject.normalizeLineBreak(projectFile, tempFile);
            } else {
                FileOutputStream projectOut = new FileOutputStream(projectFile);
                projectDocument.save((OutputStream)projectOut, options);
                projectOut.close();
                if (!tempFile.delete()) {
                    SoapUI.getErrorLog().warn((Object)("Failed to delete temporary project file; " + tempFile.getAbsolutePath()));
                    tempFile.deleteOnExit();
                }
            }
            if (!tempFile.delete()) {
                SoapUI.getErrorLog().warn((Object)("Failed to delete temporary project file; " + tempFile.getAbsolutePath()));
                tempFile.deleteOnExit();
            }
            size = projectFile.length();
        }
        catch (Throwable t) {
            SoapUI.logError(t);
            UISupport.showErrorMessage("Failed to save project [" + this.getName() + "]: " + t.toString());
            return false;
        }
        this.lastModified = projectFile.lastModified();
        log.info((Object)("Saved project [" + this.getName() + "] to [" + projectFile.getAbsolutePath() + " - " + size + " bytes"));
        this.setProjectRoot(this.getPath());
        return true;
    }

    private static void normalizeLineBreak(File target, File tmpFile) throws IOException {
        FileReader fr = new FileReader(tmpFile);
        BufferedReader in = new BufferedReader(fr);
        FileWriter fw = new FileWriter(target);
        BufferedWriter out = new BufferedWriter(fw);
        String line = "";
        while ((line = in.readLine()) != null) {
            out.write(line);
            out.newLine();
            out.flush();
        }
        out.close();
        fw.close();
        in.close();
        fr.close();
    }

    @Override
    public void beforeSave() {
        try {
            ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
            for (int c = 0; c < a.length; ++c) {
                a[c].beforeSave(this);
            }
            this.runBeforeSaveScript();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        for (AbstractInterface<?> iface : this.interfaces) {
            iface.beforeSave();
        }
        for (WsdlTestSuite testSuite : this.testSuites) {
            testSuite.beforeSave();
        }
        for (WsdlMockService mockService : this.mockServices) {
            mockService.beforeSave();
        }
        this.endpointStrategy.onSave();
    }

    protected void createBackup(File projectFile) throws IOException {
        File backupFile = this.getBackupFile(projectFile);
        log.info((Object)("Backing up [" + projectFile + "] to [" + backupFile + "]"));
        Tools.copyFile(projectFile, backupFile, true);
    }

    protected File getBackupFile(File projectFile) {
        String backupFolderName = this.getSettings().getString(UISettings.BACKUP_FOLDER, "");
        File backupFolder = new File(backupFolderName);
        if (!backupFolder.isAbsolute()) {
            backupFolder = new File(projectFile.getParentFile(), backupFolderName);
        }
        if (!backupFolder.exists()) {
            backupFolder.mkdirs();
        }
        File backupFile = new File(backupFolder, projectFile.getName() + ".backup");
        return backupFile;
    }

    protected void removeDefinitionCaches(SoapuiProjectDocumentConfig config) {
        for (InterfaceConfig ifaceConfig : config.getSoapuiProject().getInterfaceList()) {
            if (!ifaceConfig.isSetDefinitionCache()) continue;
            log.info((Object)("Removing definition cache from interface [" + ifaceConfig.getName() + "]"));
            ifaceConfig.unsetDefinitionCache();
        }
    }

    public AbstractInterface<?> addNewInterface(String name, String type) {
        AbstractInterface<?> iface = InterfaceFactoryRegistry.createNew(this, type, name);
        if (iface != null) {
            iface.getConfig().setType(type);
            this.interfaces.add(iface);
            this.fireInterfaceAdded(iface);
        }
        return iface;
    }

    @Override
    public void addProjectListener(ProjectListener listener) {
        this.projectListeners.add(listener);
    }

    @Override
    public void removeProjectListener(ProjectListener listener) {
        this.projectListeners.remove(listener);
    }

    public void fireInterfaceAdded(AbstractInterface<?> iface) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].interfaceAdded(iface);
        }
    }

    public void fireInterfaceRemoved(AbstractInterface<?> iface) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].interfaceRemoved(iface);
        }
    }

    public void fireInterfaceUpdated(AbstractInterface<?> iface) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].interfaceUpdated(iface);
        }
    }

    public void fireTestSuiteAdded(WsdlTestSuite testSuite) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testSuiteAdded(testSuite);
        }
    }

    private void fireTestSuiteMoved(WsdlTestSuite testCase, int ix, int offset) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testSuiteMoved(testCase, ix, offset);
        }
    }

    public void fireTestSuiteRemoved(WsdlTestSuite testSuite) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testSuiteRemoved(testSuite);
        }
    }

    public void fireMockServiceAdded(WsdlMockService mockService) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].mockServiceAdded(mockService);
        }
    }

    public void fireMockServiceRemoved(WsdlMockService mockService) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].mockServiceRemoved(mockService);
        }
    }

    public void fireEnvironmentAdded(Environment env) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].environmentAdded(env);
        }
    }

    private void fireEnvironmentSwitched(Environment environment) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].environmentSwitched(environment);
        }
    }

    public void fireEnvironmentRemoved(Environment env, int index) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].environmentRemoved(env, index);
        }
    }

    public void fireEnvironmentRenamed(Environment env, String oldName, String newName) {
        ProjectListener[] a = this.projectListeners.toArray(new ProjectListener[this.projectListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].environmentRenamed(env, oldName, newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterface(AbstractInterface<?> iface) {
        int ix = this.interfaces.indexOf(iface);
        this.interfaces.remove(ix);
        try {
            this.fireInterfaceRemoved(iface);
            Object var4_3 = null;
            iface.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            iface.release();
            ((ProjectConfig)this.getConfig()).removeInterface(ix);
            throw throwable;
        }
        ((ProjectConfig)this.getConfig()).removeInterface(ix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestSuite(WsdlTestSuite testSuite) {
        int ix = this.testSuites.indexOf(testSuite);
        this.testSuites.remove(ix);
        try {
            this.fireTestSuiteRemoved(testSuite);
            Object var4_3 = null;
            testSuite.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            testSuite.release();
            ((ProjectConfig)this.getConfig()).removeTestSuite(ix);
            throw throwable;
        }
        ((ProjectConfig)this.getConfig()).removeTestSuite(ix);
    }

    public void firePropertyValueChanged(Property property) {
        EnvironmentListener[] a = this.environmentListeners.toArray(new EnvironmentListener[this.environmentListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].propertyValueChanged(property);
        }
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public int getTestSuiteCount() {
        return this.testSuites.size();
    }

    @Override
    public WsdlTestSuite getTestSuiteAt(int index) {
        return this.testSuites.get(index);
    }

    @Override
    public WsdlTestSuite getTestSuiteByName(String testSuiteName) {
        return (WsdlTestSuite)this.getWsdlModelItemByName(this.testSuites, testSuiteName);
    }

    @Override
    public WsdlTestSuite addNewTestSuite(String name) {
        WsdlTestSuite testSuite = this.buildTestSuite(((ProjectConfig)this.getConfig()).addNewTestSuite());
        testSuite.setName(name);
        this.testSuites.add(testSuite);
        this.fireTestSuiteAdded(testSuite);
        return testSuite;
    }

    public boolean isCacheDefinitions() {
        return this.getSettings().getBoolean(WsdlSettings.CACHE_WSDLS);
    }

    public void setCacheDefinitions(boolean cacheDefinitions) {
        this.getSettings().setBoolean(WsdlSettings.CACHE_WSDLS, cacheDefinitions);
    }

    public boolean saveAs(String fileName) throws IOException {
        if (!this.isOpen() || this.isDisabled()) {
            return false;
        }
        String oldPath = this.path;
        this.path = fileName;
        boolean result = this.save();
        if (!result) {
            this.path = oldPath;
        } else {
            this.remote = false;
        }
        this.setProjectRoot(this.path);
        return result;
    }

    @Override
    public void release() {
        super.release();
        if (this.isOpen()) {
            this.endpointStrategy.release();
            for (WsdlTestSuite wsdlTestSuite : this.testSuites) {
                wsdlTestSuite.release();
            }
            for (WsdlMockService wsdlMockService : this.mockServices) {
                wsdlMockService.release();
            }
            for (AbstractInterface abstractInterface : this.interfaces) {
                abstractInterface.release();
            }
            if (this.wssContainer != null) {
                this.wssContainer.release();
                this.wssContainer = null;
            }
        }
        this.projectListeners.clear();
        this.environmentListeners.clear();
        if (this.afterLoadScriptEngine != null) {
            this.afterLoadScriptEngine.release();
        }
        if (this.beforeSaveScriptEngine != null) {
            this.beforeSaveScriptEngine.release();
        }
    }

    @Override
    public WsdlMockService addNewMockService(String name) {
        WsdlMockService mockService = new WsdlMockService(this, ((ProjectConfig)this.getConfig()).addNewMockService());
        mockService.setName(name);
        this.mockServices.add(mockService);
        this.fireMockServiceAdded(mockService);
        return mockService;
    }

    @Override
    public WsdlMockService getMockServiceAt(int index) {
        return this.mockServices.get(index);
    }

    @Override
    public WsdlMockService getMockServiceByName(String mockServiceName) {
        return (WsdlMockService)this.getWsdlModelItemByName(this.mockServices, mockServiceName);
    }

    @Override
    public int getMockServiceCount() {
        return this.mockServices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMockService(WsdlMockService mockService) {
        int ix = this.mockServices.indexOf(mockService);
        this.mockServices.remove(ix);
        try {
            this.fireMockServiceRemoved(mockService);
            Object var4_3 = null;
            mockService.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            mockService.release();
            ((ProjectConfig)this.getConfig()).removeMockService(ix);
            throw throwable;
        }
        ((ProjectConfig)this.getConfig()).removeMockService(ix);
    }

    @Override
    public List<TestSuite> getTestSuiteList() {
        return new ArrayList<TestSuite>(this.testSuites);
    }

    @Override
    public List<MockService> getMockServiceList() {
        return new ArrayList<MockService>(this.mockServices);
    }

    @Override
    public List<Interface> getInterfaceList() {
        return new ArrayList<Interface>(this.interfaces);
    }

    public Map<String, Interface> getInterfaces() {
        HashMap<String, Interface> result = new HashMap<String, Interface>();
        for (Interface interface_ : this.interfaces) {
            result.put(interface_.getName(), interface_);
        }
        return result;
    }

    public Map<String, TestSuite> getTestSuites() {
        HashMap<String, TestSuite> result = new HashMap<String, TestSuite>();
        for (TestSuite testSuite : this.testSuites) {
            result.put(testSuite.getName(), testSuite);
        }
        return result;
    }

    public Map<String, MockService> getMockServices() {
        HashMap<String, MockService> result = new HashMap<String, MockService>();
        for (MockService mockService : this.mockServices) {
            result.put(mockService.getName(), mockService);
        }
        return result;
    }

    public void reload() throws SoapUIException {
        this.reload(this.path);
    }

    public void reload(String path) throws SoapUIException {
        this.path = path;
        this.getWorkspace().reloadProject(this);
    }

    @Override
    public boolean hasNature(String natureId) {
        XmlBeansSettingsImpl projectSettings = this.getSettings();
        String projectNature = projectSettings.getString(ProjectSettings.PROJECT_NATURE, null);
        return natureId.equals(projectNature);
    }

    public AbstractInterface<?> importInterface(AbstractInterface<?> iface, boolean importEndpoints, boolean createCopy) {
        iface.beforeSave();
        InterfaceConfig ifaceConfig = (InterfaceConfig)iface.getConfig().copy();
        ifaceConfig = (InterfaceConfig)((ProjectConfig)this.getConfig()).addNewInterface().set((XmlObject)ifaceConfig);
        AbstractInterface<?> imported = InterfaceFactoryRegistry.build(this, ifaceConfig);
        this.interfaces.add(imported);
        if (iface.getProject() != this && importEndpoints) {
            this.endpointStrategy.importEndpoints(iface);
        }
        if (createCopy) {
            ModelSupport.unsetIds(imported);
        }
        imported.afterLoad();
        this.fireInterfaceAdded(imported);
        return imported;
    }

    public WsdlTestSuite importTestSuite(WsdlTestSuite testSuite, String name, int index, boolean createCopy, String description) {
        testSuite.beforeSave();
        TestSuiteConfig testSuiteConfig = index == -1 ? (TestSuiteConfig)((ProjectConfig)this.getConfig()).addNewTestSuite().set(((TestSuiteConfig)testSuite.getConfig()).copy()) : (TestSuiteConfig)((ProjectConfig)this.getConfig()).insertNewTestSuite(index).set(((TestSuiteConfig)testSuite.getConfig()).copy());
        testSuiteConfig.setName(name);
        if (createCopy) {
            for (TestCaseConfig testCaseConfig : testSuiteConfig.getTestCaseList()) {
                testCaseConfig.setSecurityTestArray(new SecurityTestConfig[0]);
            }
        }
        WsdlTestSuite oldTestSuite = testSuite;
        testSuite = this.buildTestSuite(testSuiteConfig);
        if (description != null) {
            testSuite.setDescription(description);
        }
        if (index == -1) {
            this.testSuites.add(testSuite);
        } else {
            this.testSuites.add(index, testSuite);
        }
        if (createCopy) {
            ModelSupport.unsetIds(testSuite);
        }
        testSuite.afterLoad();
        if (createCopy) {
            testSuite.afterCopy(oldTestSuite);
        }
        this.fireTestSuiteAdded(testSuite);
        this.resolveImportedTestSuite(testSuite);
        return testSuite;
    }

    public WsdlMockService importMockService(WsdlMockService mockService, String name, boolean createCopy, String description) {
        mockService.beforeSave();
        MockServiceConfig mockServiceConfig = (MockServiceConfig)((ProjectConfig)this.getConfig()).addNewMockService().set(((MockServiceConfig)mockService.getConfig()).copy());
        mockServiceConfig.setName(name);
        if (mockServiceConfig.isSetId() && createCopy) {
            mockServiceConfig.unsetId();
        }
        mockService = new WsdlMockService(this, mockServiceConfig);
        mockService.setDescription(description);
        this.mockServices.add(mockService);
        if (createCopy) {
            ModelSupport.unsetIds(mockService);
        }
        mockService.afterLoad();
        this.fireMockServiceAdded(mockService);
        return mockService;
    }

    @Override
    public EndpointStrategy getEndpointStrategy() {
        return this.endpointStrategy;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        ArrayList<ModelItem> list = new ArrayList<ModelItem>();
        list.addAll(this.getInterfaceList());
        list.addAll(this.getTestSuiteList());
        list.addAll(this.getMockServiceList());
        return list;
    }

    public void setAfterLoadScript(String script) {
        String oldScript = this.getAfterLoadScript();
        if (!((ProjectConfig)this.getConfig()).isSetAfterLoadScript()) {
            ((ProjectConfig)this.getConfig()).addNewAfterLoadScript();
        }
        ((ProjectConfig)this.getConfig()).getAfterLoadScript().setStringValue(script);
        if (this.afterLoadScriptEngine != null) {
            this.afterLoadScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(AFTER_LOAD_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getAfterLoadScript() {
        return ((ProjectConfig)this.getConfig()).isSetAfterLoadScript() ? ((ProjectConfig)this.getConfig()).getAfterLoadScript().getStringValue() : null;
    }

    public void setBeforeSaveScript(String script) {
        String oldScript = this.getBeforeSaveScript();
        if (!((ProjectConfig)this.getConfig()).isSetBeforeSaveScript()) {
            ((ProjectConfig)this.getConfig()).addNewBeforeSaveScript();
        }
        ((ProjectConfig)this.getConfig()).getBeforeSaveScript().setStringValue(script);
        if (this.beforeSaveScriptEngine != null) {
            this.beforeSaveScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(BEFORE_SAVE_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getBeforeSaveScript() {
        return ((ProjectConfig)this.getConfig()).isSetBeforeSaveScript() ? ((ProjectConfig)this.getConfig()).getBeforeSaveScript().getStringValue() : null;
    }

    public Object runAfterLoadScript() throws Exception {
        String script = this.getAfterLoadScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.afterLoadScriptEngine == null) {
            this.afterLoadScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.afterLoadScriptEngine.setScript(script);
        }
        this.afterLoadScriptEngine.setVariable("context", this.context);
        this.afterLoadScriptEngine.setVariable("project", this);
        this.afterLoadScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.afterLoadScriptEngine.run();
    }

    public Object runBeforeSaveScript() throws Exception {
        String script = this.getBeforeSaveScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.beforeSaveScriptEngine == null) {
            this.beforeSaveScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.beforeSaveScriptEngine.setScript(script);
        }
        this.beforeSaveScriptEngine.setVariable("context", this.context);
        this.beforeSaveScriptEngine.setVariable("project", this);
        this.beforeSaveScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.beforeSaveScriptEngine.run();
    }

    public PropertyExpansionContext getContext() {
        return this.context;
    }

    public DefaultWssContainer getWssContainer() {
        return this.wssContainer;
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.wssContainer.resolve(context);
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(Arrays.asList(this.wssContainer.getPropertyExpansions()));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    protected void addExternalDependencies(List<ExternalDependency> dependencies) {
        super.addExternalDependencies(dependencies);
        this.wssContainer.addExternalDependency(dependencies);
    }

    @Override
    public String getShadowPassword() {
        this.projectPassword = this.getSettings() == null ? this.projectPassword : this.getSettings().getString(ProjectSettings.SHADOW_PASSWORD, null);
        return this.projectPassword;
    }

    @Override
    public void setShadowPassword(String password) {
        String oldPassword = this.getSettings().getString(ProjectSettings.SHADOW_PASSWORD, null);
        this.getSettings().setString(ProjectSettings.SHADOW_PASSWORD, password);
        this.notifyPropertyChanged("projectPassword", oldPassword, password);
    }

    public String getHermesConfig() {
        this.hermesConfig = this.getSettings() == null ? this.hermesConfig : this.resolveHermesConfig();
        return this.hermesConfig;
    }

    private String resolveHermesConfig() {
        String hermesConfigProperty = this.getSettings().getString(ProjectSettings.HERMES_CONFIG, null);
        if (hermesConfigProperty != null && !hermesConfigProperty.equals("")) {
            return hermesConfigProperty;
        }
        if (System.getenv("HERMES_CONFIG") != null) {
            return System.getenv("HERMES_CONFIG");
        }
        return "${#System#user.home}\\.hermes";
    }

    public void setHermesConfig(String hermesConfigPath) {
        String oldHermesConfigPath = this.getSettings().getString(ProjectSettings.HERMES_CONFIG, null);
        this.getSettings().setString(ProjectSettings.HERMES_CONFIG, hermesConfigPath);
        this.notifyPropertyChanged("hermesConfig", oldHermesConfigPath, hermesConfigPath);
    }

    @Override
    public void inspect() {
        if (!this.isOpen()) {
            return;
        }
        byte[] data = this.projectDocument.getSoapuiProject().getEncryptedContent();
        if (data != null && data.length > 0) {
            try {
                this.reload();
            }
            catch (SoapUIException e) {
                e.printStackTrace();
            }
        }
    }

    public int getEncrypted() {
        return this.encrypted;
    }

    public int setEncrypted(int code) {
        this.encrypted = code;
        return this.encrypted;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("projectPassword".equals(evt.getPropertyName())) {
            if (this.encrypted == 0 & (evt.getOldValue() == null || ((String)evt.getOldValue()).length() == 0)) {
                this.encrypted = 1;
            }
            if (this.encrypted == 1 & (evt.getNewValue() == null || ((String)evt.getNewValue()).length() == 0)) {
                this.encrypted = 0;
            }
            if (SoapUI.getNavigator() != null) {
                SoapUI.getNavigator().repaint();
            }
        }
    }

    public SoapuiProjectDocumentConfig getProjectDocument() {
        return this.projectDocument;
    }

    public int getInterfaceCount(String type) {
        int result = 0;
        for (AbstractInterface<?> iface : this.interfaces) {
            if (!iface.getType().equals(type)) continue;
            ++result;
        }
        return result;
    }

    public List<AbstractInterface<?>> getInterfaces(String type) {
        ArrayList result = new ArrayList();
        for (AbstractInterface<?> iface : this.interfaces) {
            if (!iface.getType().equals(type)) continue;
            result.add(iface);
        }
        return result;
    }

    public void importTestSuite(File file) {
        if (!file.exists()) {
            UISupport.showErrorMessage("Error loading test case ");
            return;
        }
        TestSuiteDocumentConfig newTestSuiteConfig = null;
        try {
            newTestSuiteConfig = TestSuiteDocumentConfig.Factory.parse((File)file);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        if (newTestSuiteConfig == null) {
            UISupport.showErrorMessage("Not valid test case xml");
        } else {
            TestSuiteConfig config = (TestSuiteConfig)this.projectDocument.getSoapuiProject().addNewTestSuite().set((XmlObject)newTestSuiteConfig.getTestSuite());
            WsdlTestSuite testSuite = this.buildTestSuite(config);
            ModelSupport.unsetIds(testSuite);
            testSuite.afterLoad();
            for (int cnt2 = 0; cnt2 < config.getTestCaseList().size(); ++cnt2) {
                TestCaseConfig newTestCase = (TestCaseConfig)config.getTestCaseList().get(cnt2);
                TestCaseConfig importTestCaseConfig = (TestCaseConfig)newTestSuiteConfig.getTestSuite().getTestCaseList().get(cnt2);
                LinkedHashMap<String, String> oldNewIds = new LinkedHashMap<String, String>();
                for (int cnt = 0; cnt < importTestCaseConfig.getTestStepList().size(); ++cnt) {
                    oldNewIds.put(((TestStepConfig)importTestCaseConfig.getTestStepList().get(cnt)).getId(), ((TestStepConfig)newTestCase.getTestStepList().get(cnt)).getId());
                }
                for (SecurityTestConfig scan : newTestCase.getSecurityTestList()) {
                    for (TestStepSecurityTestConfig secStepConfig : scan.getTestStepSecurityTestList()) {
                        if (!oldNewIds.containsKey(secStepConfig.getTestStepId())) continue;
                        secStepConfig.setTestStepId((String)oldNewIds.get(secStepConfig.getTestStepId()));
                    }
                }
            }
            this.testSuites.add(testSuite);
            this.fireTestSuiteAdded(testSuite);
            this.resolveImportedTestSuite(testSuite);
        }
    }

    private void resolveImportedTestSuite(WsdlTestSuite testSuite) {
        ResolveDialog resolver = new ResolveDialog("Validate TestSuite", "Checks TestSuite for inconsistencies", null);
        resolver.setShowOkMessage(false);
        resolver.resolve(testSuite);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests) throws SoapUIException {
        return WsdlInterfaceFactory.importWsdl(this, url, createRequests);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests, WsdlLoader wsdlLoader) throws SoapUIException {
        return WsdlInterfaceFactory.importWsdl(this, url, createRequests, null, wsdlLoader);
    }

    public WsdlInterface[] importWsdl(String url, boolean createRequests, QName bindingName, WsdlLoader wsdlLoader) throws SoapUIException {
        return WsdlInterfaceFactory.importWsdl(this, url, createRequests, bindingName, wsdlLoader);
    }

    public void setDefaultScriptLanguage(String id) {
        ((ProjectConfig)this.getConfig()).setDefaultScriptLanguage(id);
    }

    public String getDefaultScriptLanguage() {
        if (((ProjectConfig)this.getConfig()).isSetDefaultScriptLanguage()) {
            return ((ProjectConfig)this.getConfig()).getDefaultScriptLanguage();
        }
        return "Groovy";
    }

    @Override
    public int getIndexOfTestSuite(TestSuite testSuite) {
        return this.testSuites.indexOf(testSuite);
    }

    public String getBeforeRunScript() {
        return ((ProjectConfig)this.getConfig()).isSetBeforeRunScript() ? ((ProjectConfig)this.getConfig()).getBeforeRunScript().getStringValue() : null;
    }

    public void setBeforeRunScript(String script) {
        String oldScript = this.getBeforeRunScript();
        if (!((ProjectConfig)this.getConfig()).isSetBeforeRunScript()) {
            ((ProjectConfig)this.getConfig()).addNewBeforeRunScript();
        }
        ((ProjectConfig)this.getConfig()).getBeforeRunScript().setStringValue(script);
        if (this.beforeRunScriptEngine != null) {
            this.beforeRunScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged("beforeRunScript", oldScript, script);
    }

    public Object runBeforeRunScript(ProjectRunContext context, ProjectRunner runner) throws Exception {
        String script = this.getBeforeRunScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.beforeRunScriptEngine == null) {
            this.beforeRunScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.beforeRunScriptEngine.setScript(script);
        }
        this.beforeRunScriptEngine.setVariable("runner", runner);
        this.beforeRunScriptEngine.setVariable("context", context);
        this.beforeRunScriptEngine.setVariable("project", this);
        this.beforeRunScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.beforeRunScriptEngine.run();
    }

    public String getAfterRunScript() {
        return ((ProjectConfig)this.getConfig()).isSetAfterRunScript() ? ((ProjectConfig)this.getConfig()).getAfterRunScript().getStringValue() : null;
    }

    public void setAfterRunScript(String script) {
        String oldScript = this.getAfterRunScript();
        if (!((ProjectConfig)this.getConfig()).isSetAfterRunScript()) {
            ((ProjectConfig)this.getConfig()).addNewAfterRunScript();
        }
        ((ProjectConfig)this.getConfig()).getAfterRunScript().setStringValue(script);
        if (this.afterRunScriptEngine != null) {
            this.afterRunScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged("afterRunScript", oldScript, script);
    }

    public Object runAfterRunScript(ProjectRunContext context, ProjectRunner runner) throws Exception {
        String script = this.getAfterRunScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.afterRunScriptEngine == null) {
            this.afterRunScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.afterRunScriptEngine.setScript(script);
        }
        this.afterRunScriptEngine.setVariable("runner", runner);
        this.afterRunScriptEngine.setVariable("context", context);
        this.afterRunScriptEngine.setVariable("project", this);
        this.afterRunScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.afterRunScriptEngine.run();
    }

    public void addProjectRunListener(ProjectRunListener projectRunListener) {
        this.runListeners.add(projectRunListener);
    }

    public void removeProjectRunListener(ProjectRunListener projectRunListener) {
        this.runListeners.remove(projectRunListener);
    }

    @Override
    public WsdlProjectRunner run(StringToObjectMap context, boolean async) {
        WsdlProjectRunner runner = new WsdlProjectRunner(this, context);
        runner.start(async);
        return runner;
    }

    public boolean isAbortOnError() {
        return ((ProjectConfig)this.getConfig()).getAbortOnError();
    }

    public void setAbortOnError(boolean arg0) {
        ((ProjectConfig)this.getConfig()).setAbortOnError(arg0);
    }

    public long getTimeout() {
        return ((ProjectConfig)this.getConfig()).getTimeout();
    }

    public void setTimeout(long timeout) {
        ((ProjectConfig)this.getConfig()).setTimeout(timeout);
    }

    public ProjectRunListener[] getProjectRunListeners() {
        return this.runListeners.toArray(new ProjectRunListener[this.runListeners.size()]);
    }

    public TestSuite.TestSuiteRunType getRunType() {
        TestSuiteRunTypesConfig.Enum runType = ((ProjectConfig)this.getConfig()).getRunType();
        if (TestSuiteRunTypesConfig.PARALLELL.equals(runType)) {
            return TestSuite.TestSuiteRunType.PARALLEL;
        }
        return TestSuite.TestSuiteRunType.SEQUENTIAL;
    }

    public void setRunType(TestSuite.TestSuiteRunType runType) {
        TestSuite.TestSuiteRunType oldRunType = this.getRunType();
        if (runType == TestSuite.TestSuiteRunType.PARALLEL && oldRunType != TestSuite.TestSuiteRunType.PARALLEL) {
            ((ProjectConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.PARALLELL);
            this.notifyPropertyChanged("runType", (Object)oldRunType, (Object)runType);
        } else if (runType == TestSuite.TestSuiteRunType.SEQUENTIAL && oldRunType != TestSuite.TestSuiteRunType.SEQUENTIAL) {
            ((ProjectConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.SEQUENTIAL);
            this.notifyPropertyChanged("runType", (Object)oldRunType, (Object)runType);
        }
    }

    public WsdlTestSuite moveTestSuite(int ix, int offset) {
        int c;
        WsdlTestSuite testSuite = this.testSuites.get(ix);
        if (offset == 0) {
            return testSuite;
        }
        this.testSuites.remove(ix);
        this.testSuites.add(ix + offset, testSuite);
        TestSuiteConfig[] configs = new TestSuiteConfig[this.testSuites.size()];
        for (c = 0; c < this.testSuites.size(); ++c) {
            if (offset > 0) {
                if (c < ix) {
                    configs[c] = (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c).copy();
                    continue;
                }
                if (c < ix + offset) {
                    configs[c] = (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c + 1).copy();
                    continue;
                }
                if (c == ix + offset) {
                    configs[c] = (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(ix).copy();
                    continue;
                }
                configs[c] = (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c).copy();
                continue;
            }
            configs[c] = c < ix + offset ? (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c).copy() : (c == ix + offset ? (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(ix).copy() : (c <= ix ? (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c - 1).copy() : (TestSuiteConfig)((ProjectConfig)this.getConfig()).getTestSuiteArray(c).copy()));
        }
        ((ProjectConfig)this.getConfig()).setTestSuiteArray(configs);
        for (c = 0; c < configs.length; ++c) {
            this.testSuites.get(c).resetConfigOnMove(((ProjectConfig)this.getConfig()).getTestSuiteArray(c));
        }
        this.fireTestSuiteMoved(testSuite, ix, offset);
        return testSuite;
    }

    public void importMockService(File file) {
        if (!file.exists()) {
            UISupport.showErrorMessage("Error loading test case ");
            return;
        }
        MockServiceDocumentConfig newMockServiceConfig = null;
        try {
            newMockServiceConfig = MockServiceDocumentConfig.Factory.parse((File)file);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        if (newMockServiceConfig == null) {
            UISupport.showErrorMessage("Not valid mock service xml");
        } else {
            MockServiceConfig config = (MockServiceConfig)this.projectDocument.getSoapuiProject().addNewMockService().set((XmlObject)newMockServiceConfig.getMockService());
            WsdlMockService mockService = new WsdlMockService(this, config);
            ModelSupport.unsetIds(mockService);
            mockService.afterLoad();
            this.mockServices.add(mockService);
            this.fireMockServiceAdded(mockService);
            this.resolveImportedMockService(mockService);
        }
    }

    private void resolveImportedMockService(WsdlMockService mockService) {
        ResolveDialog resolver = new ResolveDialog("Validate MockService", "Checks MockService for inconsistencies", null);
        resolver.setShowOkMessage(false);
        resolver.resolve(mockService);
    }

    private static Map<String, String> initCheckToScanMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("BoundaryCheck", "BoundaryScan");
        map.put("ParameterExposureCheck", "CrossSiteScriptingScan");
        map.put("FuzzingScan", "FuzzingScan");
        map.put("GroovySecurityCheck", "GroovySecurityScan");
        map.put("InvalidTypesSecurityCheck", "InvalidTypesSecurityScan");
        map.put("MalformedXmlSecurityCheck", "MalformedXmlSecurityScan");
        map.put("MaliciousAttachmentSecurityCheck", "MaliciousAttachmentSecurityScan");
        map.put("SQLInjectionCheck", "SQLInjectionScan");
        map.put("XmlBombSecurityCheck", "XmlBombSecurityScan");
        map.put("XPathInjectionSecurityCheck", "XPathInjectionSecurityScan");
        return map;
    }

    public void addEnvironmentListener(EnvironmentListener listener) {
        this.environmentListeners.add(listener);
    }

    public void removeEnvironmentListener(EnvironmentListener listener) {
        this.environmentListeners.remove(listener);
    }
}

