/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.types;

import com.eviware.soapui.impl.wadl.inference.ConflictHandler;
import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.impl.wadl.inference.schema.types.ComplexType;
import com.eviware.soapui.impl.wadl.inference.support.TypeInferrer;
import com.eviware.soapui.inferredSchema.SimpleTypeConfig;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;

public class SimpleType
implements Type {
    private XmlAnySimpleType simpleType;
    private Schema schema;
    private boolean completed = true;

    public SimpleType(Schema schema, XmlAnySimpleType simpleType, boolean completed) {
        this.schema = schema;
        this.simpleType = simpleType;
        this.completed = completed;
    }

    public SimpleType(SimpleTypeConfig xml, Schema schema) {
        this.schema = schema;
        this.completed = xml.getCompleted();
        this.simpleType = TypeInferrer.getType(xml.getTypeName());
    }

    public SimpleTypeConfig save() {
        SimpleTypeConfig xml = SimpleTypeConfig.Factory.newInstance();
        xml.setCompleted(this.completed);
        xml.setTypeName(this.simpleType.schemaType().getName().getLocalPart());
        return xml;
    }

    public Type validate(Context context) throws XmlException {
        XmlCursor cursor = context.getCursor();
        if (!cursor.isAttr() && (cursor.toFirstAttribute() || cursor.toFirstChild())) {
            return new ComplexType(this.schema, context.getName(), this.completed);
        }
        if (!context.getAttribute("nil").equals("true")) {
            String value = "";
            cursor.toFirstContentToken();
            if (!cursor.isEnd()) {
                value = cursor.getTextValue();
            }
            if (TypeInferrer.validateSimpleType(value, this.simpleType)) {
                return this;
            }
            XmlAnySimpleType newType = TypeInferrer.expandTypeForValue(value, this.simpleType);
            if (cursor.getName() == null) {
                cursor.toParent();
            }
            if (context.getHandler().callback(ConflictHandler.Event.MODIFICATION, ConflictHandler.Type.TYPE, cursor.getName(), context.getPath(), "Illegal content '" + value + "'")) {
                this.simpleType = newType;
            } else {
                throw new XmlException("Invalid value!");
            }
        }
        return this;
    }

    public String toString() {
        return "";
    }

    public String getName() {
        return this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema") + ":" + this.simpleType.schemaType().getName().getLocalPart();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

