/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.support.StringUtils;
import java.net.InetAddress;

public class HttpUtils {
    private static String pingErrorMessage;

    public static boolean isErrorStatus(int statusCode) {
        return statusCode >= 400;
    }

    public static String extractHttpHeaderParameter(String headerString, String parameterName) {
        int ix2;
        if (!StringUtils.hasContent(headerString) || !StringUtils.hasContent(parameterName)) {
            return null;
        }
        int ix = headerString.indexOf(parameterName + "=\"");
        if (ix > 0 && (ix2 = headerString.indexOf(34, ix + parameterName.length() + 2)) > ix) {
            return headerString.substring(ix + parameterName.length() + 2, ix2);
        }
        return null;
    }

    public static String ensureEndpointStartsWithProtocol(String endpoint) {
        if (StringUtils.isNullOrEmpty(endpoint)) {
            return endpoint;
        }
        String ep = endpoint.toLowerCase().trim();
        if (!(ep.startsWith("http://") || ep.startsWith("https://") || ep.startsWith("$"))) {
            return "http://" + endpoint;
        }
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ping(String host, int timeout) {
        boolean result = false;
        pingErrorMessage = "No Error";
        try {
            try {
                InetAddress address = InetAddress.getByName(host);
                result = address.isReachable(timeout);
            }
            catch (Exception e) {
                result = false;
                pingErrorMessage = e.getMessage();
                Object var5_6 = null;
                return result;
            }
            Object var5_5 = null;
            return result;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            return result;
        }
    }

    public static String getPingErrorMessage() {
        return pingErrorMessage;
    }
}

