/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support.handlers;

import com.eviware.soapui.impl.rest.support.MediaTypeHandler;
import com.eviware.soapui.impl.rest.support.handlers.JsonXmlSerializer;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.net.URL;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;

public class JsonMediaTypeHandler
implements MediaTypeHandler {
    public boolean canHandle(String contentType) {
        return JsonMediaTypeHandler.couldBeJsonContent(contentType);
    }

    public static boolean couldBeJsonContent(String contentType) {
        return contentType != null && (contentType.contains("javascript") || contentType.contains("json"));
    }

    public String createXmlRepresentation(HttpResponse response) {
        try {
            String content = response.getContentAsString().trim();
            if (!StringUtils.hasContent(content)) {
                return null;
            }
            content = content.replaceAll("\\\\u0000", "");
            JSON json = JSONSerializer.toJSON((Object)content);
            JsonXmlSerializer serializer = new JsonXmlSerializer();
            serializer.setTypeHintsEnabled(false);
            serializer.setRootName(HttpUtils.isErrorStatus(response.getStatusCode()) ? "Fault" : "Response");
            URL url = response.getURL();
            serializer.setNamespace("", url.getProtocol() + "://" + url.getHost() + url.getPath());
            content = serializer.write(json);
            content = XmlUtils.prettyPrintXml(content);
            return content;
        }
        catch (Throwable e) {
            if (!(e instanceof JSONException)) {
                e.printStackTrace();
            }
            return "<xml/>";
        }
    }
}

