/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.panels.request.views.content;

import com.eviware.soapui.impl.rest.RestRepresentation;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.panels.resource.InstanceRestParamsTable;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTable;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.http.HttpRequestContentView;
import com.eviware.soapui.impl.support.panels.AbstractHttpXmlRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.support.xsd.SampleXmlUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.types.TupleList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.apache.xmlbeans.SchemaType;

public class RestRequestContentView
extends HttpRequestContentView {
    private RestRequestInterface restRequest;
    private JButton recreateButton;
    private RestParamsTable paramsTable;

    public RestRequestContentView(AbstractHttpXmlRequestDesktopPanel.HttpRequestMessageEditor restRequestMessageEditor, RestRequestInterface restRequest) {
        super(restRequestMessageEditor, restRequest);
        this.restRequest = restRequest;
    }

    protected RestParamsTable buildParamsTable() {
        this.paramsTable = new InstanceRestParamsTable(this.restRequest.getParams()){

            protected void insertAdditionalButtons(JXToolBar toolbar) {
                toolbar.add(UISupport.createToolbarButton(new UpdateRestParamsAction()));
            }
        };
        return this.paramsTable;
    }

    public RestParamsTable getParamsTable() {
        return this.paramsTable;
    }

    protected Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        this.addMediaTypeCombo(toolbar);
        toolbar.addSeparator();
        this.recreateButton = UISupport.createActionButton(new CreateDefaultRepresentationAction(), true);
        this.recreateButton.setEnabled(this.canRecreate());
        toolbar.addFixed(this.recreateButton);
        toolbar.addSeparator();
        this.addPostQueryCheckBox(toolbar);
        toolbar.setMinimumSize(new Dimension(50, 20));
        return toolbar;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("mediaType") && this.recreateButton != null) {
            this.recreateButton.setEnabled(this.canRecreate());
        } else if (evt.getPropertyName().equals("restMethod")) {
            this.paramsTable.setParams(this.restRequest.getParams());
        }
        super.propertyChange(evt);
    }

    protected Object[] getRequestMediaTypes() {
        StringList result = new StringList(super.getRequestMediaTypes());
        for (RestRepresentation representation : this.restRequest.getRepresentations(RestRepresentation.Type.REQUEST, null)) {
            if (result.contains(representation.getMediaType())) continue;
            result.add(representation.getMediaType());
        }
        return result.toStringArray();
    }

    private boolean canRecreate() {
        for (RestRepresentation representation : this.restRequest.getRepresentations(RestRepresentation.Type.REQUEST, this.restRequest.getMediaType())) {
            if (representation.getSchemaType() == null) continue;
            return true;
        }
        return false;
    }

    private class CreateDefaultRepresentationAction
    extends AbstractAction {
        private CreateDefaultRepresentationAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/recreate_request.gif"));
            this.putValue("ShortDescription", "Recreates a default representation from the schema");
        }

        public void actionPerformed(ActionEvent e) {
            TupleList<RestRepresentation, SchemaType> list = new TupleList<RestRepresentation, SchemaType>(){

                @Override
                protected String toStringHandler(TupleList.Tuple tuple) {
                    return ((SchemaType)tuple.getValue2()).getDocumentElementName().toString();
                }
            };
            for (RestRepresentation representation : RestRequestContentView.this.restRequest.getRepresentations(RestRepresentation.Type.REQUEST, RestRequestContentView.this.restRequest.getMediaType())) {
                SchemaType schemaType = representation.getSchemaType();
                if (schemaType == null) continue;
                list.add(representation, schemaType);
            }
            if (list.isEmpty()) {
                UISupport.showErrorMessage("Missing recreatable representations for this method");
                return;
            }
            TupleList.Tuple result = (TupleList.Tuple)UISupport.prompt("Select element to create", "Create default content", list.toArray());
            if (result == null) {
                return;
            }
            RestRequestContentView.this.restRequest.setRequestContent(SampleXmlUtil.createSampleForType((SchemaType)result.getValue2()));
        }
    }

    private class UpdateRestParamsAction
    extends AbstractAction {
        private UpdateRestParamsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
            this.putValue("ShortDescription", "Updates this Requests params from a specified URL");
        }

        public void actionPerformed(ActionEvent e) {
            String str = UISupport.prompt("Enter new url below", "Extract Params", "");
            if (str == null) {
                return;
            }
            try {
                RestRequestContentView.this.restRequest.getParams().resetValues();
                RestUtils.extractParams(str, RestRequestContentView.this.restRequest.getParams(), false);
                RestRequestContentView.this.paramsTable.refresh();
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }
}

