/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RestResourceRepresentationConfig;
import com.eviware.soapui.config.RestResourceRepresentationTypeConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.panels.request.inspectors.schema.InferredSchemaManager;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.impl.wadl.WadlDefinitionContext;
import com.eviware.soapui.impl.wsdl.support.xsd.SampleXmlUtil;
import com.eviware.soapui.support.PropertyChangeNotifier;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestRepresentation
implements PropertyChangeNotifier,
PropertyChangeListener {
    private final RestMethod restMethod;
    private RestResourceRepresentationConfig config;
    private RestParamsPropertyHolder params;
    private PropertyChangeSupport propertyChangeSupport;
    private SchemaType schemaType;

    public RestRepresentation(RestMethod restMethod, RestResourceRepresentationConfig config) {
        this.restMethod = restMethod;
        this.config = config;
        if (config.getParams() == null) {
            config.addNewParams();
        }
        this.params = new XmlBeansRestParamsTestPropertyHolder(restMethod, config.getParams());
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        InferredSchemaManager.addPropertyChangeListener(this.restMethod.getResource().getService(), this);
    }

    public RestMethod getRestMethod() {
        return this.restMethod;
    }

    public RestResourceRepresentationConfig getConfig() {
        return this.config;
    }

    public RestParamsPropertyHolder getParams() {
        return this.params;
    }

    public void setConfig(RestResourceRepresentationConfig config) {
        this.config = config;
    }

    public String getId() {
        return this.config.getId();
    }

    public Type getType() {
        if (!this.config.isSetType()) {
            return null;
        }
        return Type.valueOf(this.config.getType().toString());
    }

    public String getMediaType() {
        return this.config.getMediaType();
    }

    public void setId(String arg0) {
        String old = this.getId();
        this.config.setId(arg0);
        this.propertyChangeSupport.firePropertyChange("id", old, arg0);
    }

    public void setType(Type type) {
        Type old = this.getType();
        this.config.setType(RestResourceRepresentationTypeConfig.Enum.forString((String)type.toString()));
        this.propertyChangeSupport.firePropertyChange("type", (Object)old, (Object)type);
    }

    public void setMediaType(String arg0) {
        String old = this.getMediaType();
        this.config.setMediaType(arg0);
        this.propertyChangeSupport.firePropertyChange("mediaType", old, arg0);
    }

    public void setElement(QName name) {
        QName old = this.getElement();
        this.config.setElement(name);
        this.schemaType = null;
        this.propertyChangeSupport.firePropertyChange("element", old, name);
    }

    public List<?> getStatus() {
        return this.config.getStatus() == null ? new ArrayList() : this.config.getStatus();
    }

    public void setStatus(List<?> arg0) {
        List<?> old = this.getStatus();
        this.config.setStatus(arg0);
        this.propertyChangeSupport.firePropertyChange("status", old, arg0);
    }

    public SchemaType getSchemaType() {
        if (this.schemaType == null) {
            try {
                WadlDefinitionContext context;
                if (this.getElement() != null && (context = this.getRestMethod().getResource().getService().getWadlContext()).hasSchemaTypes()) {
                    SchemaGlobalElement element;
                    this.schemaType = context.getSchemaTypeSystem().findDocumentType(this.getElement());
                    if (this.schemaType == null && (element = context.getSchemaTypeSystem().findElement(this.getElement())) != null) {
                        this.schemaType = element.getType();
                    }
                }
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        return this.schemaType;
    }

    public void release() {
        InferredSchemaManager.removePropertyChangeListener(this.getRestMethod().getResource().getService(), this);
    }

    public void setDescription(String description) {
        String old = this.getDescription();
        this.config.setDescription(description);
        this.propertyChangeSupport.firePropertyChange("description", old, description);
    }

    public String getDescription() {
        return this.config.getDescription();
    }

    public QName getElement() {
        return this.config.getElement();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String getDefaultContent() {
        if (this.getSchemaType() != null) {
            SampleXmlUtil generator = new SampleXmlUtil(false);
            generator.setIgnoreOptional(false);
            return generator.createSample(this.getSchemaType());
        }
        return "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.schemaType = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        REQUEST,
        RESPONSE,
        FAULT;

    }
}

