/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.ui.JDesktopPanelsList;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class SwitchDesktopPanelAction
extends AbstractAction {
    private JDialog dialog;
    private final JDesktopPanelsList desktopPanelsList;

    public SwitchDesktopPanelAction(JDesktopPanelsList desktopPanelsList) {
        super("Switch Window");
        this.desktopPanelsList = desktopPanelsList;
        this.putValue("ShortDescription", "Prompts to switch to an open editor window");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu W"));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.desktopPanelsList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.dialog = new JDialog(UISupport.getMainFrame(), "Switch Window", false);
            this.dialog.getContentPane().add((Component)UISupport.buildDescription(null, "Select the window to switch to below", null), "North");
            this.dialog.getContentPane().add((Component)this.desktopPanelsList, "Center");
            UISupport.initDialogActions(null, this.dialog);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowOpened(WindowEvent e) {
                    this.initOnOpen();
                }

                private void initOnOpen() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwitchDesktopPanelAction.this.desktopPanelsList.getDesktopPanelsList().requestFocus();
                            if (SwitchDesktopPanelAction.this.desktopPanelsList.getDesktopPanels().size() > 0) {
                                SwitchDesktopPanelAction.this.desktopPanelsList.getDesktopPanelsList().setSelectedIndex(0);
                            }
                        }
                    });
                }

                public void windowDeactivated(WindowEvent e) {
                    SwitchDesktopPanelAction.this.dialog.setVisible(false);
                }

                public void windowLostFocus(WindowEvent e) {
                    SwitchDesktopPanelAction.this.dialog.setVisible(false);
                }
            });
            this.dialog.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    SwitchDesktopPanelAction.this.dialog.setVisible(false);
                }
            });
            this.desktopPanelsList.getDesktopPanelsList().addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    DesktopPanel dp;
                    if (e.getKeyChar() == '\n' && (dp = (DesktopPanel)SwitchDesktopPanelAction.this.desktopPanelsList.getDesktopPanelsList().getSelectedValue()) != null) {
                        UISupport.showDesktopPanel(dp);
                        SwitchDesktopPanelAction.this.dialog.setVisible(false);
                    }
                }
            });
            this.desktopPanelsList.getDesktopPanelsList().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    DesktopPanel dp;
                    if (e.getClickCount() > 1 && (dp = (DesktopPanel)SwitchDesktopPanelAction.this.desktopPanelsList.getDesktopPanelsList().getSelectedValue()) != null) {
                        UISupport.showDesktopPanel(dp);
                        SwitchDesktopPanelAction.this.dialog.setVisible(false);
                    }
                }
            });
        }
        this.dialog.setSize(new Dimension(300, 120 + this.desktopPanelsList.getItemsCount() * 20));
        UISupport.showDialog(this.dialog);
    }
}

