/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.DefaultPropertyTableHolderModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.SecurityScanUtil;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SecurityScansPrefs
implements Prefs {
    public static final String GLOBAL_SENSITIVE_INFORMATION_TOKENS = "Global Sensitive Information Tokens";
    private SimpleForm securityScansForm;
    private final String title;

    public SecurityScansPrefs(String title) {
        this.title = title;
    }

    public SimpleForm getForm() {
        if (this.securityScansForm == null) {
            this.securityScansForm = new SimpleForm();
            PropertyHolderTable propertyHolderTable = new PropertyHolderTable(SecurityScanUtil.getGlobalSensitiveInformationExposureTokens()){

                protected JTable buildPropertiesTable() {
                    this.propertiesModel = new DefaultPropertyTableHolderModel(this.holder){

                        public String getColumnName(int columnIndex) {
                            switch (columnIndex) {
                                case 0: {
                                    return "Token";
                                }
                                case 1: {
                                    return "Description";
                                }
                            }
                            return null;
                        }
                    };
                    this.propertiesTable = new PropertyHolderTable.PropertiesHolderJTable(this);
                    this.propertiesTable.setSurrendersFocusOnKeystroke(true);
                    this.propertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
                    this.propertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        public void valueChanged(ListSelectionEvent e) {
                            int selectedRow = propertiesTable.getSelectedRow();
                            if (removePropertyAction != null) {
                                removePropertyAction.setEnabled(selectedRow != -1);
                            }
                            if (movePropertyUpAction != null) {
                                movePropertyUpAction.setEnabled(selectedRow > 0);
                            }
                            if (movePropertyDownAction != null) {
                                movePropertyDownAction.setEnabled(selectedRow >= 0 && selectedRow < propertiesTable.getRowCount() - 1);
                            }
                        }
                    });
                    this.propertiesTable.setDragEnabled(true);
                    this.propertiesTable.setTransferHandler(new TransferHandler("testProperty"));
                    if (this.getHolder().getModelItem() != null) {
                        DropTarget dropTarget = new DropTarget(this.propertiesTable, new PropertyHolderTable.PropertyHolderTablePropertyExpansionDropTarget(this));
                        dropTarget.setDefaultActions(3);
                    }
                    return this.propertiesTable;
                }
            };
            propertyHolderTable.setPreferredSize(new Dimension(200, 300));
            this.securityScansForm.append(new JLabel(this.title));
            this.securityScansForm.addSpace();
            this.securityScansForm.addComponent(propertyHolderTable);
        }
        return this.securityScansForm;
    }

    public void getFormValues(Settings settings) {
        SecurityScanUtil.saveGlobalSecuritySettings();
    }

    public String getTitle() {
        return GLOBAL_SENSITIVE_INFORMATION_TOKENS;
    }

    public StringToStringMap getValues(Settings settings) {
        return null;
    }

    public void setFormValues(Settings settings) {
    }

    public void storeValues(StringToStringMap values, Settings settings) {
    }
}

