/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import flex.messaging.FlexComponent;
import flex.messaging.config.ConfigMap;
import flex.messaging.util.WatchedObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RedeployManager
implements FlexComponent {
    private boolean enabled;
    private long watchInterval;
    private List watches;
    private List touches;
    private ScheduledExecutorService redeployService;
    private boolean started;

    public RedeployManager() {
        this(null);
    }

    public RedeployManager(ThreadFactory tf) {
        if (tf == null) {
            tf = new MonitorThreadFactory();
        }
        this.enabled = false;
        this.touches = new ArrayList();
        this.watchInterval = 20L;
        this.watches = new ArrayList();
        this.redeployService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)tf);
    }

    public void initialize(String id, ConfigMap properties) {
    }

    public void start() {
        if (!this.started && this.enabled) {
            this.redeployService.schedule((Runnable)new RedeployTask(), 20000L, TimeUnit.MILLISECONDS);
            this.started = true;
        }
    }

    public void stop() {
        if (this.started && this.enabled) {
            this.redeployService.shutdown();
            this.started = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isStarted() {
        return this.started;
    }

    public long getWatchInterval() {
        return this.watchInterval;
    }

    public void setWatchInterval(long watchInterval) {
        this.watchInterval = watchInterval;
    }

    public List getWatchFiles() {
        return this.watches;
    }

    public void addWatchFile(String watch) {
        this.watches.add(watch);
    }

    public void setWatchFiles(List watches) {
        this.watches = watches;
    }

    public List getTouchFiles() {
        return this.touches;
    }

    public void addTouchFile(String touch) {
        this.touches.add(touch);
    }

    public void setTouchFiles(List touches) {
        this.touches = touches;
    }

    public void forceRedeploy() {
        for (String filename : this.touches) {
            File file = new File(filename);
            if (!file.exists() || !file.isFile() && !file.isDirectory()) continue;
            file.setLastModified(System.currentTimeMillis());
        }
    }

    class RedeployTask
    implements Runnable {
        RedeployTask() {
        }

        public void run() {
            boolean redeploy = false;
            Iterator iter = RedeployManager.this.watches.iterator();
            while (iter.hasNext() && !redeploy) {
                WatchedObject watched = (WatchedObject)iter.next();
                if (watched.isUptodate()) continue;
                redeploy = true;
            }
            if (redeploy) {
                RedeployManager.this.forceRedeploy();
            } else {
                RedeployManager.this.redeployService.schedule((Runnable)new RedeployTask(), RedeployManager.this.watchInterval * 1000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    class MonitorThreadFactory
    implements ThreadFactory {
        MonitorThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("RedeployManager");
            return t;
        }
    }
}

