/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.adapters;

import flex.management.runtime.messaging.services.messaging.adapters.JMSAdapterControl;
import flex.messaging.Destination;
import flex.messaging.MessageClient;
import flex.messaging.MessageClientListener;
import flex.messaging.MessageDestination;
import flex.messaging.MessageException;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.services.MessageService;
import flex.messaging.services.messaging.adapters.AsyncMessageReceiver;
import flex.messaging.services.messaging.adapters.JMSConfigConstants;
import flex.messaging.services.messaging.adapters.JMSConsumer;
import flex.messaging.services.messaging.adapters.JMSExceptionEvent;
import flex.messaging.services.messaging.adapters.JMSExceptionListener;
import flex.messaging.services.messaging.adapters.JMSMessageEvent;
import flex.messaging.services.messaging.adapters.JMSMessageListener;
import flex.messaging.services.messaging.adapters.JMSProducer;
import flex.messaging.services.messaging.adapters.JMSQueueConsumer;
import flex.messaging.services.messaging.adapters.JMSQueueProducer;
import flex.messaging.services.messaging.adapters.JMSSettings;
import flex.messaging.services.messaging.adapters.JMSTopicConsumer;
import flex.messaging.services.messaging.adapters.JMSTopicProducer;
import flex.messaging.services.messaging.adapters.MessageReceiver;
import flex.messaging.services.messaging.adapters.MessagingAdapter;
import flex.messaging.services.messaging.adapters.SyncMessageReceiver;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.naming.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSAdapter
extends MessagingAdapter
implements JMSConfigConstants,
JMSExceptionListener,
JMSMessageListener,
MessageClientListener {
    public static final String LOG_CATEGORY = "Service.Message.JMS";
    private static final String DURABLE_SUBSCRIBER_NAME_PREFIX = "FlexClient_";
    private Map<JMSConsumer, String> consumerToClientId = new ConcurrentHashMap<JMSConsumer, String>();
    private Map<String, MessageClient> messageClients = new ConcurrentHashMap<String, MessageClient>();
    private LinkedList<JMSProducer> topicProducers = new LinkedList();
    private Map<String, JMSConsumer> topicConsumers = new ConcurrentHashMap<String, JMSConsumer>();
    private LinkedList<JMSProducer> queueProducers = new LinkedList();
    private Map<String, JMSConsumer> queueConsumers = new ConcurrentHashMap<String, JMSConsumer>();
    private JMSSettings settings = new JMSSettings();
    private JMSAdapterControl controller;

    public JMSAdapter() {
        this(false);
    }

    public JMSAdapter(boolean enableManagement) {
        super(enableManagement);
    }

    @Override
    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.jms(properties);
    }

    @Override
    protected void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        if (this.settings.getConnectionFactory() == null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10804);
            throw ce;
        }
        if (this.settings.getDestinationJNDIName() == null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10807);
            throw ce;
        }
        if (this.settings.getMessageType() == null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(10811, new Object[]{null});
            throw ce;
        }
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        MessageClient.addMessageClientCreatedListener(this);
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.stopConsumers(this.topicConsumers.values());
        this.stopConsumers(this.queueConsumers.values());
    }

    @Override
    public void setDestination(Destination destination) {
        MessageDestination dest = (MessageDestination)destination;
        super.setDestination(dest);
    }

    public JMSSettings getJMSSettings() {
        return this.settings;
    }

    public void setJMSSettings(JMSSettings jmsSettings) {
        this.settings = jmsSettings;
    }

    public int getQueueConsumerCount() {
        return this.queueConsumers.size();
    }

    public String[] getQueueConsumerIds() {
        Set<String> consumerIds = this.queueConsumers.keySet();
        if (consumerIds != null) {
            String[] ids = new String[consumerIds.size()];
            return consumerIds.toArray(ids);
        }
        return new String[0];
    }

    public int getTopicConsumerCount() {
        return this.topicConsumers.size();
    }

    public String[] getTopicConsumerIds() {
        Set<String> consumerIds = this.topicConsumers.keySet();
        if (consumerIds != null) {
            String[] ids = new String[consumerIds.size()];
            return consumerIds.toArray(ids);
        }
        return new String[0];
    }

    public int getTopicProducerCount() {
        return this.topicProducers.size();
    }

    public int getQueueProducerCount() {
        return this.queueProducers.size();
    }

    @Override
    public void exceptionThrown(JMSExceptionEvent evt) {
        JMSConsumer consumer = (JMSConsumer)evt.getSource();
        JMSException jmsEx = evt.getJMSException();
        MessageException messageEx = new MessageException();
        messageEx.setMessage(10820, new Object[]{consumer.getDestinationJndiName(), jmsEx.getMessage()});
        this.removeConsumer(consumer, true, true, messageEx.createErrorMessage());
    }

    @Override
    public boolean handlesSubscriptions() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Message message) {
        LinkedList<JMSProducer> linkedList;
        JMSProducer producer = null;
        Map msgProps = message.getHeaders();
        msgProps.put("timeToLive", new Long(message.getTimeToLive()));
        if (this.settings.getDestinationType().equals("topic")) {
            linkedList = this.topicProducers;
            synchronized (linkedList) {
                if (this.topicProducers.size() < this.settings.getMaxProducers()) {
                    producer = new JMSTopicProducer();
                    try {
                        producer.initialize(this.settings);
                        producer.start();
                    }
                    catch (Exception e) {
                        throw new MessageException(e);
                    }
                } else {
                    producer = this.topicProducers.removeFirst();
                }
                this.topicProducers.addLast(producer);
            }
        }
        if (this.settings.getDestinationType().equals("queue")) {
            linkedList = this.queueProducers;
            synchronized (linkedList) {
                if (this.queueProducers.size() < this.settings.getMaxProducers()) {
                    producer = new JMSQueueProducer();
                    try {
                        producer.initialize(this.settings);
                        producer.start();
                    }
                    catch (Exception e) {
                        throw new MessageException(e);
                    }
                } else {
                    producer = this.queueProducers.removeFirst();
                }
                this.queueProducers.addLast(producer);
            }
        }
        try {
            if (producer != null) {
                producer.sendMessage(message);
            }
        }
        catch (JMSException jmsEx) {
            if (this.settings.getDestinationType().equals("topic")) {
                LinkedList<JMSProducer> linkedList2 = this.topicProducers;
                synchronized (linkedList2) {
                    if (producer != null) {
                        producer.stop();
                        this.topicProducers.remove(producer);
                    }
                }
            }
            if (this.settings.getDestinationType().equals("queue")) {
                LinkedList<JMSProducer> linkedList3 = this.queueProducers;
                synchronized (linkedList3) {
                    if (producer != null) {
                        producer.stop();
                        this.queueProducers.remove(producer);
                    }
                }
            }
            throw new MessageException(jmsEx);
        }
        return null;
    }

    @Override
    public Object manage(CommandMessage commandMessage) {
        JMSConsumer consumer = null;
        String clientId = (String)commandMessage.getClientId();
        if (commandMessage.getOperation() == 0) {
            Object selectorExpression = commandMessage.getHeaders().get("DSSelector");
            if (this.settings.getDestinationType().equals("topic")) {
                MessageClient existingMessageClient = null;
                if (this.topicConsumers.containsKey(clientId)) {
                    this.removeConsumer(clientId, true, false, null);
                    existingMessageClient = this.messageClients.get(clientId);
                }
                consumer = new JMSTopicConsumer();
                consumer.initialize(this.settings);
                if (selectorExpression != null) {
                    consumer.setSelectorExpression((String)selectorExpression);
                }
                ((JMSTopicConsumer)consumer).setDurableSubscriptionName(this.buildSubscriptionName(clientId));
                consumer.setMessageReceiver(this.buildMessageReceiver(consumer));
                consumer.addJMSExceptionListener(this);
                consumer.addJMSMessageListener(this);
                this.topicConsumers.put(clientId, consumer);
                this.consumerToClientId.put(consumer, clientId);
                if (existingMessageClient != null) {
                    this.messageClientCreated(existingMessageClient);
                }
            } else if (this.settings.getDestinationType().equals("queue")) {
                MessageClient existingMessageClient = null;
                if (this.queueConsumers.containsKey(clientId)) {
                    this.removeConsumer(clientId, true, false, null);
                    existingMessageClient = this.messageClients.get(clientId);
                }
                consumer = new JMSQueueConsumer();
                consumer.initialize(this.settings);
                if (selectorExpression != null) {
                    consumer.setSelectorExpression((String)selectorExpression);
                }
                consumer.setMessageReceiver(this.buildMessageReceiver(consumer));
                consumer.addJMSExceptionListener(this);
                consumer.addJMSMessageListener(this);
                this.queueConsumers.put(clientId, consumer);
                this.consumerToClientId.put(consumer, clientId);
                if (existingMessageClient != null) {
                    this.messageClientCreated(existingMessageClient);
                }
            }
        } else if (commandMessage.getOperation() == 1) {
            boolean unsubscribe = true;
            boolean preserveDurable = false;
            if (commandMessage.getHeader("DSPreserveDurable") != null) {
                preserveDurable = (Boolean)commandMessage.getHeader("DSPreserveDurable");
            }
            if (commandMessage.getHeader("DSSubscriptionInvalidated") != null && ((Boolean)commandMessage.getHeader("DSSubscriptionInvalidated")).booleanValue() || preserveDurable) {
                unsubscribe = false;
            }
            this.removeConsumer(clientId, unsubscribe, false, null);
        }
        return null;
    }

    @Override
    public void messageClientCreated(MessageClient messageClient) {
        String clientId = (String)messageClient.getClientId();
        JMSConsumer consumer = null;
        if (this.topicConsumers.containsKey(clientId)) {
            consumer = this.topicConsumers.get(clientId);
        } else if (this.queueConsumers.containsKey(clientId)) {
            consumer = this.queueConsumers.get(clientId);
        }
        if (consumer != null) {
            this.messageClients.put(clientId, messageClient);
            try {
                consumer.start();
                messageClient.addMessageClientDestroyedListener(this);
            }
            catch (MessageException messageEx) {
                this.removeConsumer(consumer, true, true, messageEx.createErrorMessage());
            }
            catch (Exception ex) {
                this.removeConsumer(consumer, true, true, new MessageException(ex).createErrorMessage());
            }
        }
    }

    @Override
    public void messageClientDestroyed(MessageClient messageClient) {
        String clientId = (String)messageClient.getClientId();
        this.removeConsumer(clientId);
        this.messageClients.remove(clientId);
    }

    @Override
    public void messageReceived(JMSMessageEvent evt) {
        JMSConsumer consumer = (JMSConsumer)evt.getSource();
        javax.jms.Message jmsMessage = evt.getJMSMessage();
        AsyncMessage flexMessage = this.convertToFlexMessage(jmsMessage, consumer);
        if (flexMessage != null) {
            MessagePerformanceUtils.markServerPostAdapterExternalTime(flexMessage);
            ((MessageService)this.getDestination().getService()).serviceMessageFromAdapter(flexMessage, false);
        }
    }

    public void removeConsumer(String clientId) {
        MessageException messageEx = new MessageException();
        messageEx.setMessage(10821);
        this.removeConsumer(clientId, true, true, messageEx.createErrorMessage());
    }

    protected void removeConsumer(String clientId, boolean unsubscribe, boolean invalidate, ErrorMessage invalidateMessage) {
        JMSConsumer consumer = null;
        if (this.topicConsumers.containsKey(clientId)) {
            consumer = this.topicConsumers.get(clientId);
        } else if (this.queueConsumers.containsKey(clientId)) {
            consumer = this.queueConsumers.get(clientId);
        }
        this.removeConsumer(consumer, unsubscribe, invalidate, invalidateMessage);
    }

    protected void removeConsumer(JMSConsumer consumer, boolean unsubscribe, boolean invalidate, ErrorMessage invalidateMessage) {
        if (consumer == null) {
            return;
        }
        String clientId = this.consumerToClientId.get(consumer);
        if (clientId == null) {
            return;
        }
        if (Log.isInfo()) {
            String logMessage = "JMS consumer for JMS destination '" + consumer.getDestinationJndiName() + "' is being removed from the JMS adapter";
            if (invalidateMessage != null) {
                logMessage = logMessage + " due to the following error: " + invalidateMessage.faultString;
            }
            Log.getLogger((String)LOG_CATEGORY).info(logMessage);
        }
        consumer.removeJMSExceptionListener(this);
        consumer.removeJMSMessageListener(this);
        consumer.stop(unsubscribe);
        if (invalidate) {
            this.invalidateMessageClient(consumer, invalidateMessage);
        }
        if (consumer instanceof JMSTopicConsumer) {
            this.topicConsumers.remove(clientId);
        } else {
            this.queueConsumers.remove(clientId);
        }
        this.consumerToClientId.remove(consumer);
    }

    @Override
    protected void setupAdapterControl(Destination destination) {
        this.controller = new JMSAdapterControl(this, destination.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }

    private MessageReceiver buildMessageReceiver(JMSConsumer consumer) {
        JMSSettings.DeliverySettings deliverySettings = this.settings.getDeliverySettings();
        if (deliverySettings.getMode().equals("async")) {
            return new AsyncMessageReceiver(consumer);
        }
        SyncMessageReceiver syncMessageReceiver = new SyncMessageReceiver(consumer);
        syncMessageReceiver.setSyncReceiveIntervalMillis(deliverySettings.getSyncReceiveIntervalMillis());
        syncMessageReceiver.setSyncReceiveWaitMillis(deliverySettings.getSyncReceiveWaitMillis());
        return syncMessageReceiver;
    }

    private String buildSubscriptionName(Object clientId) {
        return DURABLE_SUBSCRIBER_NAME_PREFIX + clientId.toString();
    }

    private AsyncMessage convertToFlexMessage(javax.jms.Message jmsMessage, JMSConsumer consumer) {
        AsyncMessage flexMessage;
        block28: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            flexMessage = null;
                            flexMessage = new AsyncMessage();
                            String clientId = this.consumerToClientId.get(consumer);
                            if (clientId == null) {
                                if (Log.isWarn()) {
                                    Log.getLogger((String)LOG_CATEGORY).warn("JMSAdapter encountered a null clientId during JMS to Flex message conversion");
                                }
                                return null;
                            }
                            flexMessage.setClientId(clientId);
                            flexMessage.setDestination(this.getDestination().getId());
                            try {
                                flexMessage.setMessageId(jmsMessage.getJMSMessageID());
                            }
                            catch (JMSException jmsEx) {
                                if (!Log.isWarn()) break block24;
                                Log.getLogger((String)LOG_CATEGORY).warn("JMSAdapter encountered an error while retrieving JMS message id during JMS to Flex message conversion: " + jmsEx.getMessage());
                            }
                        }
                        try {
                            flexMessage.setTimestamp(jmsMessage.getJMSTimestamp());
                        }
                        catch (JMSException jmsEx) {
                            if (!Log.isWarn()) break block25;
                            Log.getLogger((String)LOG_CATEGORY).warn("JMSAdapter encountered an error while retrieving JMS timestamp during JMS to Flex message conversion: " + jmsEx.getMessage());
                        }
                    }
                    if (this.settings.isPreserveJMSHeaders()) {
                        try {
                            flexMessage.setHeader("JMSCorrelationID", jmsMessage.getJMSCorrelationID());
                            flexMessage.setHeader("JMSDeliveryMode", Integer.toString(jmsMessage.getJMSDeliveryMode()));
                            flexMessage.setHeader("JMSDestination", jmsMessage.getJMSDestination().toString());
                            flexMessage.setHeader("JMSExpiration", Long.toString(jmsMessage.getJMSExpiration()));
                            flexMessage.setHeader("JMSPriority", Integer.toString(jmsMessage.getJMSPriority()));
                            flexMessage.setHeader("JMSRedelivered", Boolean.toString(jmsMessage.getJMSRedelivered()));
                            flexMessage.setHeader("JMSReplyTo", jmsMessage.getJMSReplyTo());
                            flexMessage.setHeader("JMSType", jmsMessage.getJMSType());
                        }
                        catch (JMSException jmsEx) {
                            if (!Log.isWarn()) break block26;
                            Log.getLogger((String)LOG_CATEGORY).warn("JMSAdapter encountered an error while retrieving JMS headers during JMS to Flex conversion: " + jmsEx.getMessage());
                        }
                    }
                }
                MessagePerformanceInfo mpi = null;
                try {
                    Enumeration propEnum = jmsMessage.getPropertyNames();
                    while (propEnum.hasMoreElements()) {
                        String propName = (String)propEnum.nextElement();
                        try {
                            Object propValue = jmsMessage.getObjectProperty(propName);
                            if (propName.startsWith("DSMPII")) {
                                if (mpi == null) {
                                    mpi = new MessagePerformanceInfo();
                                }
                                propName = propName.substring("DSMPII".length());
                                try {
                                    Field field = mpi.getClass().getField(propName);
                                    field.set(mpi, propValue);
                                }
                                catch (Exception ignore) {}
                                continue;
                            }
                            flexMessage.setHeader(propName, propValue);
                        }
                        catch (JMSException jmsEx) {
                            if (!Log.isWarn()) continue;
                            Log.getLogger((String)LOG_CATEGORY).warn("JMSAdapter encountered an error while retrieving JMS properties during JMS to Flex conversion: " + jmsEx.getMessage());
                        }
                    }
                    if (mpi != null) {
                        flexMessage.setHeader("DSMPII", mpi);
                    }
                }
                catch (JMSException jmsEx) {
                    if (!Log.isWarn()) break block27;
                    Log.getLogger((String)LOG_CATEGORY).warn("JMSAdapter encountered an error while retrieving JMS properties during JMS to Flex conversion: " + jmsEx.getMessage());
                }
            }
            try {
                if (jmsMessage instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)jmsMessage;
                    flexMessage.setBody(textMessage.getText());
                } else if (jmsMessage instanceof ObjectMessage) {
                    ObjectMessage objMessage = (ObjectMessage)jmsMessage;
                    flexMessage.setBody(objMessage.getObject());
                }
            }
            catch (JMSException jmsEx) {
                if (!Log.isWarn()) break block28;
                Log.getLogger((String)LOG_CATEGORY).warn("JMSAdapter encountered an error while retrieving JMS message body during JMS to Flex conversion: " + jmsEx.getMessage());
            }
        }
        return flexMessage;
    }

    private void invalidateMessageClient(JMSConsumer consumer, Message message) {
        String clientId = this.consumerToClientId.get(consumer);
        if (clientId != null && this.messageClients.containsKey(clientId)) {
            MessageClient messageClient = this.messageClients.get(clientId);
            if (Log.isInfo()) {
                Log.getLogger((String)LOG_CATEGORY).info("The corresponding MessageClient for JMS consumer for JMS destination '" + consumer.getDestinationJndiName() + "' is being invalidated");
            }
            messageClient.invalidate(message);
        }
    }

    private void jms(ConfigMap properties) {
        ConfigMap jms = properties.getPropertyAsMap("jms", null);
        if (jms != null) {
            ConfigMap deliverySettings;
            String destType = jms.getPropertyAsString("destination-type", "topic");
            this.settings.setDestinationType(destType);
            String msgType = jms.getPropertyAsString("message-type", null);
            this.settings.setMessageType(msgType);
            String factory = jms.getPropertyAsString("connection-factory", null);
            this.settings.setConnectionFactory(factory);
            ConfigMap connectionCredentials = jms.getPropertyAsMap("connection-credentials", null);
            if (connectionCredentials != null) {
                String username = connectionCredentials.getPropertyAsString("username", null);
                this.settings.setConnectionUsername(username);
                String password = connectionCredentials.getPropertyAsString("password", null);
                this.settings.setConnectionPassword(password);
            }
            if ((deliverySettings = jms.getPropertyAsMap("delivery-settings", null)) != null) {
                JMSSettings.DeliverySettings ds = this.settings.getDeliverySettings();
                String mode = deliverySettings.getPropertyAsString("mode", "sync");
                ds.setMode(mode);
                long receiveIntervalMillis = deliverySettings.getPropertyAsLong("sync-receive-interval-millis", 100L);
                ds.setSyncReceiveIntervalMillis(receiveIntervalMillis);
                long receiveWaitMillis = deliverySettings.getPropertyAsLong("sync-receive-wait-millis", 0L);
                ds.setSyncReceiveWaitMillis(receiveWaitMillis);
            }
            String destJNDI = jms.getPropertyAsString("destination-jndi-name", null);
            this.settings.setDestinationJNDIName(destJNDI);
            String dest = jms.getPropertyAsString("destination-name", null);
            if (dest != null && Log.isWarn()) {
                Log.getLogger((String)LOG_CATEGORY).warn("The <destination-name> configuration option is deprecated and non-functional. Please remove this from your configuration file.");
            }
            boolean durable = this.getDestination() instanceof MessageDestination ? ((MessageDestination)this.getDestination()).getServerSettings().isDurable() : false;
            this.settings.setDurableConsumers(durable);
            String deliveryMode = jms.getPropertyAsString("delivery-mode", null);
            this.settings.setDeliveryMode(deliveryMode);
            boolean preserveJMSHeaders = jms.getPropertyAsBoolean("preserve-jms-headers", this.settings.isPreserveJMSHeaders());
            this.settings.setPreserveJMSHeaders(preserveJMSHeaders);
            String defPriority = jms.getPropertyAsString("message-priority", null);
            if (defPriority != null && !defPriority.equalsIgnoreCase("default-priority")) {
                int priority = jms.getPropertyAsInt("message-priority", this.settings.getMessagePriority());
                this.settings.setMessagePriority(priority);
            }
            String ackMode = jms.getPropertyAsString("acknowledge-mode", "auto_acknowledge");
            this.settings.setAcknowledgeMode(ackMode);
            boolean transMode = jms.getPropertyAsBoolean("transacted-sessions", false);
            if (transMode && Log.isWarn()) {
                Log.getLogger((String)LOG_CATEGORY).warn("The <transacted-sessions> configuration option is deprecated and non-functional. Please remove this from your configuration file.");
            }
            int maxProducers = jms.getPropertyAsInt("max-producers", 1);
            this.settings.setMaxProducers(maxProducers);
            ConfigMap env = jms.getPropertyAsMap("initial-context-environment", null);
            if (env != null) {
                List props = env.getPropertyAsList("property", null);
                if (props != null) {
                    Class<Context> contextClass = Context.class;
                    Hashtable<String, String> envProps = new Hashtable<String, String>();
                    for (Object prop : props) {
                        if (prop instanceof ConfigMap) {
                            ConfigMap pair = (ConfigMap)prop;
                            String name = pair.getProperty("name");
                            String value = pair.getProperty("value");
                            if (name == null || value == null) {
                                MessageException messageEx = new MessageException();
                                messageEx.setMessage(10800, new Object[]{this.getDestination().getId()});
                                throw messageEx;
                            }
                            if (name.startsWith("Context.")) {
                                String fieldName = name.substring(name.indexOf(".") + 1);
                                Field field = null;
                                try {
                                    field = contextClass.getDeclaredField(fieldName);
                                }
                                catch (NoSuchFieldException nsfe) {
                                    MessageException messageEx = new MessageException();
                                    messageEx.setMessage(10801, new Object[]{this.getDestination().getId(), fieldName});
                                    throw messageEx;
                                }
                                String fieldValue = null;
                                try {
                                    fieldValue = (String)field.get(null);
                                }
                                catch (IllegalAccessException iae) {
                                    MessageException messageEx = new MessageException();
                                    messageEx.setMessage(10802, new Object[]{this.getDestination().getId(), fieldName});
                                    throw messageEx;
                                }
                                envProps.put(fieldValue, value);
                                continue;
                            }
                            envProps.put(name, value);
                            continue;
                        }
                        MessageException messageEx = new MessageException();
                        messageEx.setMessage(10800, new Object[]{this.getDestination().getId()});
                        throw messageEx;
                    }
                    this.settings.setInitialContextEnvironment(envProps);
                } else {
                    MessageException messageEx = new MessageException();
                    messageEx.setMessage(10803, new Object[]{this.getDestination().getId()});
                    throw messageEx;
                }
            }
        }
    }

    private void stopConsumers(Collection<JMSConsumer> consumers) {
        for (JMSConsumer consumer : consumers) {
            MessageException me = new MessageException();
            me.setMessage(10822, new Object[]{consumer.getDestinationJndiName()});
            consumer.stop(true);
            this.invalidateMessageClient(consumer, me.createErrorMessage());
        }
    }
}

