/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.tools.ant.filters.StringInputStream;

public abstract class TextUtils {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Logger log = Logger.getLogger(TextUtils.class);

    public static String crumble(String in, int max) {
        if (in.length() < max) {
            return in;
        }
        return in.substring(0, max / 2) + " ... " + in.substring(in.length() - max / 2 + 1, in.length());
    }

    public static String printException(Throwable t) {
        StringWriter string = new StringWriter();
        t.printStackTrace(new PrintWriter(string));
        return string.toString();
    }

    public static String getAge(Date oldest) {
        if (oldest != null) {
            Date now = new Date();
            Date then = oldest;
            long diff = (now.getTime() - then.getTime()) / 1000L;
            int days = (int)diff / 86400;
            int hours = (int)(diff % 86400L) / 3600;
            int mins = (int)(diff % 360L) / 60;
            int secs = (int)(diff % 60L);
            StringBuffer rval = new StringBuffer();
            if (days > 0) {
                rval.append(days).append(" day").append(TextUtils.plural(days)).append(" ");
            }
            if (hours > 0) {
                rval.append(hours).append(" hour").append(TextUtils.plural(hours)).append(" ");
            }
            if (mins > 0) {
                rval.append(mins).append(" minute").append(TextUtils.plural(mins)).append(" ");
            }
            if (secs > 0) {
                rval.append(secs).append(" second").append(TextUtils.plural(secs)).append(" ");
            }
            return rval.toString();
        }
        return "empty";
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static String leftAlign(String text, int width) {
        return TextUtils.rightPad(text, width, ' ');
    }

    public static String leftPad(String text, int width, char padChar) {
        StringBuffer result = new StringBuffer(text);
        while (result.length() < width) {
            result.insert(0, padChar);
        }
        return result.toString();
    }

    public static String leftPadInt(int number, int width) {
        return TextUtils.leftPad(Integer.toString(number), width, '0');
    }

    public static String leftPadLong(long number, int width) {
        return TextUtils.leftPad(Long.toString(number), width, '0');
    }

    public static String plural(int n) {
        return n == 1 ? "" : "s";
    }

    public static InputStream replaceClasspathVariables(InputStream istream) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(istream));
        while ((line = in.readLine()) != null) {
            buffer.append(TextUtils.replaceClasspathVariables(line));
            buffer.append("\n");
        }
        return new StringInputStream(buffer.toString());
    }

    public static String replaceClasspathVariables(String string) throws IOException {
        while (string.contains("${")) {
            int endIndex;
            int startIndex = string.indexOf("${") + 2;
            String propertyName = string.substring(startIndex, endIndex = string.indexOf("}"));
            if (System.getProperty(propertyName) != null) {
                log.debug((Object)("replacing " + propertyName + " with " + System.getProperty(propertyName)));
                string = string.replace("${" + propertyName + "}", System.getProperty(propertyName));
                continue;
            }
            throw new IOException("Unknown variable " + propertyName);
        }
        return string;
    }

    public static String rightAlign(String text, int width) {
        return TextUtils.leftPad(text, width, ' ');
    }

    public static String rightPad(String text, int width, char padChar) {
        StringBuffer result = new StringBuffer(text);
        while (result.length() < width) {
            result.append(padChar);
        }
        return result.toString();
    }

    public static String rightPadInt(int number, int width) {
        return TextUtils.rightPad(Integer.toString(number), width, '0');
    }

    public static String rightPadLong(long number, int width) {
        return TextUtils.rightPad(Long.toString(number), width, '0');
    }

    public static String stringOf(char c, int width) {
        StringBuffer result = new StringBuffer();
        while (result.length() < width) {
            result.append(c);
        }
        return result.toString();
    }

    public static char toAsciiChar(byte b) {
        char c = (char)b;
        return Character.isISOControl(c) ? (char)'.' : (char)c;
    }

    public static String toAsciiString(byte[] b) {
        StringWriter buff = new StringWriter(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            buff.append(TextUtils.toAsciiChar(b[i]));
        }
        return buff.toString();
    }

    public static StringWriter toHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        StringWriter buff = new StringWriter(2);
        buff.append(hexDigits[d1]);
        buff.append(hexDigits[d2]);
        return buff;
    }

    public static String toHexString(byte[] b, boolean spacePad) {
        StringWriter buff = new StringWriter(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            buff.append(TextUtils.toHexString(b[i]).toString());
            if (!spacePad) continue;
            buff.append(' ');
        }
        return buff.toString();
    }
}

