/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.browser.model.tree.RepositoryTreeNode;
import hermes.swing.actions.ActionSupport;
import java.awt.event.ActionEvent;
import javax.jms.JMSException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class TruncateAction
extends ActionSupport {
    public TruncateAction() {
        this.putValue("Name", "Truncate");
        this.putValue("ShortDescription", "Truncate a queue, durable subscription or file.");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.queue.truncate"));
        this.setEnabled(false);
        if (!HermesBrowser.getBrowser().isRestricted()) {
            this.enableOnBrowserTreeSelection(new Class[]{DestinationConfigTreeNode.class, RepositoryTreeNode.class}, this, new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    if (TruncateAction.this.getBrowserTree().hasSelection() && TruncateAction.this.getBrowserTree().getLastSelectedPathComponent() instanceof DestinationConfigTreeNode) {
                        DestinationConfigTreeNode treeNode = (DestinationConfigTreeNode)TruncateAction.this.getBrowserTree().getSelectionPath().getLastPathComponent();
                        TruncateAction.this.setEnabled(treeNode.isQueue() || treeNode.getConfig().isDurable());
                    }
                }
            }, true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.getBrowserTree().getSelectionPath().getLastPathComponent() instanceof DestinationConfigTreeNode) {
            DestinationConfigTreeNode destinationNode = (DestinationConfigTreeNode)this.getBrowserTree().getSelectionPath().getLastPathComponent();
            if (destinationNode != null) {
                HermesTreeNode hermesNode = destinationNode.getHermesTreeNode();
                try {
                    HermesBrowser.getBrowser().getActionFactory().createTruncateAction(hermesNode.getHermes(), destinationNode.getConfig());
                }
                catch (JMSException ex) {
                    HermesBrowser.getBrowser().showErrorDialog("Cannot truncate: ", ex);
                }
            }
        } else if (HermesBrowser.getBrowser().getBrowserTree().getSelectionPath().getLastPathComponent() instanceof RepositoryTreeNode) {
            RepositoryTreeNode repositoryNode = (RepositoryTreeNode)this.getBrowserTree().getSelectionPath().getLastPathComponent();
            repositoryNode.getRepository().delete();
            Hermes.ui.getDefaultMessageSink().add("Repository " + repositoryNode.getRepository().getId() + " truncated");
        }
    }
}

