/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.config.DestinationConfig;
import hermes.swing.actions.ActionSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DurableUnsubscribeAction
extends ActionSupport {
    private static final Logger log = Logger.getLogger(DurableUnsubscribeAction.class);

    public DurableUnsubscribeAction() {
        this.putValue("Name", "Unsubscribe...");
        this.putValue("ShortDescription", "Unsubscribe any durable subscription on this topic");
        this.putValue("SmallIcon", IconCache.getIcon("hermes.unsubscribe"));
        this.setEnabled(false);
        this.getBrowserTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                if (event.getPath() != null && event.getPath().getLastPathComponent() instanceof DestinationConfigTreeNode) {
                    DestinationConfigTreeNode destinationNode = (DestinationConfigTreeNode)event.getPath().getLastPathComponent();
                    DurableUnsubscribeAction.this.setEnabled(destinationNode.getConfig().isDurable());
                } else {
                    DurableUnsubscribeAction.this.setEnabled(false);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        TreeNode node;
        TreePath curPath = HermesBrowser.getBrowser().getBrowserTree().getSelectionPath();
        if (curPath != null && (node = (TreeNode)curPath.getLastPathComponent()) instanceof DestinationConfigTreeNode) {
            try {
                DestinationConfigTreeNode tNode = (DestinationConfigTreeNode)node;
                final HermesTreeNode hNode = tNode.getHermesTreeNode();
                final DestinationConfig dConfig = tNode.getConfig();
                if (dConfig.isDurable()) {
                    if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Would you like to unsubscribe from durable subscription clientID=" + dConfig.getClientID() + " on " + tNode.getDestinationName(), "Please confirm", 0) == 0) {
                        Hermes.ui.getThreadPool().invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    hNode.getHermes().unsubscribe(dConfig.getClientID());
                                    Hermes.ui.getDefaultMessageSink().add("Unsubscribed");
                                }
                                catch (Throwable e) {
                                    HermesBrowser.getBrowser().showErrorDialog("Unable to unsubscribe", e);
                                }
                                finally {
                                    try {
                                        hNode.getHermes().close();
                                    }
                                    catch (Throwable t) {
                                        log.error((Object)t.getMessage(), t);
                                    }
                                }
                            }
                        });
                    } else {
                        Hermes.ui.getDefaultMessageSink().add("Unsubscribe cancelled.");
                    }
                } else {
                    HermesBrowser.getBrowser().showErrorDialog("Topic " + dConfig.getName() + " is not configured as durable.");
                }
            }
            catch (Throwable t) {
                HermesBrowser.getBrowser().showErrorDialog("Unable to unsubscribe", t);
            }
        }
    }
}

