/*
 * Decompiled with CFR 0.152.
 */
package hermes.swing.actions;

import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.dialog.MapPropertyDialog;
import hermes.browser.model.tree.MessageStoreURLTreeNode;
import hermes.config.JDBCStore;
import hermes.swing.actions.ActionSupport;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNewJDBCAction
extends ActionSupport {
    public CreateNewJDBCAction() {
        this.putValue("Name", "New JDBC...");
        this.putValue("ShortDescription", "Connect to new database containing message stores.");
        this.putValue("SmallIcon", IconCache.getIcon("jdbc.new"));
    }

    protected void doOnOK(Map<String, String> properties) {
        try {
            JDBCStore storeConfig = HermesBrowser.getConfigDAO().addJDBCStore(HermesBrowser.getBrowser().getConfig(), properties.get("alias"), properties.get("driver"), properties.get("url"));
            MessageStoreURLTreeNode node = new MessageStoreURLTreeNode(storeConfig);
            HermesBrowser.getBrowser().getBrowserTree().getBrowserModel().addMessageStoreURLTreeNode(node);
            HermesBrowser.getBrowser().saveConfig();
        }
        catch (Exception e) {
            HermesBrowser.getBrowser().showErrorDialog(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final HashMap<String, String> properties = new HashMap<String, String>();
        if (e.getSource() != null && e.getSource() instanceof JDBCStore) {
            JDBCStore config = (JDBCStore)e.getSource();
            properties.put("alias", config.getAlias());
            properties.put("url", config.getUrl());
            properties.put("driver", config.getDriver());
        } else {
            properties.put("alias", "myJDBC");
            properties.put("url", "jdbc:provider://<hostname>[<:port>]/<dbname>[?<param1>=<value1>]");
            properties.put("driver", "com.mydriver.MyDriver");
        }
        MapPropertyDialog dialog = new MapPropertyDialog((Frame)((Object)HermesBrowser.getBrowser()), "JDBC Properties", "\nYou need to provide an alias for this database and its URL and driver.\n", properties, true);
        dialog.addOKAction(new Runnable(){

            public void run() {
                CreateNewJDBCAction.this.doOnOK(properties);
            }
        });
        dialog.show();
    }
}

