/*
 * Decompiled with CFR 0.152.
 */
package hermes.renderers;

import hermes.browser.MessageRenderer;
import hermes.renderers.AbstractMessageRenderer;
import hermes.swing.MyTextArea;
import hermes.util.MessageUtils;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;

public class DefaultMessageRenderer
extends AbstractMessageRenderer {
    private static final Logger log = Logger.getLogger(DefaultMessageRenderer.class);
    private static final String BYTESISSTRING = "bytesIsString";
    private static final String BYTESISOBJECT = "bytesIsObject";
    private static final String BYTESISOBJECTSIZE = "bytesIsObjectBufferSize";
    private static final String TOSTRINGOBJECT = "toStringOnObjectMessage";
    private static final String MESSAGE_CACHE = "messageCache";
    private static final String BYTESISSTRING_INFO = "Treat a BytesMessage as a sequence of 8 bit characters and convert to a String";
    private static final String BYTESISOBJECT_INFO = "Treat a BytesMessage as a Serialized Java object";
    private static final String BYTESISOBJECTSIZE_INFO = "Buffer size to use as temporary storage (ignored with JMS 1.1 providers as size is available on the message)";
    private static final String TOSTRINGOBJECT_INFO = "Just call toString() on any Object in an ObjectMessage";
    private static final String MESSAGE_CACHE_INFO = "The number of panels to cache - can speed up the user interface when switching between messags";
    private LRUMap panelCache;

    protected JComponent handleTextMessage(final TextMessage textMessage) throws JMSException {
        String text = textMessage.getText();
        final JTextArea textPane = new JTextArea();
        textPane.setEditable(false);
        textPane.setFont(Font.decode("Monospaced-PLAIN-12"));
        textPane.setLineWrap(true);
        textPane.setWrapStyleWord(true);
        textPane.append(text);
        textPane.getDocument().addDocumentListener(new DocumentListener(){

            public void doChange() {
                try {
                    textMessage.setText(textPane.getText());
                }
                catch (JMSException e) {
                    JOptionPane.showMessageDialog(textPane, "Unable to update the TextMessage: " + e.getMessage(), "Error modifying message content", 0);
                    try {
                        textPane.setText(textMessage.getText());
                    }
                    catch (JMSException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    textPane.setEditable(false);
                    textPane.getDocument().removeDocumentListener(this);
                }
            }

            public void changedUpdate(DocumentEvent arg0) {
                this.doChange();
            }

            public void insertUpdate(DocumentEvent arg0) {
                this.doChange();
            }

            public void removeUpdate(DocumentEvent arg0) {
                this.doChange();
            }
        });
        textPane.setCaretPosition(0);
        return textPane;
    }

    protected JComponent handleObjectMessage(ObjectMessage objectMessage) throws JMSException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Serializable obj = objectMessage.getObject();
        if (obj instanceof JComponent) {
            return (JComponent)obj;
        }
        JTextArea textPane = new JTextArea();
        StringBuffer buffer = new StringBuffer();
        MyConfig currentConfig = (MyConfig)this.getConfig();
        if (currentConfig.isToStringOnObjectMessage()) {
            buffer.append(obj.toString());
        } else {
            buffer.append(obj.toString()).append("\n\nProperty list\n");
            for (Map.Entry entry : PropertyUtils.describe((Object)obj).entrySet()) {
                buffer.append(entry.getKey().toString()).append("=").append(entry.getValue()).append("\n");
            }
        }
        textPane.setEditable(false);
        textPane.setText(buffer.toString());
        return textPane;
    }

    protected JComponent handleMapMessage(MapMessage mapMessage) throws JMSException {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        Object key = null;
        Enumeration iter = mapMessage.getMapNames();
        while (iter.hasMoreElements()) {
            try {
                key = iter.nextElement();
                if (key instanceof String) {
                    rootNode.add(new DefaultMutableTreeNode(key.toString() + "=" + mapMessage.getObject((String)key)));
                    continue;
                }
                log.error((Object)("unsupported key " + key));
            }
            catch (Exception ex) {
                if (key != null) {
                    rootNode.add(new DefaultMutableTreeNode(key.toString() + "= <cannot access field: " + ex.getMessage() + ">"));
                    continue;
                }
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return new JTree(rootNode);
    }

    protected JComponent handleBytesMessage(BytesMessage bytesMessage) throws JMSException, IOException, ClassNotFoundException {
        MyTextArea textPane = new MyTextArea();
        MyConfig currentConfig = (MyConfig)this.getConfig();
        textPane.setEditable(false);
        bytesMessage.reset();
        if (currentConfig.isBytesIsObject()) {
            byte[] bytes = MessageUtils.asBytes(bytesMessage);
            ByteArrayInputStream bistream = new ByteArrayInputStream(bytes);
            ObjectInputStream oistream = new ObjectInputStream(bistream);
            Object o = oistream.readObject();
            textPane.setWrapStyleWord(true);
            textPane.setText(o.toString());
        } else if (currentConfig.isBytesIsString()) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(MessageUtils.asBytes(bytesMessage));
                textPane.setWrapStyleWord(true);
                textPane.setText(sb.toString());
                return textPane;
            }
            catch (JMSException e) {
                textPane.setText(e.getMessage());
            }
        } else {
            long size = MessageUtils.getBodyLength(bytesMessage);
            textPane.setText("byte[size=" + size + "]");
        }
        return textPane;
    }

    protected JComponent handleStreamMessage(StreamMessage streamMessage) throws JMSException {
        JTextArea textPane = new JTextArea();
        StringBuffer buffer = new StringBuffer();
        textPane.setEditable(false);
        streamMessage.reset();
        try {
            while (true) {
                buffer.append(streamMessage.readObject().toString()).append("\n");
            }
        }
        catch (MessageEOFException ex) {
            return textPane;
        }
    }

    public JComponent render(Message m) {
        try {
            if (this.getPanelMap().containsKey((Object)m)) {
                return (JComponent)this.getPanelMap().get((Object)m);
            }
            JComponent rval = null;
            if (m instanceof TextMessage) {
                rval = this.handleTextMessage((TextMessage)m);
            } else if (m instanceof ObjectMessage) {
                rval = this.handleObjectMessage((ObjectMessage)m);
            } else if (m instanceof MapMessage) {
                rval = this.handleMapMessage((MapMessage)m);
            } else if (m instanceof BytesMessage) {
                rval = this.handleBytesMessage((BytesMessage)m);
            } else if (m instanceof StreamMessage) {
                rval = this.handleStreamMessage((StreamMessage)m);
            } else {
                JTextArea textPane = new JTextArea();
                textPane.setEditable(false);
                textPane.setText("Message has no Payload");
                rval = textPane;
            }
            this.getPanelMap().put((Object)m, (Object)rval);
            return rval;
        }
        catch (Throwable ex) {
            JTextArea textPane = new JTextArea();
            textPane.setEditable(false);
            StringWriter string = new StringWriter();
            PrintWriter writer = new PrintWriter(string);
            ex.printStackTrace(writer);
            writer.flush();
            textPane.setText("Unable to display message:\n" + string.toString());
            log.error((Object)ex.getMessage(), ex);
            return textPane;
        }
    }

    public MessageRenderer.Config createConfig() {
        return new MyConfig();
    }

    public synchronized void setConfig(MessageRenderer.Config config) {
        MyConfig currentConfig = (MyConfig)config;
        this.panelCache = new LRUMap(currentConfig.getMessageCache());
        super.setConfig(config);
    }

    public synchronized LRUMap getPanelMap() {
        if (this.panelCache == null) {
            MyConfig currentConfig = (MyConfig)this.getConfig();
            this.panelCache = new LRUMap(currentConfig.getMessageCache());
        }
        return this.panelCache;
    }

    public boolean canRender(Message message) {
        return true;
    }

    public String getDisplayName() {
        return "Payload";
    }

    public class MyConfig
    extends AbstractMessageRenderer.BasicConfig {
        private String name;
        private boolean bytesIsObject = false;
        private int bytesIsObjectBufferSize = 65536;
        private boolean toStringOnObjectMessage = false;
        private int messageCache = 100;
        private boolean bytesIsString = false;

        public String toString() {
            return this.name + ".MyConfig: " + "bytesIsObject=" + this.bytesIsObject + ", bytesIsObjectBufferSize=" + this.bytesIsObjectBufferSize + ", toStringOnObjectMessage=" + this.toStringOnObjectMessage + ", messageCache=" + this.messageCache + ", bytesIsString=" + this.bytesIsString;
        }

        public int getMessageCache() {
            return this.messageCache;
        }

        public void setMessageCache(int messageCache) {
            this.messageCache = messageCache;
        }

        public boolean isBytesIsObject() {
            return this.bytesIsObject;
        }

        public void setBytesIsObject(boolean bytesIsObject) {
            this.bytesIsObject = bytesIsObject;
        }

        public int getBytesIsObjectBufferSize() {
            return this.bytesIsObjectBufferSize;
        }

        public void setBytesIsObjectBufferSize(int bytesIsObjectBufferSize) {
            this.bytesIsObjectBufferSize = bytesIsObjectBufferSize;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPropertyDescription(String propertyName) {
            if (propertyName.equals(DefaultMessageRenderer.BYTESISOBJECT)) {
                return DefaultMessageRenderer.BYTESISOBJECT_INFO;
            }
            if (propertyName.equals(DefaultMessageRenderer.BYTESISOBJECTSIZE)) {
                return DefaultMessageRenderer.BYTESISOBJECTSIZE_INFO;
            }
            if (propertyName.equals(DefaultMessageRenderer.TOSTRINGOBJECT)) {
                return DefaultMessageRenderer.TOSTRINGOBJECT_INFO;
            }
            if (propertyName.equals(DefaultMessageRenderer.MESSAGE_CACHE)) {
                return DefaultMessageRenderer.MESSAGE_CACHE_INFO;
            }
            if (propertyName.equals(DefaultMessageRenderer.BYTESISSTRING)) {
                return DefaultMessageRenderer.BYTESISSTRING_INFO;
            }
            return propertyName;
        }

        public boolean isToStringOnObjectMessage() {
            return this.toStringOnObjectMessage;
        }

        public void setToStringOnObjectMessage(boolean toStringOnObjectMessage) {
            this.toStringOnObjectMessage = toStringOnObjectMessage;
        }

        public boolean isBytesIsString() {
            return this.bytesIsString;
        }

        public void setBytesIsString(boolean bytesIsString) {
            this.bytesIsString = bytesIsString;
        }
    }
}

