/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.jms;

import hermes.Domain;
import hermes.impl.DestinationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import org.apache.log4j.Logger;

public class SimpleDestinationManager
implements DestinationManager {
    private static final Logger log = Logger.getLogger(SimpleDestinationManager.class);
    private WeakHashMap sessions = new WeakHashMap();

    protected Destination createDesintaion(Session session, String named, Domain domain) throws JMSException {
        Object rval = null;
        try {
            rval = domain == Domain.QUEUE ? session.createQueue(named) : (domain == Domain.TOPIC ? session.createTopic(named) : session.createQueue(named));
        }
        catch (NoSuchMethodError e) {
            log.debug((Object)"session seems to be pre JMS 1.1");
        }
        catch (AbstractMethodError e) {
            log.debug((Object)"session seems to be pre JMS 1.1");
        }
        if (rval == null) {
            if (domain == Domain.QUEUE) {
                rval = ((QueueSession)session).createQueue(named);
            } else if (domain == Domain.TOPIC) {
                rval = ((TopicSession)session).createTopic(named);
            } else {
                try {
                    rval = ((QueueSession)session).createQueue(named);
                }
                catch (ClassCastException e) {
                    rval = ((TopicSession)session).createTopic(named);
                }
            }
        }
        return rval;
    }

    public synchronized Destination getDestination(Session session, String named, Domain domain) throws JMSException {
        Cache cache = (Cache)this.sessions.get(session);
        Destination rval = null;
        Map cacheMap = null;
        if (cache == null) {
            cache = new Cache();
            this.sessions.put(session, cache);
        }
        if ((cacheMap = domain == Domain.QUEUE ? cache.queues : cache.topics).containsKey(named)) {
            rval = (Destination)cacheMap.get(named);
        } else {
            rval = this.createDesintaion(session, named, domain);
            cacheMap.put(named, rval);
        }
        return rval;
    }

    private static class Cache {
        Map topics = new HashMap();
        Map queues = new HashMap();

        private Cache() {
        }
    }
}

