/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Category;

public class HTMLBeanHelper {
    private static final Category cat = Category.getInstance(HTMLBeanHelper.class);

    public static String format(String text, Object bean) {
        Map properties;
        try {
            properties = BeanUtils.describe((Object)bean);
        }
        catch (Exception ex) {
            cat.error((Object)("getting properties:  " + ex.getMessage()), (Throwable)ex);
            return bean.getClass().getName() + ": cannot get properties: " + ex.getMessage();
        }
        return HTMLBeanHelper.format(text, properties);
    }

    public static String format(Map properties) {
        return HTMLBeanHelper.format(null, properties);
    }

    public static String format(String text, Map properties) {
        String rval = text;
        StringBuffer buffer = new StringBuffer();
        if (properties != null) {
            if (text == null) {
                buffer.append("<html>");
                Iterator iter = properties.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object val = properties.get(key);
                    if (key.equals("reference")) continue;
                    buffer.append(key).append("=").append(val);
                    if (!iter.hasNext()) continue;
                    buffer.append("<br>");
                }
                buffer.append("</html>");
            } else {
                for (String key : properties.keySet()) {
                    Object val = properties.get(key);
                    rval = rval.replaceAll("\\$" + key, val == null ? "null" : val.toString());
                }
                return rval;
            }
        }
        return buffer.toString();
    }
}

