/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Hermes;
import hermes.HermesException;
import hermes.HermesRepository;
import hermes.impl.DefaultXMLHelper;
import hermes.xml.MessageSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.log4j.Logger;

public class FileRepository
implements HermesRepository {
    private static final Logger log = Logger.getLogger(FileRepository.class);
    private static final String SEPARATOR = System.getProperty("file.separator");
    private File file;
    private MessageSet xmlMessages;
    private DefaultXMLHelper xmlSupport = new DefaultXMLHelper();

    public FileRepository(File file) throws IOException {
        this.file = file;
    }

    public String getToolTipText() {
        return this.file.getPath();
    }

    private void read() throws Exception {
        if (!this.file.exists()) {
            this.file.createNewFile();
        } else {
            try {
                this.xmlMessages = this.xmlSupport.readContent(new FileInputStream(this.file));
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.xmlMessages == null) {
            this.xmlMessages = new MessageSet();
        }
    }

    private void save() throws Exception {
        if (this.xmlMessages != null) {
            this.xmlSupport.saveContent(this.xmlMessages, new FileOutputStream(this.file));
        }
    }

    public String getId() {
        return this.file.getName();
    }

    public Collection getMessages(Hermes hermes) throws JMSException {
        if (hermes == null) {
            throw new HermesException("No Hermes available");
        }
        try {
            if (this.xmlMessages == null) {
                this.read();
            }
            return this.xmlSupport.fromMessageSet(hermes, this.xmlMessages);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException(e);
        }
    }

    public void addMessages(Hermes hermes, Collection messages) throws JMSException {
        if (hermes == null) {
            throw new HermesException("No Hermes available");
        }
        try {
            if (this.xmlMessages == null) {
                this.read();
            }
            MessageSet newMessages = this.xmlSupport.toMessageSet(messages);
            this.xmlMessages.getEntry().addAll(newMessages.getEntry());
            this.save();
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HermesException(e);
        }
    }

    public void addMessage(Hermes hermes, Message message) throws JMSException {
        ArrayList<Message> tmp = new ArrayList<Message>();
        tmp.add(message);
        this.addMessages(hermes, tmp);
    }

    public void delete() {
        if (this.file != null) {
            this.file.delete();
        }
        this.xmlMessages = null;
    }

    public int size() {
        if (this.xmlMessages == null) {
            return 0;
        }
        return this.xmlMessages.getEntry().size();
    }
}

