/*
 * Decompiled with CFR 0.152.
 */
package hermes.fix;

import com.jidesoft.grid.HierarchicalTableModel;
import hermes.fix.FIXMessage;
import hermes.fix.FIXMessageTableModel;
import hermes.fix.SessionKey;
import hermes.fix.SessionRole;
import hermes.swing.TimedSwingRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIXSessionTableModel
extends AbstractTableModel
implements HierarchicalTableModel {
    private static final Logger log = Logger.getLogger(FIXSessionTableModel.class);
    private final Vector<SessionKey> sessions = new Vector();
    private final Map<SessionKey, FIXMessageTableModel> tableModels = new HashMap<SessionKey, FIXMessageTableModel>();
    private final TimedSwingRunner swingRunner = new TimedSwingRunner(100L);

    public void close() {
        this.swingRunner.stop();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Initiator";
            }
            case 1: {
                return "Acceptor";
            }
            case 2: {
                return "Messages";
            }
        }
        return "???";
    }

    @Override
    public int getRowCount() {
        return this.sessions.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    public long addSession(SessionKey key) {
        this.sessions.add(key);
        this.fireTableRowsInserted(this.sessions.size() - 1, this.sessions.size());
        return this.sessions.size();
    }

    public SessionKey getSessionKey(int row) {
        return this.sessions.get(row);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.sessions.size()) {
            switch (columnIndex) {
                case 0: {
                    return this.sessions.get(rowIndex).getSenderCompID();
                }
                case 1: {
                    return this.sessions.get(rowIndex).getTargetCompID();
                }
                case 2: {
                    return this.sessions.get(rowIndex).getNumMessages();
                }
            }
        }
        return "???";
    }

    public synchronized void addMessages(Collection<FIXMessage> messages) {
        HashMap sessions = new HashMap();
        for (FIXMessage message : messages) {
            SessionKey key = new SessionKey(message.getString(49), message.getString(56));
            if (!sessions.containsKey(key)) {
                sessions.put(key, new ArrayList());
            }
            ((Collection)sessions.get(key)).add(message);
        }
        for (final SessionKey key : sessions.keySet()) {
            Collection sessionMessages = (Collection)sessions.get(key);
            if (this.tableModels.containsKey(key)) {
                this.tableModels.get(key).addMessages(sessionMessages);
                continue;
            }
            log.debug((Object)("creating new table for session " + key));
            key.setSessionRole(SessionRole.INITIATOR);
            final FIXMessageTableModel tableModel = new FIXMessageTableModel(key);
            SessionKey otherSide = new SessionKey(key.getTargetCompID(), key.getSenderCompID(), SessionRole.ACCEPTOR);
            this.tableModels.put(key, tableModel);
            this.tableModels.put(otherSide, tableModel);
            final long row = this.addSession(key);
            tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    Runnable r = new Runnable(){

                        public void run() {
                            if ((long)tableModel.getRowCount() != key.getNumMessages()) {
                                key.setNumMessages(tableModel.getRowCount());
                                FIXSessionTableModel.this.fireTableCellUpdated((int)row, 2);
                            }
                        }
                    };
                    FIXSessionTableModel.this.swingRunner.invokeLater(tableModel, r);
                }
            });
            tableModel.addMessages(sessionMessages);
        }
    }

    public synchronized Object getChildValueAt(int row) {
        if (row <= this.sessions.size()) {
            SessionKey key = this.sessions.get(row);
            log.debug((Object)("getChildValueAt(" + row + ") returns table for " + key));
            return this.tableModels.get(key);
        }
        return null;
    }

    public boolean hasChild(int row) {
        return true;
    }

    public boolean isExpandable(int row) {
        return true;
    }

    public boolean isHierarchical(int row) {
        return true;
    }
}

