/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.transferable;

import hermes.HermesRuntimeException;
import hermes.browser.components.BrowserTree;
import hermes.browser.transferable.HermesAdministeredObjectTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

public class BrowserTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(BrowserTreeTransferHandler.class);

    protected Transferable createTransferable(JComponent component) {
        if (component instanceof BrowserTree) {
            BrowserTree tree = (BrowserTree)component;
            return new HermesAdministeredObjectTransferable(tree.getSelectedAdministeredObjectNodes());
        }
        throw new HermesRuntimeException("cannot create transferable, JComponent " + component.getClass().getName() + " is not a BrowserTree");
    }

    public int getSourceActions(JComponent component) {
        BrowserTree tree;
        if (component instanceof BrowserTree && (tree = (BrowserTree)component).getSelectedAdministeredObjectNodes().size() > 0) {
            return 1;
        }
        return 0;
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (comp instanceof BrowserTree) {
            BrowserTree browserTree = (BrowserTree)comp;
            if (browserTree.getSelectionPath() != null) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean importData(JComponent comp, Transferable t) {
        if (comp instanceof BrowserTree) {
            BrowserTree browserTree = (BrowserTree)comp;
            return browserTree.doTransfer(t, 1);
        }
        return false;
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
    }
}

