/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Domain;
import hermes.Hermes;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.actions.BrowserAction;
import hermes.browser.tasks.TaskSupport;
import hermes.swing.SwingRunner;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

public class CopyOrMoveMessagesTask
extends TaskSupport {
    private static final Logger cat = Logger.getLogger(CopyOrMoveMessagesTask.class);
    private Collection messages;
    private Hermes hermes;
    private String destination;
    private boolean keepRunning = true;
    private int optionRval;
    private ProgressMonitor monitor;
    private int action;
    private Domain target;

    public CopyOrMoveMessagesTask(Hermes hermes, String destination, Domain target, Collection messages, int action) {
        super(action == 1 ? IconCache.getIcon("copy") : IconCache.getIcon("cut"));
        this.hermes = hermes;
        this.messages = messages;
        this.destination = destination;
        this.action = action;
        this.target = target;
    }

    public String getTitle() {
        if (this.action == 1) {
            return "Copy to " + this.destination;
        }
        return "Move to " + this.destination;
    }

    private Message createMessage(Destination to, Object o, Collection ids) throws JMSException {
        if (o instanceof Message) {
            Message oldMessage = (Message)o;
            Message newMessage = this.hermes.duplicate(to, oldMessage);
            ids.add(oldMessage.getJMSMessageID());
            return newMessage;
        }
        if (o instanceof byte[]) {
            BytesMessage newMessage = this.hermes.createBytesMessage();
            newMessage.writeBytes((byte[])o);
            return newMessage;
        }
        return this.hermes.createTextMessage(o.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        this.action = HermesBrowser.getBrowser().getBrowserTree().getLastDndAction();
        CopyOrMoveMessagesTask copyOrMoveMessagesTask = this;
        synchronized (copyOrMoveMessagesTask) {
            SwingRunner.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String copyOrMove;
                    String string = copyOrMove = CopyOrMoveMessagesTask.this.action == 1 ? "copy" : "move";
                    if (CopyOrMoveMessagesTask.this.messages.size() > 1) {
                        CopyOrMoveMessagesTask.this.optionRval = JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Do you wish to " + copyOrMove + " these " + CopyOrMoveMessagesTask.this.messages.size() + " messages to " + CopyOrMoveMessagesTask.this.destination + "?", "Confirm.", 0);
                    } else {
                        CopyOrMoveMessagesTask.this.optionRval = JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), "Do you wish to " + copyOrMove + " this message to " + CopyOrMoveMessagesTask.this.destination + "?", "Confirm.", 0);
                    }
                    CopyOrMoveMessagesTask copyOrMoveMessagesTask = CopyOrMoveMessagesTask.this;
                    synchronized (copyOrMoveMessagesTask) {
                        CopyOrMoveMessagesTask.this.notifyAll();
                    }
                }
            });
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (this.optionRval == 0) {
            StringBuffer finalStatus = new StringBuffer();
            ArrayList ids = new ArrayList();
            try {
                int startSize = this.messages.size();
                Destination to = this.hermes.getDestination(this.destination, this.target);
                SwingRunner.invokeAndWait(new Runnable(){

                    public void run() {
                        CopyOrMoveMessagesTask.this.monitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Copying " + CopyOrMoveMessagesTask.this.messages.size() + (CopyOrMoveMessagesTask.this.messages.size() == 1 ? " message" : " messages") + " to " + CopyOrMoveMessagesTask.this.destination, "Connecting...", 0, CopyOrMoveMessagesTask.this.messages.size());
                        CopyOrMoveMessagesTask.this.monitor.setMillisToDecideToPopup(100);
                        CopyOrMoveMessagesTask.this.monitor.setMillisToPopup(400);
                        CopyOrMoveMessagesTask.this.monitor.setProgress(1);
                    }
                });
                Iterator iter = this.messages.iterator();
                while (iter.hasNext() && !this.monitor.isCanceled()) {
                    Message newMessage = this.createMessage(to, iter.next(), ids);
                    this.hermes.send(to, newMessage);
                    iter.remove();
                    final int progress = startSize - this.messages.size();
                    SwingRunner.invokeLater(new Runnable(){

                        public void run() {
                            CopyOrMoveMessagesTask.this.monitor.setProgress(progress);
                            CopyOrMoveMessagesTask.this.monitor.setNote(new Long(CopyOrMoveMessagesTask.this.messages.size()) + " messages left to copy");
                        }
                    });
                }
                if (this.monitor.isCanceled()) {
                    this.hermes.rollback();
                    Toolkit.getDefaultToolkit().beep();
                    finalStatus.append("Copy to ").append(this.destination).append(" cancelled");
                } else {
                    this.hermes.commit();
                    if (this.action == 1) {
                        if (startSize == 1) {
                            finalStatus.append("Committed. Message copied to ").append(this.destination);
                        } else {
                            finalStatus.append("Committed. ").append(startSize).append(" messages copied to ").append(this.destination);
                        }
                    } else if (this.action == 2) {
                        BrowserAction activeAction = (BrowserAction)HermesBrowser.getBrowser().getDocumentPane().getActiveDocument();
                        HermesBrowser.getBrowser().getActionFactory().createTruncateAction(activeAction.getHermes(), activeAction.getConfig(), ids, false);
                    }
                }
                this.notifyStatus(finalStatus.toString());
            }
            catch (Exception ex) {
                cat.error((Object)ex.getMessage(), (Throwable)ex);
                this.notifyThrowable(ex);
                if (this.monitor != null) {
                    this.monitor.close();
                }
                try {
                    this.hermes.rollback();
                }
                catch (JMSException ex2) {
                    cat.error((Object)("Rollback after failed copy: " + ex2.getMessage()), (Throwable)ex2);
                }
            }
            finally {
                this.hermes.close();
            }
        }
    }
}

