/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.Hermes;
import hermes.MessageFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.IconCache;
import hermes.browser.tasks.TaskSupport;
import hermes.impl.DefaultXMLHelper;
import hermes.impl.XMLHelper;
import hermes.store.MessageStore;
import hermes.util.TextUtils;
import java.awt.Component;
import java.util.Collection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToMessageStoreTask
extends TaskSupport {
    private static final Logger log = Logger.getLogger(AddToMessageStoreTask.class);
    private static XMLHelper xmlHelper = new DefaultXMLHelper();
    private MessageStore store;
    private Collection<Message> messages;

    public AddToMessageStoreTask(MessageStore store, Collection<Message> messages) {
        super(IconCache.getIcon("hermes.record"));
        this.store = store;
        this.messages = messages;
    }

    public AddToMessageStoreTask(MessageFactory factory, MessageStore store, String messagesAsXML) throws JMSException {
        this(store, xmlHelper.fromXML(factory, messagesAsXML));
    }

    @Override
    public String getTitle() {
        return "Writing " + this.messages.size() + " message" + TextUtils.plural(this.messages.size()) + " to " + this.store.getId();
    }

    @Override
    public void invoke() {
        try {
            int numWritten = 0;
            ProgressMonitor monitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Writing " + this.messages.size() + (this.messages.size() == 1 ? " message" : " messages") + " to " + this.store.getId(), "Connecting...", 0, this.messages.size() + 1);
            monitor.setMillisToDecideToPopup(50);
            monitor.setMillisToPopup(50);
            for (Message message : this.messages) {
                this.store.store(message);
                monitor.setNote(++numWritten + " messages written.");
                monitor.setProgress(numWritten);
                if (!monitor.isCanceled() && this.isRunning()) continue;
                break;
            }
            if (monitor.isCanceled() || !this.isRunning()) {
                Hermes.ui.getDefaultMessageSink().add("Storing messages in " + this.store.getId() + " cancelled");
                this.store.rollback();
                monitor.close();
            } else {
                monitor.setNote("Checkpointing...");
                monitor.setProgress(++numWritten);
                log.debug((Object)"Checkpointing...");
                this.store.checkpoint();
                monitor.close();
                Hermes.ui.getDefaultMessageSink().add(this.messages.size() + " message" + TextUtils.plural(this.messages.size()) + " stored in " + this.store.getId());
            }
        }
        catch (Throwable e) {
            HermesBrowser.getBrowser().showErrorDialog(e);
        }
    }
}

