/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model.tree;

import hermes.Domain;
import hermes.browser.IconCache;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.config.DestinationConfig;
import java.util.Comparator;
import javax.swing.tree.TreeNode;

public class DestinationConfigTreeNode
extends AbstractTreeNode {
    private int depth = -1;
    private Domain domain;
    private HermesTreeNode hermesTreeNode;

    private static String getLabel(DestinationConfig config, boolean cascadeNamespace) {
        String name;
        String string = name = config.getShortName() == null || config.getShortName().equals("") ? config.getName() : config.getShortName();
        if (config.getShortName() == null && cascadeNamespace) {
            name = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : name.substring(name.lastIndexOf("/") + 1);
        }
        if (config.getDomain().intValue() == Domain.TOPIC.getId() && config.isDurable() && config.getClientID() != null) {
            name = name.concat(" name=").concat(config.getClientID());
        }
        if (config.getSelector() != null) {
            return name.concat(" (").concat(config.getSelector()).concat(" )");
        }
        return name;
    }

    public String getToolTipText() {
        return this.getDestinationName();
    }

    public DestinationConfigTreeNode(HermesTreeNode hermesTreeNode, DestinationConfig destinationConfig, boolean cascadeNamespace) {
        super(DestinationConfigTreeNode.getLabel(destinationConfig, cascadeNamespace), destinationConfig);
        this.domain = Domain.getDomain(destinationConfig.getDomain());
        this.hermesTreeNode = hermesTreeNode;
        if (destinationConfig.getName() == null) {
            throw new RuntimeException("name is null");
        }
        if (destinationConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
            this.setIcon(IconCache.getIcon("hermes/browser/icons/queue.gif"));
        } else if (destinationConfig.getDomain().intValue() == Domain.TOPIC.getId()) {
            if (destinationConfig.isDurable()) {
                this.setIcon(IconCache.getIcon("jms.durableTopic"));
            } else {
                this.setIcon(IconCache.getIcon("hermes/browser/icons/topic.gif"));
            }
        } else {
            this.setIcon(IconCache.getIcon("hermes/browser/icons/queueOrTopic.gif"));
        }
    }

    public HermesTreeNode getHermesTreeNode() {
        return this.hermesTreeNode;
    }

    public TreeNode getParent() {
        return super.getParent();
    }

    public String getSelector() {
        return this.getConfig().getSelector();
    }

    public Domain getDomain() {
        return this.domain;
    }

    public DestinationConfig getConfig() {
        return (DestinationConfig)this.getBean();
    }

    public String getDestinationName() {
        return this.getConfig().getName();
    }

    public boolean isQueue() {
        return this.getConfig().getDomain().intValue() == Domain.QUEUE.getId();
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public static class NodeComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            DestinationConfigTreeNode lval = (DestinationConfigTreeNode)arg0;
            DestinationConfigTreeNode rval = (DestinationConfigTreeNode)arg1;
            if (lval.getDomain() == rval.getDomain()) {
                return lval.getId().compareTo(rval.getId());
            }
            return -1;
        }
    }
}

