/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import com.jidesoft.grid.HierarchicalTableModel;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TreeLikeHierarchicalPanel;
import hermes.HermesRuntimeException;
import hermes.browser.components.FitScrollPane;
import hermes.browser.model.KeyValueMapTableModel;
import hermes.browser.model.MapTableModel;
import hermes.browser.model.OneRowMapTableModel;
import hermes.browser.model.WatchInfo;
import hermes.config.DestinationConfig;
import hermes.impl.DestinationConfigKeyWrapper;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class QueueWatchTableModel
extends DefaultTableModel
implements HierarchicalTableModel,
PropertyChangeListener,
HierarchicalTableComponentFactory {
    private static final Logger log = Logger.getLogger(QueueWatchTableModel.class);
    public static final int HERMES_POS = 0;
    public static final int DESTINATION_POS = 1;
    public static final int DURABLE_POS = 2;
    public static final int DEPTH_POS = 3;
    public static final int OLDEST_POS = 4;
    private Map<DestinationConfigKeyWrapper, WatchInfo> watchInfoByKey = new HashMap<DestinationConfigKeyWrapper, WatchInfo>();
    private Map childComponentByWatchInfo = new HashMap();

    public int getColumnCount() {
        return 5;
    }

    public WatchInfo getRowByKey(DestinationConfigKeyWrapper key) {
        if (this.watchInfoByKey.containsKey(key)) {
            return this.watchInfoByKey.get(key);
        }
        throw new HermesRuntimeException("cannot find WatchInfo key=" + key + " in set " + this.watchInfoByKey.keySet());
    }

    public void removeAll() {
        this.dataVector.clear();
        this.watchInfoByKey.clear();
        this.fireTableDataChanged();
    }

    public synchronized void addRow(WatchInfo info) {
        this.dataVector.add(info);
        this.watchInfoByKey.put(info.getKey(), info);
        this.fireTableRowsInserted(this.dataVector.size() - 1, this.dataVector.size());
        info.addPropertyChangeListener(this);
    }

    public void removeRow(WatchInfo info) {
        int index = this.dataVector.indexOf(info);
        if (index > 0) {
            this.dataVector.remove(info);
            this.fireTableRowsDeleted(index, index + 1);
        }
        this.watchInfoByKey.remove(info.getKey());
        this.childComponentByWatchInfo.remove(info);
        info.removePropertyChangeListener(this);
    }

    public void fireRowChanged(WatchInfo info) {
        int index = this.dataVector.indexOf(info);
        log.debug((Object)("row " + index + " changed"));
        this.fireTableRowsUpdated(index, index);
    }

    public WatchInfo getRow(int row) {
        if (row >= this.dataVector.size()) {
            return null;
        }
        return (WatchInfo)this.dataVector.elementAt(row);
    }

    public Iterator iterator() {
        return this.dataVector.iterator();
    }

    public Collection rows() {
        return this.dataVector;
    }

    public Collection getDestinationWatchConfigs() {
        ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
        for (WatchInfo info : this.dataVector) {
            rval.add(info.getConfig());
        }
        return rval;
    }

    public WatchInfo findWatchInfo(String hermesId, String destinationName) {
        for (WatchInfo info : this.dataVector) {
            if (!info.getHermesId().equals(hermesId) || !info.getConfig().getName().equals(destinationName)) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int y, int x) {
        QueueWatchTableModel queueWatchTableModel = this;
        synchronized (queueWatchTableModel) {
            WatchInfo info = (WatchInfo)this.dataVector.elementAt(y);
            switch (x) {
                case 0: {
                    return info.getHermesId();
                }
                case 1: {
                    return info.getConfig().getName();
                }
                case 2: {
                    return info.getConfig().isDurable() ? info.getConfig().getClientID() : "N/A";
                }
                case 3: {
                    return new Integer(info.getDepth());
                }
                case 4: {
                    if (info.getOldest() == 0L) {
                        return null;
                    }
                    return new Date(info.getOldest());
                }
            }
            return "Unknown";
        }
    }

    public boolean isCellEditable(int y, int arxg1) {
        return false;
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return Object.class;
    }

    private JTable createTable(WatchInfo info) {
        SortableTable table = new SortableTable(){

            public boolean isCellEditable(int arg0, int arg1) {
                return false;
            }
        };
        Map statistics = info.getStatistics();
        final MapTableModel model = statistics.size() > 10 ? new KeyValueMapTableModel(statistics) : new OneRowMapTableModel(statistics);
        info.addPropertyChangeListener("statistics", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Map) {
                    model.setMap((Map)evt.getNewValue());
                }
            }
        });
        table.setModel((TableModel)model);
        table.setSortable(true);
        return table;
    }

    public synchronized Object getChildValueAt(int y) {
        return this.getRow(y);
    }

    public Component createChildComponent(HierarchicalTable arg0, Object object, int row) {
        JComponent rval;
        WatchInfo info = (WatchInfo)object;
        if (!this.childComponentByWatchInfo.containsKey(info)) {
            rval = new TreeLikeHierarchicalPanel((Component)new FitScrollPane(this.createTable(info)));
            this.childComponentByWatchInfo.put(info, rval);
        } else {
            rval = (JComponent)this.childComponentByWatchInfo.get(info);
        }
        return rval;
    }

    public void destroyChildComponent(HierarchicalTable arg0, Component arg1, int arg2) {
    }

    public boolean hasChild(int y) {
        return true;
    }

    public boolean isExpandable(int row) {
        return this.isHierarchical(row);
    }

    public boolean isHierarchical(int y) {
        return true;
    }

    public boolean hasAlert() {
        for (Map.Entry<DestinationConfigKeyWrapper, WatchInfo> entry : this.watchInfoByKey.entrySet()) {
            WatchInfo info = entry.getValue();
            if (!info.isInAlert()) continue;
            return true;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        WatchInfo watchInfo = this.watchInfoByKey.get((DestinationConfigKeyWrapper)event.getSource());
        if (watchInfo != null) {
            if (!event.getPropertyName().equals("statistics")) {
                log.debug((Object)("property=" + event.getPropertyName() + " old=" + event.getOldValue() + " new=" + event.getNewValue()));
                this.fireRowChanged(watchInfo);
            }
        } else {
            log.error((Object)("propertyChange: cannot find WatchInfo key= " + event.getSource()));
        }
    }
}

