/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.model;

import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import com.jidesoft.grid.HierarchicalTableModel;
import com.jidesoft.grid.TreeLikeHierarchicalPanel;
import hermes.browser.components.ClasspathConfigTable;
import hermes.browser.components.FitScrollPane;
import hermes.browser.dialog.PreferencesDialog;
import hermes.browser.model.ClasspathConfigTableModel;
import hermes.config.ClasspathGroupConfig;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class ClasspathGroupTableModel
extends AbstractTableModel
implements HierarchicalTableModel,
HierarchicalTableComponentFactory {
    private List classpathGroups;
    private Map childrenByConfig = new HashMap();
    private Map childrenModelsByConfig = new HashMap();
    private PreferencesDialog dialog;

    public ClasspathGroupTableModel(PreferencesDialog dialog, List classpathGroups) {
        this.classpathGroups = classpathGroups;
        this.dialog = dialog;
    }

    public List getRows() {
        return this.classpathGroups;
    }

    public ClasspathGroupConfig getRow(int index) {
        return (ClasspathGroupConfig)this.classpathGroups.get(index);
    }

    public void setClasspathGroups(List classpathGroups) {
        this.classpathGroups = classpathGroups;
        this.fireTableDataChanged();
    }

    public boolean isExpandable(int row) {
        return this.isHierarchical(row);
    }

    public void removeRow(int row) {
        this.classpathGroups.remove(row);
        this.fireTableDataChanged();
    }

    public void addRow(ClasspathGroupConfig config) {
        this.classpathGroups.add(config);
        this.fireTableRowsInserted(this.classpathGroups.size() - 1, this.classpathGroups.size());
    }

    public boolean hasChild(int row) {
        return this.classpathGroups != null && this.classpathGroups.size() > 0 && row < this.classpathGroups.size();
    }

    public boolean isHierarchical(int row) {
        return this.classpathGroups != null && this.classpathGroups.size() > 0 && row < this.classpathGroups.size();
    }

    public Object getChildValueAt(int columnIndex) {
        ClasspathGroupConfig row = (ClasspathGroupConfig)this.classpathGroups.get(columnIndex);
        return row;
    }

    public ClasspathConfigTableModel getChildModel(ClasspathGroupConfig row) {
        ClasspathConfigTableModel rval = this.childrenModelsByConfig.containsKey(row) ? (ClasspathConfigTableModel)this.childrenModelsByConfig.get(row) : new ClasspathConfigTableModel(row.getLibrary());
        return rval;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        if (this.classpathGroups == null) {
            return 0;
        }
        return this.classpathGroups.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.classpathGroups == null || rowIndex >= this.classpathGroups.size()) {
            return null;
        }
        ClasspathGroupConfig row = (ClasspathGroupConfig)this.classpathGroups.get(rowIndex);
        return row.getId();
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public String getColumnName(int column) {
        return "Classpath Groups";
    }

    public Component createChildComponent(HierarchicalTable arg0, Object object, int row) {
        ClasspathGroupConfig groupConfig = (ClasspathGroupConfig)object;
        ClasspathConfigTableModel model = this.getChildModel(groupConfig);
        ClasspathConfigTable table = new ClasspathConfigTable(this, this.classpathGroups, this.dialog, model);
        FitScrollPane fitPane = new FitScrollPane((Component)((Object)table));
        TreeLikeHierarchicalPanel hPanel = new TreeLikeHierarchicalPanel((Component)fitPane);
        fitPane.addMouseListener(table.getMouseAdapter());
        hPanel.addMouseListener((MouseListener)table.getMouseAdapter());
        return hPanel;
    }

    public void destroyChildComponent(HierarchicalTable arg0, Component arg1, int arg2) {
    }
}

