/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.components;

import com.jidesoft.swing.JideSwingUtilities;
import com.xduke.xswing.DataTipManager;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesException;
import hermes.HermesRuntimeException;
import hermes.JNDIContextFactory;
import hermes.browser.HermesBrowser;
import hermes.browser.components.BrowserTreeCellRenderer;
import hermes.browser.components.PopupMenuFactory;
import hermes.browser.dialog.BindToolDialog;
import hermes.browser.model.BrowserTreeModel;
import hermes.browser.model.tree.AbstractTreeNode;
import hermes.browser.model.tree.DestinationConfigTreeNode;
import hermes.browser.model.tree.HermesTreeNode;
import hermes.browser.model.tree.MessageStoreDestinationTreeNode;
import hermes.browser.model.tree.MessageStoreTreeNode;
import hermes.browser.model.tree.MessageStoreURLTreeNode;
import hermes.browser.model.tree.NamingConfigTreeNode;
import hermes.browser.model.tree.RepositoryTreeNode;
import hermes.browser.tasks.AddToMessageStoreTask;
import hermes.browser.transferable.BrowserTreeTransferHandler;
import hermes.browser.transferable.HermesAdministeredObjectTransferable;
import hermes.browser.transferable.HermesConfigGroup;
import hermes.browser.transferable.JMSAdministeredObjectTransferable;
import hermes.browser.transferable.JMSMessagesTransferable;
import hermes.browser.transferable.MessageGroup;
import hermes.browser.transferable.MessagesTransferable;
import hermes.config.DestinationConfig;
import hermes.config.FactoryConfig;
import hermes.impl.HTMLBeanHelper;
import hermes.store.MessageStore;
import hermes.swing.actions.ActionRegistry;
import hermes.swing.actions.BrowseDestinationOrContextAction;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserTree
extends JTree
implements TreeSelectionListener,
DropTargetListener {
    private static final Logger log = Logger.getLogger(BrowserTree.class);
    private List<JMenuItem> menuItems = new ArrayList<JMenuItem>();
    private BrowserTreeModel model = new BrowserTreeModel();
    private DataFlavor[] myFlavours;
    private JPopupMenu popupMenu;
    private HermesTreeNode lastSelectedHermesTreeNode;
    private int lastDndAction;

    public BrowserTree() throws HermesException {
        this.setModel(this.model);
        this.setTransferHandler(new BrowserTreeTransferHandler());
        this.setDragEnabled(true);
    }

    public int getLastDndAction() {
        return this.lastDndAction;
    }

    public void setLastDnDAction(int lastDndAction) {
        this.lastDndAction = lastDndAction;
    }

    public BrowserTreeModel getBrowserModel() {
        return (BrowserTreeModel)this.getModel();
    }

    public Collection<MessageStore> getMessageStores() {
        return this.model.getMessageStores();
    }

    public void remove(MessageStoreURLTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        node.close();
        parent.remove(node);
        this.getBrowserModel().nodeStructureChanged(parent);
    }

    public void remove(MessageStoreTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        node.close();
        parent.remove(node);
        this.getBrowserModel().nodeStructureChanged(parent);
    }

    public boolean hasSelection() {
        return this.getSelectionPath() != null && this.getSelectionPath().getLastPathComponent() != null;
    }

    @Override
    public Object getLastSelectedPathComponent() {
        return this.getSelectionPath().getLastPathComponent();
    }

    public DestinationConfigTreeNode getFirstSelectedDestinationNode() {
        List<DestinationConfigTreeNode> nodes = this.getSelectedDestinationNodes();
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }

    public List<DestinationConfigTreeNode> getSelectedDestinationNodes() {
        TreePath[] paths = this.getSelectionPaths();
        ArrayList<DestinationConfigTreeNode> rval = new ArrayList<DestinationConfigTreeNode>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof DestinationConfigTreeNode)) continue;
                rval.add((DestinationConfigTreeNode)paths[i].getLastPathComponent());
            }
        }
        return rval;
    }

    public Destination getSelectedMessageStoreDestination() {
        if (this.getSelectionPath() != null && this.getSelectionPath().getLastPathComponent() instanceof MessageStoreDestinationTreeNode) {
            return ((MessageStoreDestinationTreeNode)this.getSelectionPath().getLastPathComponent()).getDestination();
        }
        return null;
    }

    public MessageStore getSelectedMessageStore() {
        if (this.getSelectionPath() != null) {
            if (this.getSelectionPath().getLastPathComponent() instanceof MessageStoreTreeNode) {
                return ((MessageStoreTreeNode)this.getSelectionPath().getLastPathComponent()).getMessageStore();
            }
            if (this.getSelectionPath().getLastPathComponent() instanceof MessageStoreDestinationTreeNode) {
                MessageStoreDestinationTreeNode dNode = (MessageStoreDestinationTreeNode)this.getSelectionPath().getLastPathComponent();
                return ((MessageStoreTreeNode)dNode.getParent()).getMessageStore();
            }
        }
        return null;
    }

    public HermesTreeNode getLastSelectedHermesTreeNode() {
        if (this.lastSelectedHermesTreeNode == null) {
            return this.model.getFirstHermesTreeNode();
        }
        return this.lastSelectedHermesTreeNode;
    }

    public HermesTreeNode getSelectedHermesNode() {
        if (this.getSelectionPath() != null) {
            if (this.getSelectionPath().getLastPathComponent() instanceof HermesTreeNode) {
                return (HermesTreeNode)this.getSelectionPath().getLastPathComponent();
            }
            if (this.getSelectionPath().getLastPathComponent() instanceof DestinationConfigTreeNode) {
                DestinationConfigTreeNode destinationNode = (DestinationConfigTreeNode)this.getSelectionPath().getLastPathComponent();
                return destinationNode.getHermesTreeNode();
            }
        }
        return null;
    }

    private boolean doJavaFileTransfer(List files) {
        List<DestinationConfigTreeNode> nodes = this.getSelectedDestinationNodes();
        if (nodes.size() > 0) {
            StringBuffer question = new StringBuffer();
            DestinationConfigTreeNode node = nodes.get(0);
            question.append("Are you sure you want to upload ");
            if (files.size() == 1) {
                question.append(" this file to " + node.getDestinationName());
            } else {
                question.append(" these " + files.size() + " files to " + node.getDestinationName());
            }
            question.append(" ?");
            if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), question.toString(), "Please confirm.", 0) == 0) {
                HermesBrowser.getBrowser().getActionFactory().createSimpleSendMessageAction(this.getSelectedHermesNode().getHermes(), node.getDestinationName(), node.getDomain(), files, 2, false);
            } else {
                Hermes.ui.getDefaultMessageSink().add("File upload cancelled.");
            }
        }
        return false;
    }

    private boolean doTextMessageTransfer(Collection messages) {
        List<DestinationConfigTreeNode> nodes = this.getSelectedDestinationNodes();
        this.lastDndAction = 1;
        if (nodes.size() > 0 && messages.size() > 0) {
            DestinationConfigTreeNode destinationNode = nodes.get(0);
            HermesTreeNode hermesNode = this.getSelectedHermesNode();
            if (hermesNode != null && destinationNode != null) {
                HermesBrowser.getBrowser().getActionFactory().createMessageCopyAction(hermesNode.getHermes(), destinationNode.getDestinationName(), destinationNode.getDomain(), messages);
            }
        }
        return true;
    }

    private boolean doBytesMessageTransfer(Collection<byte[]> messages) {
        List<DestinationConfigTreeNode> nodes = this.getSelectedDestinationNodes();
        this.lastDndAction = 1;
        if (nodes.size() > 0 && messages.size() > 0) {
            DestinationConfigTreeNode destinationNode = nodes.get(0);
            HermesTreeNode hermesNode = this.getSelectedHermesNode();
            if (hermesNode != null && destinationNode != null) {
                HermesBrowser.getBrowser().getActionFactory().createMessageCopyAction(hermesNode.getHermes(), destinationNode.getDestinationName(), destinationNode.getDomain(), messages);
            }
        }
        return true;
    }

    private boolean doMessagesTransfer(MessageGroup messages, int action) {
        List<DestinationConfigTreeNode> nodes = this.getSelectedDestinationNodes();
        if (nodes.size() > 0) {
            DestinationConfigTreeNode destinationNode = nodes.get(0);
            HermesTreeNode hermesNode = this.getSelectedHermesNode();
            if (hermesNode != null && destinationNode != null) {
                if (action == 1) {
                    HermesBrowser.getBrowser().getActionFactory().createMessageCopyAction(hermesNode.getHermes(), destinationNode.getDestinationName(), destinationNode.getDomain(), messages.getSelectedMessages());
                } else {
                    HermesBrowser.getBrowser().getActionFactory().createMessageMoveAction(hermesNode.getHermes(), destinationNode.getDestinationName(), destinationNode.getDomain(), messages.getSelectedMessages());
                }
            }
        } else if (this.getSelectionPath() != null) {
            if (this.getSelectionPath().getLastPathComponent() instanceof RepositoryTreeNode) {
                RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectionPath().getLastPathComponent();
                try {
                    node.getRepository().addMessages(messages.getHermes(), messages.getSelectedMessages());
                }
                catch (JMSException e) {
                    throw new HermesRuntimeException((Exception)((Object)e));
                }
            } else if (this.getSelectionPath().getLastPathComponent() instanceof MessageStoreTreeNode) {
                MessageStoreTreeNode node = (MessageStoreTreeNode)this.getSelectionPath().getLastPathComponent();
                HermesBrowser.getBrowser().getThreadPool().invokeLater(new AddToMessageStoreTask(node.getMessageStore(), messages.getSelectedMessages()));
            }
        } else {
            HermesBrowser.getBrowser().showErrorDialog("No session/destination selected for copy");
        }
        return true;
    }

    private boolean doContextContentTransfer(HermesConfigGroup transferData) throws NamingException, JMSException {
        if (transferData.getDestinations().size() != 0 && transferData.getFactories().size() != 0) {
            HermesBrowser.getBrowser().showErrorDialog("Can only drop ConnectionFactories or Destinations, not both");
            return false;
        }
        if (transferData.getDestinations().size() > 0) {
            Hermes hermes = null;
            if (transferData.getHermesId() != null) {
                hermes = (Hermes)HermesBrowser.getBrowser().getContext().lookup(transferData.getHermesId());
            } else if (this.getSelectedHermesNode() != null) {
                hermes = this.getSelectedHermesNode().getHermes();
            }
            if (hermes != null) {
                StringBuffer question = new StringBuffer();
                if (transferData.getDestinations().size() == 1) {
                    question.append("Do you want to add this destination to " + hermes.getId() + " ?");
                } else {
                    question.append("Do you want to add these " + transferData.getDestinations().size() + " destinations to " + hermes.getId() + " ?");
                }
                if (JOptionPane.showConfirmDialog((Component)((Object)HermesBrowser.getBrowser()), question.toString(), "Please confirm.", 0) == 0) {
                    for (DestinationConfig dConfig : transferData.getDestinations()) {
                        if (dConfig.getDomain().intValue() == Domain.UNKNOWN.getId()) {
                            Object[] options = new Object[]{"Queue", "Topic"};
                            int n = JOptionPane.showOptionDialog((Component)((Object)HermesBrowser.getBrowser()), "The destination " + dConfig.getName() + " implements both Queue and Topic interfaces, please select the domain you wish to use it in.", "Select domain", 0, 3, null, options, options[1]);
                            if (n == 0) {
                                dConfig.setDomain(Domain.QUEUE.getId());
                                HermesBrowser.getBrowser().addDestinationConfig(hermes, dConfig);
                                continue;
                            }
                            if (n != 1) continue;
                            dConfig.setDomain(Domain.TOPIC.getId());
                            HermesBrowser.getBrowser().addDestinationConfig(hermes, dConfig);
                            continue;
                        }
                        HermesBrowser.getBrowser().addDestinationConfig(hermes, dConfig);
                    }
                    HermesBrowser.getBrowser().saveConfig();
                }
            } else {
                Hermes.ui.getDefaultMessageSink().add("No session selected for drop target");
            }
        } else {
            String newName = JOptionPane.showInputDialog((Component)((Object)HermesBrowser.getBrowser()), "Session name:", "");
            if (newName != null && !newName.equals("")) {
                if (!this.getAllHermesIds().contains(newName)) {
                    FactoryConfig fConfig = transferData.getFactories().iterator().next();
                    HermesBrowser.getConfigDAO().renameSession(fConfig, newName);
                    HermesBrowser.getBrowser().getConfig().getFactory().add(fConfig);
                    HermesBrowser.getBrowser().saveConfig();
                    HermesBrowser.getBrowser().loadConfig();
                } else {
                    HermesBrowser.getBrowser().showErrorDialog("Session " + newName + " is already in use.");
                }
            }
        }
        return true;
    }

    private boolean doLocalTransfer(Transferable t, int action) {
        if (HermesBrowser.getBrowser().isRestrictedWithWarning()) {
            return false;
        }
        try {
            if (t.isDataFlavorSupported(JMSMessagesTransferable.FLAVOR)) {
                return this.doMessagesTransfer((MessageGroup)t.getTransferData(JMSMessagesTransferable.FLAVOR), action);
            }
            if (t.isDataFlavorSupported(JMSAdministeredObjectTransferable.FLAVOR)) {
                return this.doContextContentTransfer((HermesConfigGroup)t.getTransferData(JMSAdministeredObjectTransferable.FLAVOR));
            }
            if (t.isDataFlavorSupported(MessagesTransferable.BYTE_FLAVOR)) {
                return this.doBytesMessageTransfer((Collection)t.getTransferData(MessagesTransferable.BYTE_FLAVOR));
            }
            if (t.isDataFlavorSupported(HermesAdministeredObjectTransferable.FLAVOR) && this.getSelectionPath().getLastPathComponent() instanceof NamingConfigTreeNode) {
                NamingConfigTreeNode namingConfigTreeNode = (NamingConfigTreeNode)this.getSelectionPath().getLastPathComponent();
                Collection objects = (Collection)t.getTransferData(HermesAdministeredObjectTransferable.FLAVOR);
                JNDIContextFactory contextFactory = new JNDIContextFactory(namingConfigTreeNode.getConfig());
                BindToolDialog bindTool = new BindToolDialog((Frame)((Object)HermesBrowser.getBrowser()), contextFactory, "", objects);
                bindTool.pack();
                JideSwingUtilities.centerWindow((Window)((Object)bindTool));
                bindTool.show();
                return true;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            JOptionPane.showMessageDialog(this, "During transfer: " + ex.getMessage(), "Error", 0);
        }
        return false;
    }

    public boolean doTransfer(Transferable t, int action) {
        try {
            log.debug((Object)t.getTransferDataFlavors()[0]);
            if (t.getTransferDataFlavors()[0].isMimeTypeEqual("application/x-java-file-list")) {
                return this.doJavaFileTransfer((List)t.getTransferData(DataFlavor.javaFileListFlavor));
            }
            return this.doLocalTransfer(t, action);
        }
        catch (UnsupportedFlavorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        TreeNode leafNode;
        TreePath path = this.getPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        if (path != null && (leafNode = (TreeNode)path.getLastPathComponent()).getChildCount() > 0) {
            TreePath newPath = path.pathByAddingChild(leafNode.getChildAt(0));
            this.expandPath(newPath);
            this.setSelectionPath(path);
            this.repaint();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public Collection<String> getAllHermesIds() {
        return this.model.getAllHermesIds();
    }

    private String getDestinationTooltip(Hermes hermes, DestinationConfig dConfig) throws JMSException, NamingException {
        Map map = hermes.getStatistics(dConfig);
        return HTMLBeanHelper.format(map);
    }

    public Collection<TreeNode> getSelectedAdministeredObjectNodes() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        ArrayList<TreeNode> rval = new ArrayList<TreeNode>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                TreePath path = paths[i];
                if (path.getLastPathComponent() instanceof DestinationConfigTreeNode) {
                    DestinationConfigTreeNode destinationNode = (DestinationConfigTreeNode)path.getLastPathComponent();
                    rval.add(destinationNode);
                    continue;
                }
                if (!(path.getLastPathComponent() instanceof HermesTreeNode)) continue;
                HermesTreeNode hermesNode = (HermesTreeNode)path.getLastPathComponent();
                rval.add(hermesNode);
            }
        }
        return rval;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
            return null;
        }
        TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
        Object component = curPath.getLastPathComponent();
        if (component != null) {
            if (component instanceof HermesTreeNode) {
                try {
                    return ((HermesTreeNode)component).getHermes().getMetaData().getToolTipText();
                }
                catch (JMSException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (component instanceof NamingConfigTreeNode) {
                try {
                    NamingConfigTreeNode nNode = (NamingConfigTreeNode)component;
                    return nNode.getToolTipText();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            if (component instanceof DestinationConfigTreeNode) {
                return ((DestinationConfigTreeNode)component).getToolTipText();
            }
            if (component instanceof RepositoryTreeNode) {
                return ((RepositoryTreeNode)component).getRepository().getToolTipText();
            }
            if (component instanceof MessageStoreTreeNode) {
                return ((MessageStoreTreeNode)component).getMessageStore().getTooltipText();
            }
            if (component instanceof MessageStoreURLTreeNode) {
                return ((MessageStoreURLTreeNode)component).getTooltipText();
            }
        }
        return null;
    }

    public void init() {
        this.getSelectionModel().setSelectionMode(4);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        this.setCellRenderer(new BrowserTreeCellRenderer());
        this.getSelectionModel().addTreeSelectionListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                BrowserTree.this.maybeDoBrowse(e);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                BrowserTree.this.maybeDoPopup(e);
            }
        });
        DataTipManager.get().register((JTree)this);
        try {
            this.getDropTarget().addDropTargetListener(this);
        }
        catch (TooManyListenersException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
        this.popupMenu = PopupMenuFactory.createBrowserTreePopup(this);
    }

    public boolean isCurrentSelectionADestination() {
        return this.getSelectionPath() != null && this.getSelectionPath().getLastPathComponent() instanceof DestinationConfigTreeNode;
    }

    public boolean isCurrentSelectionASession() {
        return this.getSelectionPath() != null && this.getSelectionPath().getLastPathComponent() instanceof HermesTreeNode;
    }

    public void maybeDoBrowse(MouseEvent e) {
        TreePath path;
        if (e.getClickCount() == 2 && (path = this.getPathForLocation(e.getX(), e.getY())) != null) {
            ActionRegistry.getAction(BrowseDestinationOrContextAction.class).actionPerformed(null);
        }
    }

    boolean maybeDoPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
        return true;
    }

    public void nodeStructureChanged(TreeNode node) {
        this.model.nodeStructureChanged(node);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath treePath = e.getNewLeadSelectionPath();
        try {
            if (treePath != null) {
                for (int i = 0; i < treePath.getPathCount(); ++i) {
                    AbstractTreeNode node;
                    if (treePath.getPathComponent(i) instanceof HermesTreeNode) {
                        node = (HermesTreeNode)treePath.getPathComponent(i);
                        this.lastSelectedHermesTreeNode = node;
                        this.setToolTipText(((HermesTreeNode)node).getHermes().getMetaData().getToolTipText());
                        continue;
                    }
                    if (treePath.getPathComponent(i) instanceof DestinationConfigTreeNode) {
                        node = (DestinationConfigTreeNode)treePath.getPathComponent(i);
                        this.setToolTipText(((DestinationConfigTreeNode)node).getDestinationName());
                        continue;
                    }
                    if (treePath.getPathComponent(i) instanceof RepositoryTreeNode) {
                        node = (RepositoryTreeNode)treePath.getPathComponent(i);
                        this.setToolTipText(((RepositoryTreeNode)node).getRepository().getId());
                        continue;
                    }
                    if (treePath.getPathComponent(i) instanceof MessageStoreTreeNode) {
                        node = (MessageStoreTreeNode)treePath.getPathComponent(i);
                        this.setToolTipText(((MessageStoreTreeNode)node).getMessageStore().getTooltipText());
                        continue;
                    }
                    if (!(treePath.getPathComponent(i) instanceof MessageStoreURLTreeNode)) continue;
                    node = (MessageStoreURLTreeNode)treePath.getPathComponent(i);
                    this.setToolTipText(((MessageStoreURLTreeNode)node).getURL());
                }
            }
        }
        catch (JMSException ex) {
            Hermes.ui.getDefaultMessageSink().add(ex.getMessage());
        }
    }
}

