/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class IconCache {
    private static final Logger log = Logger.getLogger(IconCache.class);
    private static final String PROPERTIES = "hermes/browser/icons/iconcache.properties";
    public static final String TOPIC = "hermes/browser/icons/topic.gif";
    public static final String QUEUE = "hermes/browser/icons/queue.gif";
    public static final String QUEUE_OR_TOPIC = "hermes/browser/icons/queueOrTopic.gif";
    public static final String UNKNOWN = "hermes/browser/icons/queueOrTopic.gif";
    public static final String CONNECTION_FACTORY = "hermes/browser/icons/connectionFactory.gif";
    public static final String XML_FILE = "hermes/browser/icons/xml_message_file.gif";
    public static final String HERMES_OPEN = "hermes/browser/icons/hermes_folder_open.gif";
    public static final String HERMES_CLOSED = "hermes/browser/icons/hermes_folder_closed.gif";
    public static final String FORM_BANNER = "hermes/browser/icons/form_banner.gif";
    public static final String JNDI = "hermes/browser/icons/jndi.gif";
    public static final String NEW_CONTEXT = "hermes/browser/icons/new_context.gif";
    public static final String ERROR = "hermes/browser/icons/error.gif";
    public static final String JNDI_LARGE = "hermes/browser/icons/jndi_large.gif";
    public static final String COPY_MESSAGES = "toolbarButtonGraphics/general/Copy16.gif";
    public static final String REMOVE_MESSAGES = "toolbarButtonGraphics/general/Remove16.gif";
    public static final String SEND_MESSAGES = "toolbarButtonGraphics/general/Import16.gif";
    public static final String WATCH_QUEUES = "toolbarButtonGraphics/general/Search16.gif";
    public static final String BROWSER_TREE = "toolbarButtonGraphics/general/Search16.gif";
    private static Map<String, ImageIcon> cacheById = new HashMap<String, ImageIcon>();
    private static Map<String, ImageIcon> cacheByLocation = new HashMap<String, ImageIcon>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getIcon(String imageName) {
        Map<String, ImageIcon> map = cacheById;
        synchronized (map) {
            if (cacheById.containsKey(imageName)) {
                return cacheById.get(imageName);
            }
        }
        map = cacheByLocation;
        synchronized (map) {
            ImageIcon icon = cacheByLocation.get(imageName);
            if (icon == null) {
                URL imgURL = IconCache.class.getClassLoader().getResource(imageName);
                icon = imgURL == null ? new ImageIcon(imageName) : new ImageIcon(imgURL);
                cacheByLocation.put(imageName, icon);
            }
            return icon;
        }
    }

    static {
        Properties properties = null;
        try {
            properties = new Properties();
            properties.load(IconCache.class.getClassLoader().getResource(PROPERTIES).openStream());
        }
        catch (IOException e) {
            log.fatal((Object)("cannot load hermes/browser/icons/iconcache.properties: " + e.getMessage()), (Throwable)e);
        }
        if (properties != null) {
            for (String string : properties.keySet()) {
                String location = (String)properties.get(string);
                try {
                    ImageIcon icon = IconCache.getIcon(location);
                    cacheById.put(string, icon);
                }
                catch (RuntimeException e) {
                    log.error((Object)("cannot load image id=" + string + " from " + location + ": " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

