/*
 * Decompiled with CFR 0.152.
 */
package hermes.ant;

import hermes.Hermes;
import hermes.HermesWatchListener;
import hermes.HermesWatchManager;
import hermes.ant.AbstractTask;
import hermes.ant.DestinationSelectionType;
import hermes.ant.HermesFactory;
import hermes.ant.HermesSelectionType;
import hermes.config.DestinationConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Target;

public class RegisterDepthTrigger
extends AbstractTask
implements HermesWatchListener {
    private HermesWatchManager watchManager;
    private List<HermesSelectionType> selections = new ArrayList<HermesSelectionType>();
    private int depth = 0;
    private String target;
    private String exception;
    private String hermesProperty = "alert.hermes.id";
    private String destinationProperty = "alert.hermes.destination";
    private String messageProperty = "alert.message";

    public RegisterDepthTrigger() {
        this.watchManager = new HermesWatchManager();
        this.watchManager.setUpdateOnNewWatchAdded(true);
    }

    public void addConfigured(HermesSelectionType h) {
        this.selections.add(h);
    }

    public void execute() throws BuildException {
        if (!this.getProject().getTargets().containsKey(this.target)) {
            throw new BuildException("target " + this.target + " does not exist in build file");
        }
        for (HermesSelectionType hermesSelection : this.selections) {
            this.watch(hermesSelection);
        }
    }

    private void watch(HermesSelectionType hermesSelection) throws BuildException {
        try {
            Hermes hermes = HermesFactory.createHermes(this.getConfig(), hermesSelection.getName());
            for (DestinationSelectionType destinationSelection : hermesSelection.getDestinationSelections()) {
            }
        }
        catch (NamingException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void onDepthChange(Hermes hermes, DestinationConfig dConfig, long currentDepth) {
        if (currentDepth > (long)this.depth) {
            Target invokeTarget = (Target)this.getProject().getTargets().get(this.getTarget());
            this.log(dConfig.getName() + " on " + hermes.getId() + " has triggered, currentDepth=" + currentDepth);
            System.setProperty(this.getHermesProperty(), hermes.getId());
            System.setProperty(this.getDestinationProperty(), dConfig.getName());
            System.setProperty(this.getMessageProperty(), "depth=" + currentDepth);
            invokeTarget.execute();
        }
    }

    public void onException(Hermes hermes, DestinationConfig dConfig, Exception e) {
    }

    public void onOldestMessageChange(Hermes hermes, DestinationConfig dConfig, Date oldest) {
    }

    public void onPropertyChange(Hermes hermes, DestinationConfig dConfig, Map properties) {
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getDestinationProperty() {
        return this.destinationProperty;
    }

    public void setDestinationProperty(String destinationProperty) {
        this.destinationProperty = destinationProperty;
    }

    public String getHermesProperty() {
        return this.hermesProperty;
    }

    public void setHermesProperty(String hermesProperty) {
        this.hermesProperty = hermesProperty;
    }

    public String getMessageProperty() {
        return this.messageProperty;
    }

    public void setMessageProperty(String messageProperty) {
        this.messageProperty = messageProperty;
    }
}

