/*
 * Decompiled with CFR 0.152.
 */
package hermes.ant;

import hermes.Domain;
import hermes.Hermes;
import hermes.ant.HermesFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.log4j.Logger;

public class MessageSender {
    private static final Logger log = Logger.getLogger(MessageSender.class);

    public Message createMessage(Hermes hermes) throws JMSException {
        return hermes.createMessage();
    }

    public MessageSender create() {
        return new MessageSender();
    }

    public static void main(String[] args) {
        new MessageSender().doMain(args);
    }

    public void doMain(String[] args) {
        try {
            Hermes hermes = HermesFactory.createHermes("../cfg/web-hermes-config.xml", "ActiveMQ");
            Destination queue = hermes.getDestination("Q1", Domain.QUEUE);
            Message message = this.createMessage(hermes);
            hermes.send(queue, message);
            if (hermes.getTransacted()) {
                hermes.commit();
            }
            hermes.close();
            System.exit(1);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

