/*
 * Decompiled with CFR 0.152.
 */
package hermes;

import hermes.HermesException;
import hermes.SingletonManager;
import hermes.config.NamingConfig;
import hermes.impl.ClassLoaderManager;
import hermes.impl.LoaderSupport;
import hermes.util.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JNDIContextFactory {
    private static final Logger log = Logger.getLogger(JNDIContextFactory.class);
    public static final String PORT = "java.naming.factory.port";
    public static final String HOST = "java.naming.factory.host";
    private String initialContextFactory;
    private String providerURL;
    private String binding;
    private String authoritative;
    private String batchSize;
    private String dnsUrl;
    private String language;
    private String objectFactories;
    private String securityAuthentication;
    private String securityCredentials;
    private String securityPrincipal;
    private String securityProtocol;
    private String stateFactories;
    private String urlPkgPrefixes;
    private String referral;
    private String host;
    private String port;
    private ClassLoader delegateClassLoader;
    private File userPropertiesFile;
    private String userPropertiesURL;

    public JNDIContextFactory() {
    }

    public JNDIContextFactory(NamingConfig namingConfig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        ClassLoaderManager classLoaderManager = (ClassLoaderManager)SingletonManager.get(ClassLoaderManager.class);
        this._setDelegateClassLoader(classLoaderManager.getClassLoader(namingConfig.getClasspathId()));
        LoaderSupport.populateBean(this, namingConfig.getProperties());
    }

    public void _setDelegateClassLoader(ClassLoader loader) {
        this.delegateClassLoader = loader;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public Properties _getProperties() throws NamingException {
        Properties properties = new Properties();
        if (this.initialContextFactory != null) {
            properties.put("java.naming.factory.initial", this.initialContextFactory);
        }
        if (this.providerURL != null) {
            properties.put("java.naming.provider.url", this.providerURL);
        }
        if (this.referral != null) {
            properties.put("java.naming.referral", this.referral);
        }
        if (this.authoritative != null) {
            properties.put("java.naming.authoritative", this.authoritative);
        }
        if (this.batchSize != null) {
            properties.put("java.naming.batchsize", this.batchSize);
        }
        if (this.dnsUrl != null) {
            properties.put("java.naming.dns.url", this.dnsUrl);
        }
        if (this.language != null) {
            properties.put("java.naming.language", this.language);
        }
        if (this.objectFactories != null) {
            properties.put("java.naming.factory.object", this.objectFactories);
        }
        if (this.securityCredentials != null) {
            properties.put("java.naming.security.credentials", this.securityCredentials);
        }
        if (this.securityPrincipal != null) {
            properties.put("java.naming.security.principal", this.securityPrincipal);
        }
        if (this.securityProtocol != null) {
            properties.put("java.naming.security.protocol", this.securityProtocol);
        }
        if (this.securityAuthentication != null) {
            properties.put("java.naming.security.authentication", this.securityAuthentication);
        }
        if (this.stateFactories != null) {
            properties.put("java.naming.factory.state", this.stateFactories);
        }
        if (this.urlPkgPrefixes != null) {
            properties.put("java.naming.factory.url.pkgs", this.urlPkgPrefixes);
        }
        if (this.port != null) {
            properties.put(PORT, this.port);
        }
        if (this.host != null) {
            properties.put(HOST, this.host);
        }
        Properties userProperties = new Properties();
        try {
            if (!TextUtils.isEmpty(this.userPropertiesURL)) {
                try {
                    userProperties.load(new URL(this.userPropertiesURL).openStream());
                }
                catch (IOException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new NamingException("Cannot load properties from " + this.userPropertiesURL + ": " + ex.getMessage());
                }
            } else if (this.userPropertiesFile != null) {
                userProperties.load(new FileInputStream(this.userPropertiesFile));
            }
            properties.putAll((Map<?, ?>)userProperties);
        }
        catch (Throwable e) {
            log.error((Object)("loading user properties: " + e.getMessage()), e);
            throw new NamingException(e.getMessage());
        }
        log.debug((Object)("properties: " + properties));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createContext() throws JMSException {
        if (this.initialContextFactory == null) {
            throw new HermesException("initialContextFactory not set");
        }
        try {
            if (this.delegateClassLoader == null) {
                return new InitialContext(this._getProperties());
            }
            Thread.currentThread().setContextClassLoader(this.delegateClassLoader);
            InitialContext context = null;
            context = new InitialContext(this._getProperties());
            return context;
        }
        catch (Exception e) {
            log.error((Object)(e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
            if (e.getMessage() != null) {
                throw new JMSException("Could not create InitialContext: " + e.getMessage());
            }
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                throw new JMSException("Could not create InitialContext: " + e.getCause().getMessage());
            }
            throw new HermesException("Could not create InitialContext", e);
        }
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public void setInitialContextFactory(String string) {
        this.initialContextFactory = string;
    }

    public void setProviderURL(String string) {
        this.providerURL = string;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String string) {
        this.binding = string;
    }

    public String getAuthoritative() {
        return this.authoritative;
    }

    public void setAuthoritative(String authoritative) {
        this.authoritative = authoritative;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getDnsUrl() {
        return this.dnsUrl;
    }

    public void setDnsUrl(String dnsUrl) {
        this.dnsUrl = dnsUrl;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getObjectFactories() {
        return this.objectFactories;
    }

    public void setObjectFactories(String objectFactories) {
        this.objectFactories = objectFactories;
    }

    public String getReferral() {
        return this.referral;
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    public String getSecurityAuthentication() {
        return this.securityAuthentication;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this.securityAuthentication = securityAuthentication;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.securityPrincipal = securityPrincipal;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public String getStateFactories() {
        return this.stateFactories;
    }

    public void setStateFactories(String stateFactories) {
        this.stateFactories = stateFactories;
    }

    public String getUrlPkgPrefixes() {
        return this.urlPkgPrefixes;
    }

    public void setUrlPkgPrefixes(String urlPkgPrefixes) {
        this.urlPkgPrefixes = urlPkgPrefixes;
    }

    public File getUserPropertiesFile() {
        return this.userPropertiesFile;
    }

    public void setUserPropertiesFile(File userPropertiesFile) {
        this.userPropertiesFile = userPropertiesFile;
    }

    public String getUserPropertiesURL() {
        return this.userPropertiesURL;
    }

    public void setUserPropertiesURL(String userPropertiesURL) {
        this.userPropertiesURL = userPropertiesURL;
    }
}

