/*
 * Decompiled with CFR 0.152.
 */
package hermes;

import hermes.Hermes;
import hermes.HermesException;
import hermes.HermesWatchListener;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.impl.DestinationConfigKeyWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class HermesWatchManager {
    private static final Logger log = Logger.getLogger(HermesWatchManager.class);
    public static final int DEFAULT_DEPTH_ALERT = 0;
    public static final long DEFAULT_AGE_ALERT = 0L;
    private final Timer timer = new Timer();
    private final Map<DestinationConfigKeyWrapper, State> watchStatistics = new HashMap<DestinationConfigKeyWrapper, State>();
    private boolean keepRunning = true;
    private long timeout = 30000L;
    private boolean updateOnNewWatchAdded = false;

    public HermesWatchManager() {
        this.timer.schedule(new TimerTask(){

            public void run() {
                HermesWatchManager.this.doUpdate();
            }
        }, this.timeout, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<DestinationConfigKeyWrapper, State> map = this.watchStatistics;
        synchronized (map) {
            this.watchStatistics.clear();
        }
    }

    public void updateNow() {
        this.timer.schedule(new TimerTask(){

            public void run() {
                HermesWatchManager.this.doUpdate();
            }
        }, 0L);
    }

    public void close() {
        this.clear();
        this.keepRunning = false;
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWatch(Hermes hermes, DestinationConfig destination, HermesWatchListener listener) throws JMSException {
        if (!this.keepRunning) {
            throw new HermesException("WatchManager is not running");
        }
        DestinationConfig dConfig = HermesBrowser.getConfigDAO().duplicateForWatch(destination, hermes);
        Map<DestinationConfigKeyWrapper, State> map = this.watchStatistics;
        synchronized (map) {
            State stats;
            DestinationConfigKeyWrapper key = new DestinationConfigKeyWrapper(dConfig);
            if (this.watchStatistics.containsKey(key)) {
                stats = this.watchStatistics.get(key);
            } else {
                stats = new State();
                stats.hermes = hermes;
                stats.dConfig = dConfig;
                this.watchStatistics.put(key, stats);
            }
            stats.listeners.add(listener);
        }
        if (this.isUpdateOnNewWatchAdded()) {
            this.updateNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWatch(Hermes hermes, String destination, HermesWatchListener listener) throws JMSException {
        if (!this.keepRunning) {
            throw new HermesException("WatchManager is not running");
        }
        Map<DestinationConfigKeyWrapper, State> map = this.watchStatistics;
        synchronized (map) {
            if (this.watchStatistics.containsKey(hermes.getId() + ":" + destination)) {
                State stats = this.watchStatistics.get(hermes.getId() + ":" + destination);
                stats.listeners.remove(listener);
                if (stats.listeners.size() == 0) {
                    this.watchStatistics.remove(hermes.getId() + ":" + destination);
                }
            } else {
                throw new HermesException("No watch exists for " + destination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        HashMap<DestinationConfigKeyWrapper, State> watchStatisticsCopy = new HashMap<DestinationConfigKeyWrapper, State>();
        HashSet<Hermes> hermesToClose = new HashSet<Hermes>();
        Map<DestinationConfigKeyWrapper, State> map = this.watchStatistics;
        synchronized (map) {
            watchStatisticsCopy.putAll(this.watchStatistics);
        }
        for (Map.Entry entry : watchStatisticsCopy.entrySet()) {
            State stats = (State)entry.getValue();
            try {
                this.updateWatchStatistics(stats);
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
            }
            finally {
                hermesToClose.add(stats.hermes);
            }
        }
        for (Hermes hermes : hermesToClose) {
            log.debug((Object)("closing Hermes " + hermes.getId()));
            try {
                hermes.close();
            }
            catch (JMSException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateWatchStatistics(State stats) {
        Hermes hermes = stats.hermes;
        long previousDepth = stats.depth;
        try {
            try {
                stats.depth = hermes.getDepth(stats.dConfig);
            }
            catch (JMSException ex) {
                log.error((Object)("cannot get depth: " + ex.getMessage()));
                stats.depth = 0L;
            }
            try {
                stats.oldest = stats.depth > 0L ? new Date(hermes.getAge(stats.dConfig)) : null;
            }
            catch (JMSException ex) {
                log.error((Object)("cannot get oldest " + ex.getMessage()));
                stats.oldest = null;
            }
            stats.statistics = hermes.getStatistics(stats.dConfig);
            if (previousDepth != stats.depth) {
                for (HermesWatchListener listener : stats.listeners) {
                    listener.onDepthChange(hermes, stats.dConfig, stats.depth);
                }
            }
            for (HermesWatchListener listener : stats.listeners) {
                listener.onOldestMessageChange(hermes, stats.dConfig, stats.oldest);
            }
            for (HermesWatchListener listener : stats.listeners) {
                listener.onPropertyChange(hermes, stats.dConfig, stats.statistics);
            }
            if (stats.e != null) {
                stats.e = null;
                for (HermesWatchListener listener : stats.listeners) {
                    listener.onException(hermes, stats.dConfig, null);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            if (stats.e == null) {
                stats.e = e;
                for (HermesWatchListener listener : stats.listeners) {
                    listener.onException(hermes, stats.dConfig, e);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
        }
    }

    public boolean isUpdateOnNewWatchAdded() {
        return this.updateOnNewWatchAdded;
    }

    public void setUpdateOnNewWatchAdded(boolean updateOnNewWatchAdded) {
        this.updateOnNewWatchAdded = updateOnNewWatchAdded;
    }

    private static class State {
        public Hermes hermes;
        public DestinationConfig dConfig;
        public long depth;
        public Date oldest;
        public Exception e;
        public Map statistics;
        public Collection<HermesWatchListener> listeners = new ArrayList<HermesWatchListener>();

        private State() {
        }
    }
}

