/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.transport;

import java.util.Properties;
import org.uddi4j.transport.Transport;
import org.uddi4j.transport.TransportException;

public class TransportFactory {
    public static final String PROPERTY_NAME = "org.uddi4j.TransportClassName";
    public static final String DEFAULT_TRANSPORT_NAME = "org.uddi4j.transport.ApacheSOAPTransport";
    private Transport transport = null;
    private static String transportClassName = null;
    Properties config = null;

    private TransportFactory(Properties p) {
        this.config = p;
    }

    public Transport getTransport() throws TransportException {
        if (this.transport == null) {
            transportClassName = this.config.getProperty(PROPERTY_NAME, DEFAULT_TRANSPORT_NAME);
            try {
                this.transport = (Transport)Class.forName(transportClassName).newInstance();
                if ("true".equals(this.config.getProperty("org.uddi4j.logEnabled"))) {
                    System.err.println("TransportFactory: Using transport name:" + transportClassName);
                }
            }
            catch (Exception e) {
                throw new TransportException(e);
            }
        }
        return this.transport;
    }

    public static TransportFactory newInstance() {
        return new TransportFactory(System.getProperties());
    }

    public static TransportFactory newInstance(Properties p) {
        return new TransportFactory(p);
    }
}

