/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.security;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.process.CurrentProcess;
import com.jniwrapper.win32.security.Sid;
import com.jniwrapper.win32.security.TokenGroups;
import com.jniwrapper.win32.security.TokenPrivileges;
import com.jniwrapper.win32.system.AdvApi32;

public class AccessToken
extends Handle {
    public static final int TOKEN_ASSIGN_PRIMARY = 1;
    public static final int TOKEN_DUPLICATE = 2;
    public static final int TOKEN_IMPERSONATE = 4;
    public static final int TOKEN_QUERY = 8;
    public static final int TOKEN_QUERY_SOURCE = 16;
    public static final int TOKEN_ADJUST_PRIVILEGES = 32;
    public static final int TOKEN_ADJUST_GROUPS = 64;
    public static final int TOKEN_ADJUST_DEFAULT = 128;
    public static final int TOKEN_ADJUST_SESSIONID = 256;
    private static final int SE_PRIVILEGE_ENABLED = 2;
    private static final String FUNCTION_OPEN_PROCESS_TOKEN = "OpenProcessToken";
    private static final String FUNCTION_GET_TOKEN_INFORMATION = "GetTokenInformation";
    private static final String FUNCTION_ADJUST_TOKEN_PRIVILEGES = "AdjustTokenPrivileges";
    private static final String FUNCTION_CHECK_TOKEN_MEMBERSHIP = "CheckTokenMembership";

    public AccessToken() {
        AccessToken.openProcessToken(new CurrentProcess(), 40, this);
    }

    public static boolean openProcessToken(Handle processHandle, int desiredAcces, Handle resultToken) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_OPEN_PROCESS_TOKEN);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue, new Parameter[]{processHandle, new UInt32((long)desiredAcces), new Pointer((Parameter)resultToken)});
        return returnValue.getValue();
    }

    public static boolean getTokenInformation(Handle tokenHandle, TokenInformationClass tokenInformationClass, Parameter tokenUserPtrVoid, UInt32 tokenInformationLength, Pointer returnLength) {
        IntBool result = new IntBool();
        Function getTokenInformation = AdvApi32.get(FUNCTION_GET_TOKEN_INFORMATION);
        getTokenInformation.invoke((Parameter)result, new Parameter[]{tokenHandle, new Int((long)tokenInformationClass.getValue()), tokenUserPtrVoid, tokenInformationLength, returnLength});
        return result.getValue() != 0L;
    }

    public boolean enablePrivelege(String name) {
        TokenPrivileges tokenPrivileges = TokenPrivileges.lookup(name);
        if (tokenPrivileges != null) {
            tokenPrivileges.setPrivilegeCount(1);
            tokenPrivileges.getPrivileges(0).setAttributes(2);
            return this.adjustTokenPrivileges(tokenPrivileges);
        }
        return false;
    }

    private boolean adjustTokenPrivileges(TokenPrivileges newState) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_ADJUST_TOKEN_PRIVILEGES);
        Bool returnValue = new Bool();
        long lastError = function.invoke((Parameter)returnValue, new Parameter[]{this, new Int(0L), new Pointer((Parameter)newState), new UInt32(0L), new Handle(), new Pointer((Parameter)new UInt32())});
        return returnValue.getValue() && lastError == 0L;
    }

    public TokenGroups getTokenGroups() {
        UInt32 retVal = new UInt32(0L);
        TokenGroups tokenGroups = new TokenGroups();
        Pointer tokenGroupsPtr = new Pointer((Parameter)tokenGroups);
        AccessToken.getTokenInformation(this, TokenInformationClass.TOKEN_GROUPS, (Parameter)tokenGroupsPtr, new UInt32((long)tokenGroups.getLength()), new Pointer((Parameter)retVal));
        int structSize = (int)retVal.getValue();
        if (structSize > 0) {
            tokenGroups.setExpectedStructureSize(structSize);
            UInt32 resSize = new UInt32();
            boolean res = AccessToken.getTokenInformation(this, TokenInformationClass.TOKEN_GROUPS, (Parameter)new Pointer((Parameter)tokenGroups), retVal, new Pointer((Parameter)resSize));
            if (res) {
                return tokenGroups;
            }
        }
        return null;
    }

    public static boolean checkTokenMembership(AccessToken accessToken, Sid sidToCheck) {
        Bool result = new Bool();
        Function checkTokenMembership = AdvApi32.get(FUNCTION_CHECK_TOKEN_MEMBERSHIP);
        Bool isMember = new Bool();
        Handle token = accessToken == null ? new Handle() : accessToken;
        long res = checkTokenMembership.invoke((Parameter)result, new Parameter[]{token, new Pointer((Parameter)sidToCheck), new Pointer((Parameter)isMember)});
        if (!result.getValue()) {
            throw new LastErrorException(res);
        }
        return isMember.getValue();
    }

    public static class TokenInformationClass
    extends EnumItem {
        public static final TokenInformationClass TOKEN_USER = new TokenInformationClass(1);
        public static final TokenInformationClass TOKEN_GROUPS = new TokenInformationClass(2);
        public static final TokenInformationClass TOKEN_PRIVILEGES = new TokenInformationClass(2);
        public static final TokenInformationClass TOKEN_OWNER = new TokenInformationClass(3);
        public static final TokenInformationClass TOKEN_PRIMARY_GROUP = new TokenInformationClass(5);
        public static final TokenInformationClass TOKEN_DEFAULT_DACL = new TokenInformationClass(6);
        public static final TokenInformationClass TOKEN_SOURCE = new TokenInformationClass(7);
        public static final TokenInformationClass TOKEN_TYPE = new TokenInformationClass(8);
        public static final TokenInformationClass TOKEN_IMPERSONATION_LEVEL = new TokenInformationClass(9);
        public static final TokenInformationClass TOKEN_STATISTICS = new TokenInformationClass(10);
        public static final TokenInformationClass TOKEN_RESTRICTED_SIDS = new TokenInformationClass(11);
        public static final TokenInformationClass TOKEN_SESSION_ID = new TokenInformationClass(12);
        public static final TokenInformationClass TOKEN_GROUPS_AND_PRIVILEGES = new TokenInformationClass(13);
        public static final TokenInformationClass TOKEN_SESSION_REFERENCE = new TokenInformationClass(14);
        public static final TokenInformationClass TOKEN_SAND_BOX_INERT = new TokenInformationClass(15);
        public static final TokenInformationClass TOKEN_AUDIT_POLICY = new TokenInformationClass(16);
        public static final TokenInformationClass TOKEN_ORIGIN = new TokenInformationClass(17);

        private TokenInformationClass(int value) {
            super(value);
        }
    }
}

