/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.hook.CBTEvent;
import com.jniwrapper.win32.hook.CallWndProcEvent;
import com.jniwrapper.win32.hook.CallWndProcRetEvent;
import com.jniwrapper.win32.hook.EventsFilter;
import com.jniwrapper.win32.hook.ForegroungIdleEvent;
import com.jniwrapper.win32.hook.GetMsgEvent;
import com.jniwrapper.win32.hook.Hook;
import com.jniwrapper.win32.hook.HookEventObject;
import com.jniwrapper.win32.hook.JournalRecordEvent;
import com.jniwrapper.win32.hook.KeyboardEvent;
import com.jniwrapper.win32.hook.MouseEvent;
import com.jniwrapper.win32.hook.ShellEvent;
import com.jniwrapper.win32.hook.SysMsgProcEvent;
import com.jniwrapper.win32.hook.data.CBTACTIVATESTRUCT;
import com.jniwrapper.win32.hook.data.CBTProcData;
import com.jniwrapper.win32.hook.data.CWndProcRetStructure;
import com.jniwrapper.win32.hook.data.CWndProcStructure;
import com.jniwrapper.win32.hook.data.EventMessageStructure;
import com.jniwrapper.win32.hook.data.ForegroungIdleHookData;
import com.jniwrapper.win32.hook.data.GetMsgHookData;
import com.jniwrapper.win32.hook.data.JournalRecordHookData;
import com.jniwrapper.win32.hook.data.KeyboardHookData;
import com.jniwrapper.win32.hook.data.MouseHookData;
import com.jniwrapper.win32.hook.data.MouseHookStructure;
import com.jniwrapper.win32.hook.data.ShellHookData;
import com.jniwrapper.win32.hook.data.SysMsgProcHookData;
import com.jniwrapper.win32.hook.data.WndProcHookData;
import com.jniwrapper.win32.hook.data.WndProcRetHookData;
import com.jniwrapper.win32.ui.Wnd;
import java.util.HashMap;
import java.util.Map;

public class HooksData
extends Structure {
    private MouseHookData _mouseHookData = new MouseHookData();
    private KeyboardHookData _keyboardHookData = new KeyboardHookData();
    private WndProcHookData _wndProcHookData = new WndProcHookData();
    private WndProcRetHookData _wndProcRetHookData = new WndProcRetHookData();
    private GetMsgHookData _getMsgHookData = new GetMsgHookData();
    private SysMsgProcHookData _sysMsgProcHookData = new SysMsgProcHookData();
    private ShellHookData _shellHookData = new ShellHookData();
    private ForegroungIdleHookData _foregroungIdleHookData = new ForegroungIdleHookData();
    private JournalRecordHookData _journalRecordHookData = new JournalRecordHookData();
    private CBTProcData _cbtHookData = new CBTProcData();
    private static final Map DESCRIPTOR2READER = new HashMap();

    public HooksData() {
        this.init(new Parameter[]{this._mouseHookData, this._keyboardHookData, this._wndProcHookData, this._wndProcRetHookData, this._getMsgHookData, this._sysMsgProcHookData, this._shellHookData, this._foregroungIdleHookData, this._journalRecordHookData, this._cbtHookData}, (short)1);
    }

    public HooksData(HooksData that) {
        this();
        this.initFrom(that);
    }

    public Object clone() {
        return new HooksData(this);
    }

    public HookEventObject readEvent(Hook.Descriptor descriptor) {
        HookEventReader reader = (HookEventReader)DESCRIPTOR2READER.get((Object)descriptor);
        return reader.readEvent(this);
    }

    public void setSynchronous(Hook hook, boolean value) {
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.MOUSE)) {
            this._mouseHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.KEYBOARD)) {
            this._keyboardHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.CALLWNDPROC)) {
            this._wndProcHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.CALLWNDPROCRET)) {
            this._wndProcRetHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.GETMESSAGE)) {
            this._getMsgHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.SYSMSGFILTER)) {
            this._sysMsgProcHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.SHELL)) {
            this._shellHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.FOREGROUNDIDLE)) {
            this._foregroungIdleHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.JOURNALRECORD)) {
            this._journalRecordHookData.setSyncronous(value);
        } else if (hook.getDescriptor().equals((Object)Hook.Descriptor.CBT)) {
            this._cbtHookData.setSyncronous(value);
        } else {
            throw new IllegalArgumentException("Unknown hook type: " + hook);
        }
    }

    public boolean getSynchronous(Hook hook) {
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.MOUSE)) {
            return this._mouseHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.KEYBOARD)) {
            return this._keyboardHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.CALLWNDPROC)) {
            return this._wndProcHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.CALLWNDPROCRET)) {
            return this._wndProcRetHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.GETMESSAGE)) {
            return this._getMsgHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.SYSMSGFILTER)) {
            return this._sysMsgProcHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.SHELL)) {
            return this._shellHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.FOREGROUNDIDLE)) {
            return this._foregroungIdleHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.JOURNALRECORD)) {
            return this._journalRecordHookData.isSyncronous();
        }
        if (hook.getDescriptor().equals((Object)Hook.Descriptor.CBT)) {
            return this._cbtHookData.isSyncronous();
        }
        throw new IllegalArgumentException("Unknown hook type: " + hook);
    }

    public void setHookFilter(Hook.Descriptor descriptor, EventsFilter filter) {
        if (!descriptor.equals((Object)Hook.Descriptor.CALLWNDPROC)) {
            throw new IllegalArgumentException("Events filtering for hook: " + (Object)((Object)descriptor) + " is not implemented");
        }
        this._wndProcHookData.setFilter(filter);
    }

    public EventsFilter getHookFilter(Hook.Descriptor descriptor) {
        if (descriptor.equals((Object)Hook.Descriptor.CALLWNDPROC)) {
            return this._wndProcHookData.getFilter();
        }
        throw new IllegalArgumentException("Events filtering for hook: " + (Object)((Object)descriptor) + " is not implemented");
    }

    static {
        DESCRIPTOR2READER.put(Hook.Descriptor.MOUSE, new MouseHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.KEYBOARD, new KeyboardHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.CALLWNDPROC, new CallWndProcEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.CALLWNDPROCRET, new CallWndProcRetEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.GETMESSAGE, new GetMsgHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.SYSMSGFILTER, new SysMsgProcHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.SHELL, new ShellHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.FOREGROUNDIDLE, new ForegroungIdleHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.JOURNALRECORD, new JournalRecordHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.CBT, new CBTProcHookEventReader());
    }

    private static class CBTProcHookEventReader
    implements HookEventReader {
        static final int HCBT_MOVESIZE = 0;
        static final int HCBT_MINMAX = 1;
        static final int HCBT_QS = 2;
        static final int HCBT_CREATEWND = 3;
        static final int HCBT_DESTROYWND = 4;
        static final int HCBT_ACTIVATE = 5;
        static final int HCBT_CLICKSKIPPED = 6;
        static final int HCBT_KEYSKIPPED = 7;
        static final int HCBT_SYSCOMMAND = 8;
        static final int HCBT_SETFOCUS = 9;

        private CBTProcHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            CBTEvent result = null;
            CBTProcData cbtHookData = hookData._cbtHookData;
            long wParam = cbtHookData.getWParam();
            long lParam = cbtHookData.getLParam();
            int code = cbtHookData.getCode();
            switch (code) {
                case 5: {
                    CBTACTIVATESTRUCT struct = cbtHookData.getActiveStruct();
                    result = new CBTEvent.Activate(cbtHookData.getEventDescriptor(), cbtHookData.getAllow(), struct.getHWndActive(), new Wnd(wParam), struct.getFMouse().getValue());
                    break;
                }
                case 6: {
                    MouseHookStructure mouseHookStructure = cbtHookData.getMouseHookStruct();
                    result = new CBTEvent.ClickSkipped(cbtHookData.getEventDescriptor(), wParam, mouseHookStructure.getPoint(), mouseHookStructure.getWnd(), mouseHookStructure.getHitTestCode());
                    break;
                }
                case 3: {
                    result = new CBTEvent.CreateWnd(cbtHookData.getEventDescriptor(), cbtHookData.getAllow(), new Wnd(wParam), cbtHookData.getCreatestruct(), cbtHookData.getInsertAfter());
                    break;
                }
                case 4: {
                    result = new CBTEvent.DestroyWnd(cbtHookData.getEventDescriptor(), cbtHookData.getAllow(), new Wnd(wParam));
                    break;
                }
                case 7: {
                    result = new CBTEvent.KeySkipped(cbtHookData.getEventDescriptor(), wParam, lParam);
                    break;
                }
                case 1: {
                    result = new CBTEvent.MinMax(cbtHookData.getEventDescriptor(), cbtHookData.getAllow(), new Wnd(wParam), lParam);
                    break;
                }
                case 0: {
                    Rect rect = cbtHookData.getRect();
                    result = new CBTEvent.MoveSize(cbtHookData.getEventDescriptor(), cbtHookData.getAllow(), new Wnd(wParam), rect);
                    break;
                }
                case 2: {
                    result = new CBTEvent.QS(cbtHookData.getEventDescriptor());
                    break;
                }
                case 9: {
                    result = new CBTEvent.SetFocus(cbtHookData.getEventDescriptor(), cbtHookData.getAllow(), new Wnd(wParam), new Wnd(lParam));
                    break;
                }
                case 8: {
                    result = new CBTEvent.SysCommand(cbtHookData.getEventDescriptor(), cbtHookData.getAllow(), wParam, lParam);
                }
            }
            return result;
        }
    }

    private static class JournalRecordHookEventReader
    implements HookEventReader {
        private JournalRecordHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            JournalRecordHookData jornalRecordHookData = hookData._journalRecordHookData;
            JournalRecordEvent result = null;
            long code = jornalRecordHookData.getCode();
            if (code == 0L) {
                EventMessageStructure eventMessage = jornalRecordHookData.getEventMessage();
                result = new JournalRecordEvent(jornalRecordHookData.getEventDescriptor(), code, eventMessage.getMessage(), eventMessage.getParamL(), eventMessage.getParamH(), eventMessage.getTime(), eventMessage.getHwnd());
            } else {
                result = new JournalRecordEvent(jornalRecordHookData.getEventDescriptor(), code);
            }
            return result;
        }
    }

    private static class ForegroungIdleHookEventReader
    implements HookEventReader {
        private ForegroungIdleHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            ForegroungIdleHookData foregroungIdleHookData = hookData._foregroungIdleHookData;
            ForegroungIdleEvent result = new ForegroungIdleEvent(foregroungIdleHookData.getEventDescriptor());
            return result;
        }
    }

    private static class ShellHookEventReader
    implements HookEventReader {
        private ShellHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            ShellHookData shellHookData = hookData._shellHookData;
            ShellEvent result = new ShellEvent(shellHookData.getEventDescriptor(), shellHookData.getCode(), shellHookData.getWParam(), shellHookData.getLParam());
            return result;
        }
    }

    private static class SysMsgProcHookEventReader
    implements HookEventReader {
        private SysMsgProcHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            SysMsgProcHookData sysMsgProcHookData = hookData._sysMsgProcHookData;
            SysMsgProcEvent result = new SysMsgProcEvent(sysMsgProcHookData.getEventDescriptor(), sysMsgProcHookData.getCode(), sysMsgProcHookData.getMsg());
            return result;
        }
    }

    private static class GetMsgHookEventReader
    implements HookEventReader {
        private static final int PM_REMOVE = 1;

        private GetMsgHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            GetMsgHookData getMsgHookData = hookData._getMsgHookData;
            GetMsgEvent result = new GetMsgEvent(getMsgHookData.getEventDescriptor(), getMsgHookData.getWParam() == 1L, getMsgHookData.getMsg());
            return result;
        }
    }

    private static class CallWndProcRetEventReader
    implements HookEventReader {
        private CallWndProcRetEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            WndProcRetHookData wndProcRetHookData = hookData._wndProcRetHookData;
            CWndProcRetStructure cwpRetStruct = wndProcRetHookData.getCwpRetStruct();
            CallWndProcRetEvent result = new CallWndProcRetEvent(wndProcRetHookData.getEventDescriptor(), cwpRetStruct.getResult(), cwpRetStruct.getLParam(), cwpRetStruct.getWParam(), cwpRetStruct.getMessage(), cwpRetStruct.getWnd(), cwpRetStruct.wParam.getValue() != 0L);
            return result;
        }
    }

    private static class CallWndProcEventReader
    implements HookEventReader {
        private CallWndProcEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            WndProcHookData wndProcHookData = hookData._wndProcHookData;
            CWndProcStructure cwpStruct = wndProcHookData.getCwpStruct();
            CallWndProcEvent result = new CallWndProcEvent(wndProcHookData.getEventDescriptor(), cwpStruct.getLParam(), cwpStruct.getWParam(), cwpStruct.getMessage(), cwpStruct.getWnd(), cwpStruct.wParam.getValue() != 0L);
            return result;
        }
    }

    private static class KeyboardHookEventReader
    implements HookEventReader {
        private KeyboardHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            KeyboardHookData keyboardHookData = hookData._keyboardHookData;
            KeyboardEvent result = new KeyboardEvent(keyboardHookData.getEventDescriptor(), keyboardHookData.getWParam(), keyboardHookData.getLParam());
            return result;
        }
    }

    private static class MouseHookEventReader
    implements HookEventReader {
        private MouseHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            MouseHookData mouseHookData = hookData._mouseHookData;
            MouseHookStructure mouseHookStruct = mouseHookData.getMouseHookStruct();
            MouseEvent result = new MouseEvent(mouseHookData.getEventDescriptor(), mouseHookData.getWParam(), mouseHookStruct.getPoint(), mouseHookStruct.getWnd(), mouseHookStruct.getHitTestCode(), mouseHookStruct.getExtraInfo());
            return result;
        }
    }

    private static interface HookEventReader {
        public HookEventObject readEvent(HooksData var1);
    }
}

