/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.win32.hook.Hook;
import com.jniwrapper.win32.hook.HookEventListener;
import com.jniwrapper.win32.hook.HookEventObject;
import com.jniwrapper.win32.hook.IdleTrackerListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;

public class IdleTracker {
    private long _idleDelay;
    private List _listeners = new ArrayList();
    private Hook _mouseHook = Hook.MOUSE;
    private Hook _keyboardHook = Hook.KEYBOARD;
    private Timer _timer;

    public IdleTracker() {
        this(60000L);
    }

    public IdleTracker(long idleDelay) {
        this._idleDelay = idleDelay;
        this._mouseHook.addListener(new HookEventListener(){

            public void onHookEvent(HookEventObject event) {
                IdleTracker.this._timer.restart();
            }
        });
        this._keyboardHook.addListener(new HookEventListener(){

            public void onHookEvent(HookEventObject event) {
                IdleTracker.this._timer.restart();
            }
        });
        this._timer = new Timer((int)this._idleDelay, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Iterator i = IdleTracker.this._listeners.iterator();
                while (i.hasNext()) {
                    IdleTrackerListener listener = (IdleTrackerListener)i.next();
                    listener.timeoutElapsed();
                }
            }
        });
    }

    public void start() {
        if (!this._mouseHook.isInstalled()) {
            this._mouseHook.install();
        }
        if (!this._keyboardHook.isInstalled()) {
            this._keyboardHook.install();
        }
        this._timer.start();
    }

    public void stop() {
        if (this._mouseHook.isInstalled()) {
            this._mouseHook.uninstall();
        }
        if (this._keyboardHook.isInstalled()) {
            this._keyboardHook.uninstall();
        }
        this._timer.stop();
    }

    public void addListener(IdleTrackerListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(IdleTrackerListener listener) {
        this._listeners.remove(listener);
    }
}

