/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;

public class RectanglePainter
extends AbstractPainter {
    private Paint fillPaint = Color.RED;
    private Paint borderPaint = Color.BLACK;
    private boolean rounded = false;
    private Insets insets = new Insets(5, 5, 5, 5);
    private int roundWidth = 20;
    private int roundHeight = 20;
    private double strokeWidth = 1.0;

    public RectanglePainter() {
    }

    public RectanglePainter(int top, int left, int bottom, int right, int roundWidth, int roundHeight, boolean rounded, Paint fillPaint, double strokeWidth, Paint borderPaint) {
        this();
        this.insets = new Insets(top, left, bottom, right);
        this.roundWidth = roundWidth;
        this.roundHeight = roundHeight;
        this.rounded = rounded;
        this.fillPaint = fillPaint;
        this.strokeWidth = strokeWidth;
        this.borderPaint = borderPaint;
    }

    protected Shape calculateShape(JComponent component) {
        RectangularShape shape = new Rectangle2D.Double(this.insets.left, this.insets.top, component.getWidth() - this.insets.left - this.insets.right, component.getHeight() - this.insets.top - this.insets.bottom);
        if (this.rounded) {
            shape = new RoundRectangle2D.Double(this.insets.left, this.insets.top, component.getWidth() - this.insets.left - this.insets.right, component.getHeight() - this.insets.top - this.insets.bottom, this.roundWidth, this.roundHeight);
        }
        return shape;
    }

    protected void paintBackground(Graphics2D g, JComponent component) {
        Shape shape = this.calculateShape(component);
        g.setPaint(this.fillPaint);
        g.fill(shape);
        g.setPaint(this.borderPaint);
        g.setStroke(new BasicStroke((float)this.strokeWidth));
        g.draw(shape);
        g.setClip(shape);
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        Paint oldFillPaint = this.getFillPaint();
        this.fillPaint = fillPaint;
        this.firePropertyChange("fillPaint", oldFillPaint, fillPaint);
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        Paint oldBorderPaint = this.getBorderPaint();
        this.borderPaint = borderPaint;
        this.firePropertyChange("fillPaint", oldBorderPaint, borderPaint);
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public void setRounded(boolean rounded) {
        boolean oldRounded = this.isRounded();
        this.rounded = rounded;
        this.firePropertyChange("rounded", oldRounded, rounded);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        Insets oldInsets = this.getInsets();
        this.insets = insets;
        this.firePropertyChange("insets", oldInsets, insets);
    }

    public int getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(int roundWidth) {
        int oldRoundWidth = this.getRoundWidth();
        this.roundWidth = roundWidth;
        this.firePropertyChange("roundWidth", oldRoundWidth, roundWidth);
    }

    public int getRoundHeight() {
        return this.roundHeight;
    }

    public void setRoundHeight(int roundHeight) {
        int oldRoundHeight = this.getRoundHeight();
        this.roundHeight = roundHeight;
        this.firePropertyChange("roundHeight", oldRoundHeight, roundHeight);
    }

    public double getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(double strokeWidth) {
        double oldStrokeWidth = this.getStrokeWidth();
        this.strokeWidth = strokeWidth;
        this.firePropertyChange("strokeWidth", oldStrokeWidth, strokeWidth);
    }
}

