/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.ImagePainter;

public class IconPainter
extends ImagePainter {
    private Icon icon;

    public IconPainter() {
    }

    public IconPainter(Icon icon) {
        this.icon = icon;
    }

    public void setIcon(Icon icon) {
        Icon old = this.getIcon();
        Image oldImage = this.getImage();
        this.icon = icon;
        this.firePropertyChange("icon", old, this.getIcon());
        this.firePropertyChange("image", oldImage, this.getImage());
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Image getImage() {
        if (this.icon instanceof ImageIcon) {
            return ((ImageIcon)this.icon).getImage();
        }
        if (this.icon == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        this.icon.paintIcon(new JComponent(){}, g2, 0, 0);
        g2.dispose();
        return image;
    }
}

