/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class ShadowRenderer {
    public static final String SIZE_CHANGED_PROPERTY = "shadow_size";
    public static final String OPACITY_CHANGED_PROPERTY = "shadow_opacity";
    public static final String COLOR_CHANGED_PROPERTY = "shadow_color";
    private int size = 5;
    private float opacity = 0.5f;
    private Color color = Color.BLACK;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public ShadowRenderer() {
        this(5, 0.5f, Color.BLACK);
    }

    public ShadowRenderer(int size, float opacity, Color color) {
        this.setSize(size);
        this.setOpacity(opacity);
        this.setColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color shadowColor) {
        if (shadowColor != null) {
            Color oldColor = this.color;
            this.color = shadowColor;
            this.changeSupport.firePropertyChange(COLOR_CHANGED_PROPERTY, oldColor, this.color);
        }
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float shadowOpacity) {
        float oldOpacity = this.opacity;
        this.opacity = (double)shadowOpacity < 0.0 ? 0.0f : (shadowOpacity > 1.0f ? 1.0f : shadowOpacity);
        this.changeSupport.firePropertyChange(OPACITY_CHANGED_PROPERTY, Float.valueOf(oldOpacity), Float.valueOf(this.opacity));
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int shadowSize) {
        int oldSize = this.size;
        this.size = shadowSize < 0 ? 0 : shadowSize;
        this.changeSupport.firePropertyChange(SIZE_CHANGED_PROPERTY, new Integer(oldSize), new Integer(this.size));
    }

    public BufferedImage createShadow(BufferedImage image) {
        BufferedImage dst = GraphicsUtilities.createCompatibleImage(image);
        float shadowOpacity = this.opacity;
        if (shadowOpacity <= 0.0f) {
            return dst;
        }
        int shadowColor = this.color.getRGB();
        int shadowSize = this.size;
        int width = image.getWidth();
        int height = image.getHeight();
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        GraphicsUtilities.getPixels(image, 0, 0, width, height, srcPixels);
        ShadowRenderer.alphaBlur(srcPixels, dstPixels, width, height, shadowSize, shadowColor, 1.0f);
        ShadowRenderer.alphaBlur(dstPixels, srcPixels, height, width, shadowSize, shadowColor, shadowOpacity);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, srcPixels);
        return dst;
    }

    private static void alphaBlur(int[] srcPixels, int[] dstPixels, int width, int height, int radius, int color, float opacity) {
        int i;
        int windowSize = radius * 2 + 1;
        int radiusPlusOne = radius + 1;
        color &= 0xFFFFFF;
        int srcIndex = 0;
        int[] sumLookupTable = new int[256 * windowSize];
        for (int i2 = 0; i2 < sumLookupTable.length; ++i2) {
            sumLookupTable[i2] = i2 / windowSize;
        }
        int[] indexLookupTable = new int[radiusPlusOne];
        if (radius < width) {
            for (i = 0; i < indexLookupTable.length; ++i) {
                indexLookupTable[i] = i;
            }
        } else {
            for (i = 0; i < width; ++i) {
                indexLookupTable[i] = i;
            }
            for (i = width; i < indexLookupTable.length; ++i) {
                indexLookupTable[i] = width - 1;
            }
        }
        for (int y = 0; y < height; ++y) {
            int sumAlpha = 0;
            int dstIndex = y;
            int pixel = srcPixels[srcIndex];
            sumAlpha += (radius + 1) * (pixel >> 24 & 0xFF);
            for (int i3 = 1; i3 <= radius; ++i3) {
                pixel = srcPixels[srcIndex + indexLookupTable[i3]];
                sumAlpha += pixel >> 24 & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int previousPixelIndex;
                dstPixels[dstIndex] = (int)((float)sumLookupTable[sumAlpha] * opacity) << 24 | color;
                dstIndex += height;
                int nextPixelIndex = x + radiusPlusOne;
                if (nextPixelIndex >= width) {
                    nextPixelIndex = width - 1;
                }
                if ((previousPixelIndex = x - radius) < 0) {
                    previousPixelIndex = 0;
                }
                int nextPixel = srcPixels[srcIndex + nextPixelIndex];
                int previousPixel = srcPixels[srcIndex + previousPixelIndex];
                sumAlpha += nextPixel >> 24 & 0xFF;
                sumAlpha -= previousPixel >> 24 & 0xFF;
            }
            srcIndex += width;
        }
    }
}

