/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.AbstractSearchable;
import org.jdesktop.swingx.RolloverController;
import org.jdesktop.swingx.RolloverProducer;
import org.jdesktop.swingx.RolloverRenderer;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.tree.DefaultXTreeCellEditor;

public class JXTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(JXTree.class.getName());
    private Method conversionMethod = null;
    private static final Class[] methodSignature = new Class[]{Object.class};
    private static final Object[] methodArgs = new Object[]{null};
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    protected FilterPipeline filters;
    protected HighlighterPipeline highlighters;
    private ChangeListener highlighterChangeListener;
    private DelegatingRenderer delegatingRenderer;
    private RolloverProducer rolloverProducer;
    private TreeRolloverController linkController;
    private boolean overwriteIcons;
    private Searchable searchable;
    private CellEditorRemover editorRemover;
    private final ComponentAdapter dataAdapter = new TreeAdapter(this);

    public JXTree() {
        this.init();
    }

    public JXTree(Object[] value) {
        super(value);
        this.init();
    }

    public JXTree(Vector value) {
        super(value);
        this.init();
    }

    public JXTree(Hashtable value) {
        super(value);
        this.init();
    }

    public JXTree(TreeNode root) {
        super(root, false);
        this.init();
    }

    public JXTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public JXTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    public void setModel(TreeModel newModel) {
        this.conversionMethod = this.getValueConversionMethod(newModel);
        super.setModel(newModel);
    }

    protected Method getValueConversionMethod(TreeModel model) {
        try {
            return model == null ? null : model.getClass().getMethod("convertValueToText", methodSignature);
        }
        catch (NoSuchMethodException ex) {
            LOG.finer("ex " + ex);
            LOG.finer("no conversionMethod in " + model.getClass());
            return null;
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            if (this.conversionMethod == null) {
                return value.toString();
            }
            try {
                JXTree.methodArgs[0] = value;
                return (String)this.conversionMethod.invoke((Object)this.getModel(), methodArgs);
            }
            catch (Exception ex) {
                LOG.finer("ex " + ex);
                LOG.finer("can't invoke " + this.conversionMethod);
            }
        }
        return "";
    }

    private void init() {
        TreeCellRenderer delegate;
        this.conversionMethod = this.getValueConversionMethod(this.getModel());
        TreeCellRenderer xRenderer = this.getCellRenderer();
        if (xRenderer instanceof DelegatingRenderer && (delegate = ((DelegatingRenderer)xRenderer).getDelegateRenderer()) instanceof DefaultTreeCellRenderer) {
            this.setCellEditor(new DefaultXTreeCellEditor(this, (DefaultTreeCellRenderer)delegate));
        }
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
        map.put("find", this.createFindAction());
        KeyStroke findStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(findStroke, "find");
    }

    private Action createFindAction() {
        UIAction findAction = new UIAction("find"){

            public void actionPerformed(ActionEvent e) {
                JXTree.this.doFind();
            }
        };
        return findAction;
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TreeSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public void expandAll() {
        if (this.getRowCount() == 0) {
            this.expandRoot();
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    private void expandRoot() {
        TreeModel model = this.getModel();
        if (model != null && model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
    }

    public int[] getSelectionRows() {
        int[] rows = super.getSelectionRows();
        return rows != null ? rows : EMPTY_INT_ARRAY;
    }

    public TreePath[] getSelectionPaths() {
        TreePath[] paths = super.getSelectionPaths();
        return paths != null ? paths : EMPTY_TREEPATH_ARRAY;
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline pipeline) {
        HighlighterPipeline old = this.getHighlighters();
        if (old != null) {
            old.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters = pipeline;
        if (this.highlighters != null) {
            this.highlighters.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JXTree.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    protected TreeRolloverController getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected TreeRolloverController createLinkController() {
        return new TreeRolloverController();
    }

    protected RolloverProducer createRolloverProducer() {
        RolloverProducer r = new RolloverProducer(){

            public void mousePressed(MouseEvent e) {
                JXTree tree = (JXTree)e.getComponent();
                Point mousePoint = e.getPoint();
                int labelRow = tree.getRowForLocation(mousePoint.x, mousePoint.y);
                if (labelRow >= 0) {
                    return;
                }
                int row = tree.getClosestRowForLocation(mousePoint.x, mousePoint.y);
                Rectangle bounds = tree.getRowBounds(row);
                if (bounds == null) {
                    row = -1;
                } else if (bounds.y + bounds.height < mousePoint.y || bounds.x > mousePoint.x) {
                    row = -1;
                }
                if (row < 0) {
                    return;
                }
                tree.dispatchEvent(new MouseEvent(tree, e.getID(), e.getWhen(), e.getModifiers(), bounds.x + bounds.width - 2, mousePoint.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            }

            protected void updateRolloverPoint(JComponent component, Point mousePoint) {
                int col;
                JXTree tree = (JXTree)component;
                int row = tree.getClosestRowForLocation(mousePoint.x, mousePoint.y);
                Rectangle bounds = tree.getRowBounds(row);
                if (bounds == null) {
                    row = -1;
                } else if (bounds.y + bounds.height < mousePoint.y || bounds.x > mousePoint.x) {
                    row = -1;
                }
                this.rollover.x = col = row < 0 ? -1 : 0;
                this.rollover.y = row;
            }
        };
        return r;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
            this.delegatingRenderer.setDelegateRenderer(super.getCellRenderer());
        }
        return this.delegatingRenderer;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    public void setExpandedIcon(Icon expanded) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setExpandedIcon(expanded);
        }
    }

    public void setCollapsedIcon(Icon collapsed) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setCollapsedIcon(collapsed);
        }
    }

    public void setLeafIcon(Icon leafIcon) {
        this.getDelegatingRenderer().setLeafIcon(leafIcon);
    }

    public void setOpenIcon(Icon openIcon) {
        this.getDelegatingRenderer().setOpenIcon(openIcon);
    }

    public void setClosedIcon(Icon closedIcon) {
        this.getDelegatingRenderer().setClosedIcon(closedIcon);
    }

    public void setOverwriteRendererIcons(boolean overwrite) {
        if (this.overwriteIcons == overwrite) {
            return;
        }
        boolean old = this.overwriteIcons;
        this.overwriteIcons = overwrite;
        this.firePropertyChange("overwriteRendererIcons", old, overwrite);
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    public void startEditingAtPath(TreePath path) {
        super.startEditingAtPath(path);
        if (this.isEditing()) {
            this.updateEditorRemover();
        }
    }

    public void removeNotify() {
        if (this.editorRemover != null) {
            this.editorRemover.release();
            this.editorRemover = null;
        }
        super.removeNotify();
    }

    private void updateEditorRemover() {
        if (this.editorRemover == null) {
            this.editorRemover = new CellEditorRemover();
        }
        this.editorRemover.updateKeyboardFocusManager();
    }

    protected ComponentAdapter getComponentAdapter() {
        return this.dataAdapter;
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        public TreeAdapter(JXTree component) {
            super(component);
            this.tree = component;
        }

        public JXTree getTree() {
            return this.tree;
        }

        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        public Object getValueAt(int row, int column) {
            TreePath path = this.tree.getPathForRow(row);
            return path.getLastPathComponent();
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.getValueAt(row, column);
        }

        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
        }

        public String getColumnName(int columnIndex) {
            return "Column_" + columnIndex;
        }

        public String getColumnIdentifier(int columnIndex) {
            return null;
        }
    }

    public class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover() {
            this.updateKeyboardFocusManager();
        }

        public void updateKeyboardFocusManager() {
            KeyboardFocusManager current = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.setKeyboardFocusManager(current);
        }

        public void release() {
            this.setKeyboardFocusManager(null);
        }

        private void setKeyboardFocusManager(KeyboardFocusManager current) {
            if (this.focusManager == current) {
                return;
            }
            KeyboardFocusManager old = this.focusManager;
            if (old != null) {
                old.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = current;
            if (this.focusManager != null) {
                this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!JXTree.this.isEditing()) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                JXTree tree = JXTree.this;
                if (c == tree) {
                    return;
                }
                if (!(c instanceof Window) && (!(c instanceof Applet) || c.getParent() != null)) continue;
                if (c != SwingUtilities.getRoot(tree)) break;
                if (tree.getInvokesStopCellEditing()) {
                    tree.stopEditing();
                }
                if (!tree.isEditing()) break;
                tree.cancelEditing();
                break;
            }
        }
    }

    public class DelegatingRenderer
    implements TreeCellRenderer,
    RolloverRenderer {
        private Icon closedIcon = null;
        private Icon openIcon = null;
        private Icon leafIcon = null;
        private TreeCellRenderer delegate;

        public DelegatingRenderer() {
            this.initIcons(new DefaultTreeCellRenderer());
        }

        private void initIcons(DefaultTreeCellRenderer renderer) {
            this.closedIcon = renderer.getDefaultClosedIcon();
            this.openIcon = renderer.getDefaultOpenIcon();
            this.leafIcon = renderer.getDefaultLeafIcon();
        }

        public void setDelegateRenderer(TreeCellRenderer delegate) {
            if (delegate == null) {
                delegate = new DefaultTreeCellRenderer();
            }
            this.delegate = delegate;
            this.updateIcons();
        }

        private void updateIcons() {
            if (!JXTree.this.isOverwriteRendererIcons()) {
                return;
            }
            this.setClosedIcon(this.closedIcon);
            this.setOpenIcon(this.openIcon);
            this.setLeafIcon(this.leafIcon);
        }

        public void setClosedIcon(Icon closedIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setClosedIcon(closedIcon);
            }
            this.closedIcon = closedIcon;
        }

        public void setOpenIcon(Icon openIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setOpenIcon(openIcon);
            }
            this.openIcon = openIcon;
        }

        public void setLeafIcon(Icon leafIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setLeafIcon(leafIcon);
            }
            this.leafIcon = leafIcon;
        }

        public TreeCellRenderer getDelegateRenderer() {
            return this.delegate;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component result = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (JXTree.this.highlighters != null) {
                JXTree.this.getComponentAdapter().row = row;
                result = JXTree.this.highlighters.apply(result, JXTree.this.getComponentAdapter());
            }
            return result;
        }

        public boolean isEnabled() {
            return this.delegate instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegate)).isEnabled();
        }

        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegate)).doClick();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TreeRolloverController<T extends JTree>
    extends RolloverController<T> {
        private Cursor oldCursor;

        @Override
        protected void rollover(Point oldLocation, Point newLocation) {
            this.setRolloverCursor(newLocation);
            ((JTree)this.component).repaint();
        }

        private void setRolloverCursor(Point location) {
            if (this.hasRollover(location)) {
                if (this.oldCursor == null) {
                    this.oldCursor = ((JTree)this.component).getCursor();
                    ((JTree)this.component).setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (this.oldCursor != null) {
                ((JTree)this.component).setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }

        @Override
        protected RolloverRenderer getRolloverRenderer(Point location, boolean prepare) {
            RolloverRenderer rollover;
            TreeCellRenderer renderer = ((JTree)this.component).getCellRenderer();
            RolloverRenderer rolloverRenderer = rollover = renderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)renderer) : null;
            if (rollover != null && !rollover.isEnabled()) {
                rollover = null;
            }
            if (rollover != null && prepare) {
                TreePath path = ((JTree)this.component).getPathForRow(location.y);
                Object element = path != null ? path.getLastPathComponent() : null;
                renderer.getTreeCellRendererComponent((JTree)this.component, element, false, false, false, location.y, false);
            }
            return rollover;
        }

        @Override
        protected Point getFocusedCell() {
            return null;
        }
    }

    public class TreeSearchable
    extends AbstractSearchable {
        protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
            AbstractSearchable.SearchResult searchResult = null;
            if (backwards) {
                for (int index = startRow; index >= 0 && searchResult == null; --index) {
                    searchResult = this.findMatchAt(pattern, index);
                }
            } else {
                for (int index = startRow; index < this.getSize() && searchResult == null; ++index) {
                    searchResult = this.findMatchAt(pattern, index);
                }
            }
            this.updateState(searchResult);
        }

        protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
            return this.findMatchAt(pattern, row);
        }

        protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row) {
            Matcher matcher;
            TreePath path = JXTree.this.getPathForRow(row);
            Object value = null;
            if (path != null) {
                value = path.getLastPathComponent();
            }
            if (value != null && (matcher = pattern.matcher(value.toString())).find()) {
                return this.createSearchResult(matcher, row, -1);
            }
            return null;
        }

        protected int getSize() {
            return JXTree.this.getRowCount();
        }

        protected void moveMatchMarker() {
            int row = this.lastSearchResult.foundRow;
            JXTree.this.setSelectionRow(row);
            if (row >= 0) {
                JXTree.this.scrollRowToVisible(row);
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JXTree.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTree.this.collapseAll();
            }
        }
    }
}

