/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.StringScriptPreProcessor;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;

public class IEConditionalCompilationScriptPreProcessor
implements ScriptPreProcessor {
    private static final String CC_VARIABLE_PREFIX = "htmlunit_cc_variable_";
    private final Set<String> setVariables_ = new HashSet<String>();

    public String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, HtmlElement htmlElement) {
        int startPos = StringScriptPreProcessor.indexOf(sourceCode, "/*@cc_on", 0);
        if (startPos == -1) {
            return sourceCode;
        }
        int endPos = StringScriptPreProcessor.indexOf(sourceCode, "@*/", startPos);
        if (endPos == -1) {
            return sourceCode;
        }
        StringBuilder sb = new StringBuilder();
        if (startPos > 0) {
            sb.append(sourceCode.substring(0, startPos));
        }
        BrowserVersion browserVersion = htmlPage.getWebClient().getBrowserVersion();
        String body = sourceCode.substring(startPos + 8, endPos);
        sb.append(this.processConditionalCompilation(body, browserVersion));
        if (endPos < sourceCode.length() - 3) {
            String remaining = sourceCode.substring(endPos + 3);
            int nextStart = remaining.indexOf("/*@");
            int nextEnd = remaining.indexOf("@*/", nextStart + 3);
            while (nextStart >= 0 && nextEnd > 0) {
                sb.append(remaining.substring(0, nextStart));
                String nextBody = remaining.substring(nextStart + 3, nextEnd);
                sb.append(this.processConditionalCompilation(nextBody, browserVersion));
                remaining = remaining.substring(nextEnd + 3);
                nextStart = remaining.indexOf("/*@");
                nextEnd = remaining.indexOf("@*/", nextStart + 3);
            }
            sb.append(remaining);
        }
        return sb.toString();
    }

    private String processConditionalCompilation(String precompilationBody, BrowserVersion browserVersion) {
        String body = precompilationBody;
        if (body.startsWith("cc_on")) {
            body = body.substring(5);
        }
        body = body.replaceAll("/\\*@end", "");
        body = IEConditionalCompilationScriptPreProcessor.processIfs(body);
        body = this.replaceCompilationVariables(body, browserVersion);
        body = this.processSet(body);
        body = this.replaceCustomCompilationVariables(body);
        return body;
    }

    private String replaceCustomCompilationVariables(String body) {
        Pattern p = Pattern.compile("@\\w+|'[^']*'|\"[^\"]*\"");
        Matcher m = p.matcher(body);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            if (match.startsWith("@")) {
                m.appendReplacement(sb, this.replaceOneCustomCompilationVariable(match));
                continue;
            }
            m.appendReplacement(sb, match);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String replaceOneCustomCompilationVariable(String variable) {
        if (this.setVariables_.contains(variable)) {
            return CC_VARIABLE_PREFIX + variable.substring(1);
        }
        return "NaN";
    }

    private String processSet(String body) {
        Pattern p = Pattern.compile("@set\\s+(@\\w+)(\\s*=\\s*[\\d\\.]+)");
        Matcher m = p.matcher(body);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            this.setVariables_.add(m.group(1));
            m.appendReplacement(sb, CC_VARIABLE_PREFIX + m.group(1).substring(1) + m.group(2) + ";");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String processIfs(String code) {
        code = code.replaceAll("@if\\s*\\(([^\\)]+)\\)", "if ($1) {");
        code = code.replaceAll("@elif\\s*\\(([^\\)]+)\\)", "} else if ($1) {");
        code = code.replaceAll("@else", "} else {");
        code = code.replaceAll("@end", "}");
        return code;
    }

    String replaceCompilationVariables(String source, BrowserVersion browserVersion) {
        Pattern p = Pattern.compile("(@_\\w+)|'[^']*'|\"[^\"]*\"");
        Matcher m = p.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            if (match.startsWith("@")) {
                m.appendReplacement(sb, IEConditionalCompilationScriptPreProcessor.replaceOneVariable(match, browserVersion));
                continue;
            }
            m.appendReplacement(sb, match);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String replaceOneVariable(String variable, BrowserVersion browserVersion) {
        Object[] varNaN = new String[]{"@_win16", "@_mac", "@_alpha", "@_mc680x0", "@_PowerPC", "@_debug", "@_fast"};
        Object[] varTrue = new String[]{"@_win32", "@_x86", "@_jscript"};
        if (ArrayUtils.contains((Object[])varTrue, (Object)variable)) {
            return "true";
        }
        if ("@_jscript_version".equals(variable)) {
            if (browserVersion.getBrowserVersionNumeric() <= 6.0f) {
                return "5.6";
            }
            if (browserVersion.getBrowserVersionNumeric() == 7.0f) {
                return "5.7";
            }
            return "5.8";
        }
        if ("@_jscript_build".equals(variable)) {
            if (browserVersion.getBrowserVersionNumeric() <= 6.0f) {
                return "6626";
            }
            if (browserVersion.getBrowserVersionNumeric() == 7.0f) {
                return "5730";
            }
            return "18702";
        }
        if (ArrayUtils.contains((Object[])varNaN, (Object)variable)) {
            return "NaN";
        }
        return variable;
    }
}

