/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit.events;

import com.jniwrapper.Pointer;
import com.teamdev.jxbrowser.webkit.DialogAction;
import com.teamdev.jxbrowser.webkit.Safari;
import com.teamdev.jxbrowser.webkit.WebBrowserFactory;
import com.teamdev.jxbrowser.webkit.cocoa.nsstring.NSString;
import com.teamdev.jxbrowser.webkit.cocoa.nsurlrequest.NSURLRequest;
import com.teamdev.jxbrowser.webkit.events.DialogResult;
import com.teamdev.jxbrowser.webkit.events.Events;
import com.teamdev.jxbrowser.webkit.webkit.WebFrame;
import com.teamdev.jxbrowser.webkit.webkit.WebView;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIEvents
extends Events {
    private static final Logger LOG = LoggerFactory.getLogger(UIEvents.class);

    public long createWebViewWithRequest(long l, long l2) {
        LOG.info("Create WebView");
        WebBrowserFactory webBrowserFactory = new WebBrowserFactory();
        Safari safari = new Safari();
        safari.setDialogCreator(webBrowserFactory.getDefaultDialogCreator());
        safari.setWindowCreator(webBrowserFactory.getDefaultWindowCreator());
        this.showWindow(safari);
        long l3 = safari.getNativePeer();
        if (l2 != 0L) {
            NSURLRequest nSURLRequest = new NSURLRequest(new Pointer.Void(l2));
            WebView webView = new WebView(new Pointer.Void(l3));
            WebFrame webFrame = new WebFrame(webView.mainFrame());
            webFrame.loadRequest(nSURLRequest);
        }
        return l3;
    }

    public boolean canShowContextMenu() {
        LOG.info("canShowContextMenu");
        return super.canShowContextMenu();
    }

    public void makeFirstResponder() {
        LOG.info("makeFirstResponder");
        this.requestFocusInWindow();
    }

    public void showFrame() {
        LOG.info("showFrame");
        this.showWebView();
    }

    public void webViewClose() {
        LOG.info("webViewClose");
        this.disposeWebView();
    }

    public void setFrame(long l, final float f, final float f2, final float f3, final float f4, final float f5, final float f6) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                boolean bl;
                Rectangle rectangle = new Rectangle((int)f, (int)f2, (int)f3, (int)f4);
                boolean bl2 = bl = rectangle.y < 0;
                if (!rectangle.isEmpty()) {
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = rectangle.x;
                    int n2 = dimension.height - rectangle.y - rectangle.height;
                    int n3 = rectangle.width + (int)f5;
                    int n4 = rectangle.height + (int)f6;
                    rectangle = new Rectangle(n, n2, n3, n4);
                }
                LOG.info("SetFrame: bounds = " + rectangle);
                UIEvents.this.updateWebViewSize(rectangle, bl);
            }
        });
    }

    public void alertMessage(long l, long l2, long l3) {
        LOG.info("alertMessage");
        try {
            NSString nSString = new NSString(new Pointer.Void(l2));
            this.showAlert(nSString.UTF8String().toString());
        }
        catch (Exception exception) {
            LOG.error("Cannot show alert dialog", (Throwable)exception);
        }
    }

    public void confirmMessage(long l, long l2, long l3) {
        LOG.info("confirmMessage");
        try {
            NSString nSString = new NSString(new Pointer.Void(l2));
            this.showConfirmation(nSString.UTF8String().toString());
        }
        catch (Exception exception) {
            LOG.error("Cannot show confirmation dialog", (Throwable)exception);
        }
    }

    public void inputMessage(long l, long l2, long l3, long l4) {
        LOG.info("inputMessage");
        try {
            NSString nSString = new NSString(new Pointer.Void(l2));
            NSString nSString2 = new NSString(new Pointer.Void(l3));
            String string = nSString.UTF8String().toString();
            String string2 = nSString2.UTF8String().toString();
            this.showPrompt(string, string2);
        }
        catch (Exception exception) {
            LOG.error("Cannot show prompt dialog", (Throwable)exception);
        }
    }

    public void setStatusText(long l, long l2) {
        NSString nSString = new NSString(new Pointer.Void(l2));
        String string = nSString.UTF8String().toString();
        this.fireStatusChanged(string);
    }

    public boolean didConfirmationClose() {
        LOG.info("didConfirmationClose");
        DialogResult dialogResult = this.getLastDialogResult();
        return dialogResult.getAction() == DialogAction.OK;
    }

    public long didInputClose() {
        LOG.info("didInputClose");
        DialogResult dialogResult = this.getLastDialogResult();
        String string = dialogResult.getValue() == null ? "" : dialogResult.getValue();
        return new NSString(string).getValue();
    }
}

