/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit.cocoa;

import com.apple.eawt.CocoaComponent;
import com.jniwrapper.Function;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class AwtMacMessageLoop {
    private final JWindow frame = new JWindow();
    private final MessageLoopView view = new MessageLoopView();

    public AwtMacMessageLoop() {
        this.frame.getContentPane().add((Component)((Object)this.view));
        this.frame.setVisible(true);
    }

    public void invokeLater(Runnable runnable) {
        if (!this.view.isDisplayable()) {
            throw new IllegalStateException("Message loop is already disposed");
        }
        this.view.invokeInAppKitThreadLater(runnable);
    }

    public void invokeAndWait(Runnable runnable) {
        if (!this.view.isDisplayable()) {
            throw new IllegalStateException("Message loop is already disposed");
        }
        this.view.invokeInAppKitThreadAndWait(runnable);
    }

    public boolean isEventDispatchThread() {
        if (!this.view.isDisplayable()) {
            throw new IllegalStateException("Message loop is already disposed");
        }
        return this.view.isEventDispatchThread();
    }

    public void dispose() {
        if (this.frame.isDisplayable()) {
            this.frame.getContentPane().remove((Component)((Object)this.view));
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    public boolean isDisposed() {
        return !this.frame.isDisplayable();
    }

    protected static class MessageLoopView
    extends CocoaComponent {
        public static final int SET_OWNER = 1;
        public static final int PERFORM_CALLBACK = 2;
        private final Function function;
        private final Pointer.Void viewHandle = new Pointer.Void();

        private MessageLoopView() {
            Library library = new Library("jniw");
            this.function = library.getFunction("createMessageLoopView");
        }

        @Deprecated
        public int createNSView() {
            return (int)this.createNSViewLong();
        }

        public long createNSViewLong() {
            this.function.invoke((Parameter)this.viewHandle);
            return this.viewHandle.getValue();
        }

        protected void callback(Runnable runnable) {
            if (runnable != null) {
                runnable.run();
            }
        }

        private boolean isInitilized() {
            return SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && !this.viewHandle.isNull();
        }

        public void addNotify() {
            super.addNotify();
            this.sendMessage(1, (Object)this);
        }

        public void invokeInAppKitThreadLater(Runnable runnable) {
            if (!this.isInitilized()) {
                throw new IllegalStateException("CocoaComponent should be added to window hierarchy to send events.");
            }
            this.sendMessage(2, runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeInAppKitThreadAndWait(final Runnable runnable) {
            if (this.isEventDispatchThread()) {
                runnable.run();
                return;
            }
            final boolean[] blArray = new boolean[]{false};
            final Object object = new Object();
            Runnable runnable2 = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object2 = object;
                    synchronized (object2) {
                        runnable.run();
                        blArray[0] = true;
                        object.notify();
                    }
                }
            };
            Object object2 = object;
            synchronized (object2) {
                this.invokeInAppKitThreadLater(runnable2);
                while (!blArray[0]) {
                    try {
                        object.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                }
            }
        }

        public Dimension getMaximumSize() {
            return new Dimension(0, 0);
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 0);
        }

        public boolean isEventDispatchThread() {
            return Thread.currentThread().getName().equals("AWT-AppKit");
        }
    }
}

