/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.util.ResourceBundle;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;

public class RUndoManager
extends UndoManager {
    private RCompoundEdit compoundEdit;
    private RTextArea textArea;
    private int lastOffset;
    private String cantUndoText;
    private String cantRedoText;
    private int internalAtomicEditDepth;
    private static final String MSG = "org.fife.ui.rtextarea.RTextArea";

    public RUndoManager(RTextArea rTextArea) {
        this.textArea = rTextArea;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MSG);
        this.cantUndoText = resourceBundle.getString("Action.CantUndo.Name");
        this.cantRedoText = resourceBundle.getString("Action.CantRedo.Name");
    }

    public void beginInternalAtomicEdit() {
        if (++this.internalAtomicEditDepth == 1) {
            if (this.compoundEdit != null) {
                this.compoundEdit.end();
            }
            this.compoundEdit = new RCompoundEdit();
        }
    }

    public void endInternalAtomicEdit() {
        if (this.internalAtomicEditDepth > 0 && --this.internalAtomicEditDepth == 0) {
            this.addEdit(this.compoundEdit);
            this.compoundEdit.end();
            this.compoundEdit = null;
            this.updateActions();
        }
    }

    public String getCantRedoText() {
        return this.cantRedoText;
    }

    public String getCantUndoText() {
        return this.cantUndoText;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.updateActions();
    }

    private RCompoundEdit startCompoundEdit(UndoableEdit undoableEdit) {
        this.lastOffset = this.textArea.getCaretPosition();
        this.compoundEdit = new RCompoundEdit();
        this.compoundEdit.addEdit(undoableEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.updateActions();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
            this.updateActions();
            return;
        }
        if (this.internalAtomicEditDepth > 0) {
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            return;
        }
        int n = this.textArea.getCaretPosition() - this.lastOffset;
        if (Math.abs(n) <= 1) {
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            this.lastOffset += n;
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
    }

    public void updateActions() {
        String string;
        RecordableTextAction recordableTextAction = RTextArea.getAction(6);
        if (this.canUndo()) {
            recordableTextAction.setEnabled(true);
            string = this.getUndoPresentationName();
            recordableTextAction.putValue("Name", string);
            recordableTextAction.putValue("ShortDescription", string);
        } else if (recordableTextAction.isEnabled()) {
            recordableTextAction.setEnabled(false);
            string = this.cantUndoText;
            recordableTextAction.putValue("Name", string);
            recordableTextAction.putValue("ShortDescription", string);
        }
        recordableTextAction = RTextArea.getAction(4);
        if (this.canRedo()) {
            recordableTextAction.setEnabled(true);
            string = this.getRedoPresentationName();
            recordableTextAction.putValue("Name", string);
            recordableTextAction.putValue("ShortDescription", string);
        } else if (recordableTextAction.isEnabled()) {
            recordableTextAction.setEnabled(false);
            string = this.cantRedoText;
            recordableTextAction.putValue("Name", string);
            recordableTextAction.putValue("ShortDescription", string);
        }
    }

    class RCompoundEdit
    extends CompoundEdit {
        RCompoundEdit() {
        }

        public String getUndoPresentationName() {
            return UIManager.getString("AbstractUndoableEdit.undoText");
        }

        public String getRedoPresentationName() {
            return UIManager.getString("AbstractUndoableEdit.redoText");
        }

        public boolean isInProgress() {
            return false;
        }

        public void undo() throws CannotUndoException {
            if (RUndoManager.this.compoundEdit != null) {
                RUndoManager.this.compoundEdit.end();
            }
            super.undo();
            RUndoManager.this.compoundEdit = null;
        }
    }
}

