/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.binding.TModelInstanceInfo;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.KeyedReference;

public final class UDDIUtils {
    public static final FindQualifiers EXACT_NAME_MATCH_QUALIFIER;
    static final String WS_I_CONFORMANCE_TMODEL_NAME = "ws-i-org:conformsTo:2002_12";
    private static Hashtable wsiConformanceTable;

    public static BusinessService getBusinessServiceByKey(UDDIProxy uDDIProxy, String string) throws TransportException, UDDIException {
        Vector vector;
        BusinessService businessService = null;
        ServiceDetail serviceDetail = uDDIProxy.get_serviceDetail(string);
        if (serviceDetail != null && (vector = serviceDetail.getBusinessServiceVector()) != null && vector.size() > 0) {
            businessService = (BusinessService)vector.firstElement();
        }
        return businessService;
    }

    public static BusinessEntity getBusinessByKey(UDDIProxy uDDIProxy, String string) throws TransportException, UDDIException {
        Vector vector;
        BusinessEntity businessEntity = null;
        BusinessDetail businessDetail = uDDIProxy.get_businessDetail(string);
        if (businessDetail != null && (vector = businessDetail.getBusinessEntityVector()) != null && vector.size() > 0) {
            businessEntity = (BusinessEntity)vector.firstElement();
        }
        return businessEntity;
    }

    public static TModel getTModelByKey(UDDIProxy uDDIProxy, String string) {
        TModel tModel = null;
        try {
            Vector vector;
            TModelDetail tModelDetail = uDDIProxy.get_tModelDetail(string);
            if (tModelDetail != null && (vector = tModelDetail.getTModelVector()) != null && vector.size() > 0) {
                tModel = (TModel)vector.firstElement();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tModel;
    }

    public static String getWSIConformanceTModelKey(UDDIProxy uDDIProxy) {
        if (uDDIProxy == null) {
            throw new IllegalArgumentException("UDDI proxy cannot be null.");
        }
        String string = null;
        if (wsiConformanceTable.containsKey(uDDIProxy)) {
            string = wsiConformanceTable.get(uDDIProxy).toString();
        } else {
            string = UDDIUtils.getTModelKeyByName(uDDIProxy, WS_I_CONFORMANCE_TMODEL_NAME);
            if (string == null) {
                throw new IllegalStateException("WS-I conformance taxonomy tModel was not found");
            }
            wsiConformanceTable.put(uDDIProxy, string);
        }
        return string;
    }

    public static String getTModelKeyByName(UDDIProxy uDDIProxy, String string) {
        String string2 = null;
        try {
            TModelList tModelList = uDDIProxy.find_tModel(string, null, null, EXACT_NAME_MATCH_QUALIFIER, 1);
            TModelInfo tModelInfo = (TModelInfo)tModelList.getTModelInfos().getTModelInfoVector().firstElement();
            string2 = tModelInfo.getTModelKey();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public static String bindingTemplateToString(BindingTemplate bindingTemplate) {
        String string = "";
        if (bindingTemplate == null) {
            string = "null";
        } else {
            string = "accessPoint: " + (bindingTemplate.getAccessPoint() == null ? "null" : bindingTemplate.getAccessPoint().getText());
            if (bindingTemplate.getTModelInstanceDetails() == null || bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfoVector() == null) {
                string = string + ", [no tModel reference]";
            } else {
                Iterator iterator = bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfoVector().iterator();
                int n = 1;
                while (iterator.hasNext()) {
                    TModelInstanceInfo tModelInstanceInfo = (TModelInstanceInfo)iterator.next();
                    string = string + ", [" + n++ + "] tModelKey: " + tModelInstanceInfo.getTModelKey();
                }
            }
        }
        return string;
    }

    public static String tModelToString(TModel tModel) {
        String string = "";
        string = tModel == null ? "null" : "name: " + tModel.getNameString() + ", categoryBag: " + (tModel.getCategoryBag() == null ? "null" : UDDIUtils.categoryBagToString(tModel.getCategoryBag())) + ", overviewURL: " + (tModel.getOverviewDoc() == null ? "null" : tModel.getOverviewDoc().getOverviewURLString());
        return string;
    }

    public static String categoryBagToString(CategoryBag categoryBag) {
        String string = "";
        if (categoryBag == null) {
            string = string + "null";
        } else {
            string = string + "KeyedReferenceList: ";
            Vector vector = null;
            vector = categoryBag.getKeyedReferenceVector();
            if (vector == null) {
                string = string + "null";
            } else if (vector.size() == 0) {
                string = string + "empty";
            } else {
                KeyedReference keyedReference = null;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    keyedReference = (KeyedReference)iterator.next();
                    string = string + "tModelKey: " + keyedReference.getTModelKey() + ", keyName: " + keyedReference.getKeyName() + ", keyValue: " + keyedReference.getKeyValue();
                }
            }
        }
        return string;
    }

    static {
        Vector<FindQualifier> vector = new Vector<FindQualifier>();
        EXACT_NAME_MATCH_QUALIFIER = new FindQualifiers();
        vector.add(new FindQualifier("exactNameMatch"));
        vector.add(new FindQualifier("sortByNameAsc"));
        EXACT_NAME_MATCH_QUALIFIER.setFindQualifierVector(vector);
        wsiConformanceTable = new Hashtable();
    }
}

