/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.w3c.dom.Element;
import org.wsi.WSIConstants;
import org.wsi.test.ToolInfo;
import org.wsi.test.common.AddStyleSheet;
import org.wsi.util.Utils;
import org.wsi.util.WSIProperties;
import org.wsi.xml.XMLUtils;

public final class TestUtils {
    public static final void parseAddStyleSheet(Element element, AddStyleSheet addStyleSheet, String string) {
        addStyleSheet.setHref(XMLUtils.getAttributeValue(element, "href", string));
        addStyleSheet.setType(XMLUtils.getAttributeValue(element, "type", "text/xsl"));
        addStyleSheet.setTitle(XMLUtils.getAttributeValue(element, "title"));
        addStyleSheet.setMedia(XMLUtils.getAttributeValue(element, "media"));
        addStyleSheet.setCharset(XMLUtils.getAttributeValue(element, "charset"));
        addStyleSheet.setAlternate(XMLUtils.getAttributeValue(element, "alternate"));
    }

    public static void printToolInfo(ToolInfo toolInfo) {
        System.out.println("Conformance " + toolInfo.getName() + " Tool" + ", Version: " + toolInfo.getVersion() + ", Release Date: " + toolInfo.getReleaseDate());
        System.out.println("Copyright (C) 2002-2003 by The Web Services-Interoperability Organization and Certain of its Members. All Rights Reserved.\nUse of this Material is governed by WS-I licenses included within the documentation.");
        System.out.println(" ");
    }

    public static String getXMLComment() {
        String string = null;
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Utils.getInputStream("comments.xml")));
            string = "";
            while (bufferedReader.ready()) {
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                string = string + string2 + WSIConstants.LINE_SEPARATOR;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String getXMLSchemaLocation() {
        return TestUtils.getSchemaLocation("wsi.analyzer.xmlschema.schema", "common/schemas/XMLSchema.xsd");
    }

    public static String getSOAPSchemaLocation() {
        return TestUtils.getSchemaLocation("wsi.analyzer.soap.schema", "common/schemas/soapEnvelope.xsd");
    }

    public static String getWSDLSchemaLocation() {
        return TestUtils.getSchemaLocation("wsi.analyzer.wsdl.schema", "common/schemas/wsdl11.xsd");
    }

    public static String getWSDLSOAPSchemaLocation() {
        return TestUtils.getSchemaLocation("wsi.analyzer.wsdlsoap.schema", "common/schemas/wsdlsoap.xsd");
    }

    private static String getSchemaLocation(String string, String string2) {
        String string3 = null;
        String string4 = System.getProperty("wsi.home");
        String string5 = WSIProperties.getProperty(string, string2);
        if (string5 != null) {
            if (string4 != null) {
                string3 = string4;
            }
            if (string3 == null) {
                string3 = string5;
            } else {
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                string3 = string3 + string5;
            }
        }
        return string3;
    }
}

