/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSITag;
import org.wsi.test.util.TypesRegistry;
import org.wsi.test.util.WSDLUtil;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.wsdl.traversal.WSDLVisitor;
import org.wsi.xml.XMLUtils;

public final class OperationSignature {
    private boolean isDocumentStyle = false;
    private boolean isCreated = false;
    private boolean isFault = false;
    protected List signature = new LinkedList();
    private Element firstBody = null;

    public OperationSignature(Document document) {
        Element element = XMLUtils.findChildElement(document.getDocumentElement(), WSITag.ELEM_SOAP_BODY);
        this.processParts(element, false);
        this.isDocumentStyle |= this.signature.size() > 1;
    }

    public OperationSignature(List list, Document document, TypesRegistry typesRegistry, boolean bl) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Part part = (Part)iterator.next();
                String string = bl ? part.getName() : null;
                QName qName = part.getTypeName();
                QName qName2 = part.getElementName();
                String string2 = "";
                if (qName != null) {
                    string2 = "";
                    if (string == null) {
                        string = qName.getLocalPart();
                    }
                } else if (qName2 != null) {
                    string2 = qName2.getNamespaceURI();
                    if (string == null) {
                        string = qName2.getLocalPart();
                    }
                }
                this.signature.add(new QName(string2, string));
            }
        }
        this.isCreated = true;
    }

    public void createRPCSignature() {
        this.isCreated = false;
        if (this.firstBody == null) {
            return;
        }
        this.processParts(this.firstBody, true);
        this.isDocumentStyle = false;
    }

    private void processParts(Node node, boolean bl) {
        if (node != null) {
            boolean bl2 = true;
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (1 != node2.getNodeType()) continue;
                if (bl2 && this.firstBody == null) {
                    bl2 = false;
                    this.firstBody = (Element)node2;
                    if (XMLUtils.equals(node2, WSITag.ELEM_SOAP_FAULT)) {
                        this.isFault = true;
                        this.isCreated = false;
                        return;
                    }
                }
                String string = node2.getNamespaceURI();
                String string2 = node2.getLocalName();
                if (!this.isDocumentStyle && bl) {
                    string = "";
                }
                if ((string == null || string.length() == 0) && this.isDocumentStyle) {
                    Node node3;
                    for (node3 = node2.getFirstChild(); node3 != null && !(node3 instanceof Element); node3 = node3.getNextSibling()) {
                    }
                    if (node3 != null) {
                        string = node3.getNamespaceURI();
                    }
                }
                if (string != null && string.length() == 0) {
                    string = null;
                }
                this.signature.add(new QName(string, string2));
            }
        } else {
            this.isCreated = false;
            return;
        }
        this.isCreated = true;
    }

    public boolean isDocumentStyle() {
        return this.isDocumentStyle;
    }

    public boolean isFault() {
        return this.isFault;
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public List getSignature() {
        return this.signature;
    }

    public int hashCode() {
        return ((Object)this.signature).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof OperationSignature) {
            return ((Object)this.signature).equals(((OperationSignature)object).getSignature());
        }
        return false;
    }

    public static OperationMatch matchOperation(Document document, String string, Binding binding, TypesRegistry typesRegistry) {
        return OperationSignature.matchOperation(document, string, binding, typesRegistry, true);
    }

    public static OperationMatch matchOperation(Document document, String string, Binding binding, TypesRegistry typesRegistry, boolean bl) {
        OperationSignature operationSignature = new OperationSignature(document);
        if (!operationSignature.isCreated()) {
            return null;
        }
        OperationSignature operationSignature2 = operationSignature;
        operationSignature2.getClass();
        Visitor visitor = operationSignature2.new Visitor("document", typesRegistry);
        if (string != null && string.length() > 1 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        if (string != null) {
            operationSignature.getSignature().add(0, string);
        }
        if (bl) {
            visitor.setSOAPActionRequired();
        }
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(visitor);
        wSDLTraversal.visitSOAPBinding(true);
        wSDLTraversal.visitSOAPBody(true);
        wSDLTraversal.visitSOAPOperation(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.ignoreBindingOutput();
        wSDLTraversal.traverse(binding);
        BindingOperation bindingOperation = visitor.getMatchedOperation();
        if (bindingOperation == null && !operationSignature.isDocumentStyle()) {
            visitor.setRequiredStyle("rpc");
            operationSignature.createRPCSignature();
            wSDLTraversal.traverse(binding);
            bindingOperation = visitor.getMatchedOperation();
            if (bindingOperation == null) {
                return null;
            }
        }
        return new OperationMatch(visitor.requiredStyle, operationSignature.getSignature(), visitor.getMatchedOperation());
    }

    public final class Visitor
    implements WSDLVisitor {
        private String requiredStyle = null;
        private String soapAction = null;
        private BindingOperation operation = null;
        private TypesRegistry registry = null;
        private boolean isSOAPActionRequired = false;

        public void visit(Part part, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Service service, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Types types, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Operation operation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Input input, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Output output, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Fault fault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Binding binding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(BindingOperation bindingOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(BindingInput bindingInput, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(BindingOutput bindingOutput, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(BindingFault bindingFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Import import_, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Element element, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Message message, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Port port, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(PortType portType, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(Definition definition, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(ExtensibilityElement extensibilityElement, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(SOAPHeader sOAPHeader, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(SOAPHeaderFault sOAPHeaderFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public void visit(SOAPFault sOAPFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        }

        public Visitor() {
        }

        public Visitor(String string, TypesRegistry typesRegistry) {
            this.requiredStyle = string;
            this.registry = typesRegistry;
        }

        public BindingOperation getMatchedOperation() {
            return this.operation;
        }

        public void setRequiredStyle(String string) {
            this.requiredStyle = string;
        }

        public boolean isSOAPActionRequired() {
            return this.isSOAPActionRequired;
        }

        public void setSOAPActionRequired() {
            this.isSOAPActionRequired = true;
        }

        public void visit(SOAPBinding sOAPBinding, Object object, WSDLTraversalContext wSDLTraversalContext) {
            String string = sOAPBinding.getStyle() == null ? "document" : sOAPBinding.getStyle();
            wSDLTraversalContext.addParameter("style", string);
        }

        public void visit(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
            this.soapAction = null;
            String string = sOAPOperation.getStyle();
            if (string == null) {
                string = (String)wSDLTraversalContext.getParameter("style");
            }
            if (!this.requiredStyle.equals(string)) {
                wSDLTraversalContext.cancelBindingOperationProcessing();
            } else {
                this.soapAction = sOAPOperation.getSoapActionURI();
            }
        }

        public void visit(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
            Object object2;
            BindingOperation bindingOperation = wSDLTraversalContext.getBindingOperation();
            if (bindingOperation.getOperation() == null || bindingOperation.getOperation().getInput() == null || bindingOperation.getOperation().getInput().getMessage() == null) {
                return;
            }
            Message message = bindingOperation.getOperation().getInput().getMessage();
            List list = WSDLUtil.getParts(bindingOperation.getOperation(), message, sOAPBody, this.requiredStyle);
            QName qName = null;
            if ("rpc".equals(this.requiredStyle)) {
                object2 = sOAPBody.getNamespaceURI();
                if (object2 == null || ((String)object2).length() == 0) {
                    object2 = wSDLTraversalContext.getBinding().getQName().getNamespaceURI();
                }
                qName = new QName((String)object2, wSDLTraversalContext.getBindingOperation().getName());
            }
            object2 = new OperationSignature(list, null, this.registry, false);
            if (qName != null) {
                ((OperationSignature)object2).getSignature().add(0, qName);
            }
            if (this.isSOAPActionRequired && this.soapAction != null) {
                ((OperationSignature)object2).getSignature().add(0, this.soapAction);
            }
            if (((Object)((OperationSignature)object2).getSignature()).equals(OperationSignature.this.signature)) {
                this.operation = wSDLTraversalContext.getBindingOperation();
                wSDLTraversalContext.cancelBindingOperationProcessing();
                wSDLTraversalContext.cancelBindingProcessing();
            } else {
                object2 = new OperationSignature(list, null, this.registry, true);
                if (qName != null) {
                    ((OperationSignature)object2).getSignature().add(0, qName);
                }
                if (this.isSOAPActionRequired && this.soapAction != null) {
                    ((OperationSignature)object2).getSignature().add(0, this.soapAction);
                }
                if (((Object)((OperationSignature)object2).getSignature()).equals(OperationSignature.this.signature)) {
                    this.operation = wSDLTraversalContext.getBindingOperation();
                    wSDLTraversalContext.cancelBindingOperationProcessing();
                    wSDLTraversalContext.cancelBindingProcessing();
                }
            }
        }
    }

    public static final class OperationMatch {
        private final String style;
        private final BindingOperation operation;
        private final List signature;

        protected OperationMatch(String string, List list, BindingOperation bindingOperation) {
            this.style = string;
            this.signature = list;
            this.operation = bindingOperation;
        }

        public String getOperationStyle() {
            return this.style;
        }

        public BindingOperation getOperation() {
            return this.operation;
        }

        public List getSignature() {
            return this.signature;
        }
    }
}

