/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.wsi.test.util.NullUtil;
import org.wsi.test.util.Pair;

public final class ErrorList {
    private Set errors = new HashSet();
    private MessageFormat format = new MessageFormat("{0}:{1}");
    private FieldPosition pos = new FieldPosition(0);

    public ErrorList() {
    }

    public ErrorList(List list) {
        this.add(list);
    }

    public ErrorList(MessageFormat messageFormat) {
        if (messageFormat != null) {
            this.format = messageFormat;
        }
    }

    public void add(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.add((String)iterator.next());
        }
    }

    public void add(String string, String string2) {
        this.errors.add(new Pair(string, string2));
    }

    public void add(QName qName, String string) {
        this.errors.add(new Pair(NullUtil.toString(qName), string));
    }

    public void add(QName qName, QName qName2) {
        this.errors.add(new Pair(NullUtil.toString(qName), NullUtil.toString(qName2)));
    }

    public void add(QName qName) {
        this.errors.add(new Pair(NullUtil.toString(qName), null));
    }

    public void add(String string) {
        this.errors.add(new Pair(string, null));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            if (pair.getFirst() != null && pair.getSecond() != null) {
                this.format.format(new Object[]{pair.getFirst(), pair.getSecond()}, stringBuffer, this.pos);
            } else if (pair.getFirst() != null) {
                stringBuffer.append(pair.getFirst());
            } else {
                stringBuffer.append(pair.getSecond());
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",\n");
        }
        return stringBuffer.toString();
    }

    public boolean isEmpty() {
        return this.errors.size() == 0;
    }
}

