/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.util;

public class BasicRules {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final char DQ = '\"';
    public static final String CRLF = "\r\n";
    public static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};

    public static boolean isOCTET(char c) {
        return true;
    }

    public static boolean isCHAR(char c) {
        return c >= '\u0000' && c <= '\u007f';
    }

    public static boolean isUPALPHA(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLOALPHA(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isALPHA(char c) {
        return BasicRules.isLOALPHA(c) || BasicRules.isUPALPHA(c);
    }

    public static boolean isDIGIT(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isCTL(char c) {
        return c >= '\u0000' && c <= '\u001f' || c == '\u007f';
    }

    public static boolean isCR(char c) {
        return c == '\r';
    }

    public static boolean isLF(char c) {
        return c == '\n';
    }

    public static boolean isSP(char c) {
        return c == ' ';
    }

    public static boolean isHT(char c) {
        return c == '\t';
    }

    public static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    public static boolean isCRLF(String string) {
        return CRLF.equals(string);
    }

    public static boolean isLWS(String string) {
        int n = BasicRules.getLastIndexLWS(string, 0);
        return n != -1 && n == string.length();
    }

    public static int getLastIndexLWS(String string, int n) {
        int n2 = string.indexOf(CRLF, n);
        if (n2 == -1) {
            n2 = n;
        } else if (n2 == n) {
            n2 += CRLF.length();
        } else {
            return -1;
        }
        if (!BasicRules.isSP(string.charAt(n2)) && BasicRules.isHT(string.charAt(n2))) {
            return -1;
        }
        ++n2;
        while (n2 < string.length()) {
            if (!BasicRules.isSP(string.charAt(n2)) && BasicRules.isHT(string.charAt(n2))) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    public static int getLastTEXT(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            if (!BasicRules.isOCTET(string.charAt(n2))) {
                return n2;
            }
            if (!BasicRules.isCTL(string.charAt(n2))) continue;
            int n3 = BasicRules.getLastIndexLWS(string, n2);
            if (n3 == -1) {
                return n2;
            }
            n2 = n3 - 1;
        }
        return n2;
    }

    public static boolean isHEX(char c) {
        return c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || BasicRules.isDIGIT(c);
    }

    public static boolean isToken(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (BasicRules.isCHAR(c) && !BasicRules.isSEPARATOR(c) && !BasicRules.isCTL(c)) continue;
            return false;
        }
        return true;
    }

    public static int getLastToken(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (BasicRules.isCHAR(c) && !BasicRules.isSEPARATOR(c) && !BasicRules.isCTL(c)) continue;
            return n2;
        }
        return n2;
    }

    public static boolean isSEPARATOR(char c) {
        for (int i = 0; i < SEPARATORS.length; ++i) {
            if (c != SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }

    public static int getLastComment(String string, int n) {
        int n2 = n;
        if (string.length() <= n) {
            return n;
        }
        if (string.charAt(n2) != '(') {
            return n;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n3 = n + 1;
        while (!bl) {
            while (!bl2) {
                if ((n3 = BasicRules.getLastCtext(string, n3)) == string.length()) {
                    return n3;
                }
                if (!BasicRules.isQuotedPair(string, n3 - 1)) {
                    bl2 = true;
                    continue;
                }
                ++n3;
            }
            if (string.charAt(n3) == '(') {
                int n4 = BasicRules.getLastComment(string, n3);
                continue;
            }
            if (string.charAt(n3) != ')') continue;
            return n3 + 1;
        }
        return n3;
    }

    private static int getLastCtext(String string, int n) {
        int n2;
        int n3 = BasicRules.getLastTEXT(string, n);
        for (n2 = n; n2 < n3 && string.charAt(n2) != '(' && string.charAt(n2) != ')'; ++n2) {
        }
        if (n2 < n3) {
            n3 = n2;
        }
        return n3;
    }

    private static int getLastQdtext(String string, int n) {
        int n2;
        int n3 = BasicRules.getLastTEXT(string, n);
        for (n2 = n; n2 < n3 && string.charAt(n2) != '\"'; ++n2) {
        }
        if (n2 < n3) {
            n3 = n2;
        }
        return n3;
    }

    public static boolean isQuotedPair(String string, int n) {
        return string.length() >= n + 2 && string.charAt(n) == '\\' && BasicRules.isCHAR(string.charAt(n + 1));
    }

    public static int getLastQuotedString(String string, int n) {
        int n2;
        block5: {
            n2 = n;
            boolean bl = false;
            if (n == string.length()) {
                return n;
            }
            if (string.charAt(n2) != '\"') {
                return n;
            }
            ++n2;
            do {
                if ((n2 = BasicRules.getLastQdtext(string, n2)) == string.length()) {
                    return n;
                }
                if (!BasicRules.isQuotedPair(string, n2 - 1)) break block5;
            } while (++n2 != string.length());
            return n;
        }
        if (string.charAt(n2) != '\"') {
            return n;
        }
        return ++n2;
    }
}

